/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workscope;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.workscope.WorkScopeHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class WorkScopeDetailListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"iptchecktype", (CharSequence)key)) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"mpdm_checktype", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checktype"));
            List pks = WorkScopeHelper.queryUserdCheckType();
            QFilter qFilter = new QFilter("id", "not in", (Object)pks);
            showParameter.getListFilterParameter().setFilter(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"checktype", (CharSequence)actionId)) {
            this.checkTypeCloseBack(event);
        }
    }

    private void checkTypeCloseBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)event.getReturnData();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        List pks = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", pks);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"mpdm_checktype", (String)"id,name,description", (QFilter[])qFilter.toArray());
        DynamicObject[] details = new DynamicObject[objs.length];
        EntityType entityType = ((ListView)this.getView()).getListModel().getDataEntityType();
        long org = Long.parseLong(this.getPageCache().get("createOrg"));
        DynamicObject orgObj = this.getModel().loadReferenceData((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"), (Object)org);
        long[] ids = ID.genLongIds((int)objs.length);
        HashMap<Long, String> numberMap = new HashMap<Long, String>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj = objs[i];
            DynamicObject detail = new DynamicObject((DynamicObjectType)entityType);
            long id = ids[i];
            detail.set("id", (Object)id);
            detail.set("name", obj.get("name"));
            detail.set("status", (Object)"A");
            detail.set("creator", (Object)RequestContext.get().getCurrUserId());
            detail.set("ischecktype", (Object)Boolean.TRUE);
            detail.set("checktype", (Object)obj);
            detail.set("createorg", (Object)orgObj);
            detail.set("useorg", (Object)orgObj);
            detail.set("org", (Object)orgObj);
            detail.set("detailstate", obj.get("description"));
            detail.set("enable", (Object)"1");
            details[i] = detail;
            numberMap.put(id, obj.getString("number"));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityType.getName(), (DynamicObject[])details, (OperateOption)OperateOption.create());
        List errorMsgs = result.getAllErrorOrValidateInfo();
        for (IOperateInfo errorMsg : errorMsgs) {
            Object pk = errorMsg.getPkValue();
            String number = (String)numberMap.get(pk);
            String msg = errorMsg.getMessage();
            msg = String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u7ea7\u522b\uff1a%1$s %2$s", (String)"WorkScopeDetailListPlugin_1", (String)"bd-mpdm-formplugin", (Object[])new Object[0]), number, msg);
            if (!(errorMsg instanceof OperateErrorInfo)) continue;
            ((OperateErrorInfo)errorMsg).setMessage(msg);
        }
        if (result.isSuccess()) {
            result.setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WorkScopeDetailListPlugin_0", (String)"bd-mpdm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showOperationResult(result);
        ((ListView)this.getView()).refresh();
    }
}

