/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workscope;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.workscope.WorkScopeHelper;
import kd.bd.mpdm.formplugin.workscope.WorkScopeTplEditPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;

public class WorkScopeEditPlugin
extends WorkScopeTplEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit workcate = (BasedataEdit)this.getControl("workcate");
        workcate.addBeforeF7SelectListener(arg -> {
            DynamicObjectCollection objs = this.getModel().getEntryEntity("workcategory");
            List ids = objs.stream().filter(i -> i.get("workcate") != null).map(i -> i.getDynamicObject("workcate").getPkValue()).collect(Collectors.toList());
            arg.addCustomQFilter(new QFilter("id", "not in", ids));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDetail();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "workcate": {
                this.workTypeChanged(e);
                this.createDetail(e);
                break;
            }
            case "select": 
            case "combotype": 
            case "combosymbol": 
            case "connector": {
                this.createDetail(e);
                break;
            }
            case "priority": {
                this.priorityChanged(e);
                this.createDetail(e);
            }
        }
    }

    private void workTypeChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject workType = (DynamicObject)changeData.getNewValue();
        int index = changeData.getRowIndex();
        BaseModel model = (BaseModel)this.getModel();
        if (workType == null) {
            model.deleteEntryData("workdetail");
            model.setValue("typedesc", null, index);
            this.getView().updateView("workdetail");
            return;
        }
        DynamicObject workCate = WorkScopeHelper.queryWorkCategoryByPk((Object)workType.getPkValue());
        if (workCate == null) {
            return;
        }
        DynamicObjectCollection workcategory = model.getEntryEntity("workcategory");
        DynamicObject workTypeObj = (DynamicObject)workcategory.get(index);
        DynamicObjectCollection workTypeDetails = workTypeObj.getDynamicObjectCollection("workdetail");
        DynamicObjectCollection workDetails = workCate.getDynamicObjectCollection("detailentry");
        for (DynamicObject detail : workDetails) {
            DynamicObject workdetail = detail.getDynamicObject("workdetail");
            if (workdetail == null || !StringUtils.equals((CharSequence)"1", (CharSequence)workdetail.getString("enable"))) continue;
            DynamicObject detailObj = workTypeDetails.addNew();
            detailObj.set("details", (Object)workdetail);
        }
        this.getView().updateView("workdetail");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)"workcategory", (CharSequence)key)) {
            RowDataEntity entity = e.getRowDataEntities()[0];
            int index = entity.getRowIndex();
            if (index == 0) {
                return;
            }
            DynamicObjectCollection objs = this.getModel().getEntryEntity("workcategory");
            int priority = objs.stream().map(i -> i.getInt("priority")).max(Integer::compareTo).get();
            this.getModel().setValue("priority", (Object)(priority + 1), index);
        }
    }

    private void initDetail() {
        BaseModel model = (BaseModel)this.getModel();
        DynamicObjectCollection workcategory = model.getEntryEntity("workcategory");
        List workcategoryIds = workcategory.stream().filter(i -> i.get("workcate") != null).map(i -> i.getDynamicObject("workcate").getPkValue()).collect(Collectors.toList());
        DynamicObject[] workCates = WorkScopeHelper.queryWorkCategoryByPks(workcategoryIds);
        if (workCates == null) {
            return;
        }
        HashMap<Object, DynamicObject> workcategoryMap = new HashMap<Object, DynamicObject>(workcategory.size());
        for (DynamicObject object : workcategory) {
            workcategoryMap.put(object.get("workcate_id"), object);
        }
        for (DynamicObject workDetail : workCates) {
            DynamicObjectCollection detailentry = workDetail.getDynamicObjectCollection("detailentry");
            HashMap<Object, DynamicObject> detailentryMap = new HashMap<Object, DynamicObject>(detailentry.size());
            for (DynamicObject detail : detailentry) {
                DynamicObject workScopeDetail = detail.getDynamicObject("workdetail");
                if (workScopeDetail == null) continue;
                detailentryMap.put(workScopeDetail.getPkValue(), workScopeDetail);
            }
            DynamicObject workCate = (DynamicObject)workcategoryMap.get(workDetail.getPkValue());
            DynamicObjectCollection workCateDetails = workCate.getDynamicObjectCollection("workdetail");
            HashMap<Object, DynamicObject> workCateDetailsMap = new HashMap<Object, DynamicObject>(workCateDetails.size());
            Iterator it = workCateDetails.iterator();
            while (it.hasNext()) {
                DynamicObject workCateDetail = (DynamicObject)it.next();
                DynamicObject detailId = workCateDetail.getDynamicObject("details");
                if (detailId == null) continue;
                DynamicObject detail = (DynamicObject)detailentryMap.get(detailId.getPkValue());
                if (detail == null) {
                    it.remove();
                    continue;
                }
                workCateDetailsMap.put(detailId.getPkValue(), detailId);
            }
            for (DynamicObject detail : detailentry) {
                DynamicObject detailId = detail.getDynamicObject("workdetail");
                if (detailId == null || StringUtils.equals((CharSequence)"0", (CharSequence)detailId.getString("enable")) || workCateDetailsMap.containsKey(detailId.getPkValue())) continue;
                DynamicObject detailObj = workCateDetails.addNew();
                detailObj.set("detail", (Object)detailId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean def;
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)key) || StringUtils.equals((CharSequence)"submit", (CharSequence)key)) && (def = ((Boolean)this.getModel().getValue("def")).booleanValue())) {
            WorkScopeHelper.setDefTpl((Object)this.getModel().getDataEntity().getPkValue());
        }
    }
}

