/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workscope;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class WorkScopeF7Plugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("workscope");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener(this::beforeF7Select);
            basedataEdit.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        }
    }

    public void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        event.setCancel(true);
        this.showWorkScopeForm();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        event.getFormShowParameter();
        String method = event.getSourceMethod();
        if ("getLookUpList".equals(method)) {
            event.setCancel(true);
            return;
        }
        if (!"click".equals(method)) {
            return;
        }
        event.setCancel(true);
        this.showWorkScopeForm();
    }

    private void showWorkScopeForm() {
        DynamicObject workscope = (DynamicObject)this.getModel().getValue("workscope");
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("mpdm_workscopeins");
        String entityId = this.getView().getEntityId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String statusField = "status";
        if (!entityType.getProperties().containsKey((Object)"status")) {
            statusField = "billstatus";
        }
        String status = (String)this.getModel().getValue(statusField);
        OperationStatus operationStatus = OperationStatus.ADDNEW;
        if (workscope != null) {
            baseShowParameter.setPkId(workscope.getPkValue());
            baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
            operationStatus = "A".equals(status) ? OperationStatus.EDIT : OperationStatus.VIEW;
        }
        baseShowParameter.setStatus(operationStatus);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "workscope"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.cacheWorKScopeTpl();
    }

    public void cacheWorKScopeTpl() {
        IDataEntityProperty dp;
        DynamicObject workscope = (DynamicObject)this.getModel().getValue("workscope");
        if (workscope != null && (dp = (IDataEntityProperty)workscope.getDataEntityType().getProperties().get((Object)"workscopetpl_id")) != null) {
            this.getPageCache().put("workscopetplid", String.valueOf(workscope.getLong("workscopetpl_id")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)"workscope", (CharSequence)actionId)) {
            DynamicObject wsPk = (DynamicObject)event.getReturnData();
            this.getPageCache().remove("workscopechange");
            this.getPageCache().remove("workscopetplchange");
            if (wsPk != null) {
                DynamicObject workscope = (DynamicObject)this.getModel().getValue("workscope");
                if (workscope != null && workscope.getLong("id") == wsPk.getLong("id")) {
                    long workscopetpl = wsPk.getLong("workscopetpl_id");
                    String workscopetplid = this.getPageCache().get("workscopetplid");
                    if (workscopetplid == null || Long.parseLong(workscopetplid) != workscopetpl) {
                        this.getPageCache().put("workscopetplchange", "true");
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue("workscope", null);
                    this.getModel().endInit();
                    this.getPageCache().put("workscopetplid", String.valueOf(workscopetpl));
                } else {
                    this.getPageCache().put("workscopechange", "true");
                }
                this.getModel().setValue("workscope", (Object)wsPk);
            }
        }
    }
}

