/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.mpdm.formplugin.workscope;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.workscope.WorkScopeHelper;
import kd.bd.mpdm.formplugin.workscope.WorkScopeTplEditPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.util.CollectionUtils;

public class WorkScopeInsEditPlugin
extends WorkScopeTplEditPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (!"number".equals(key)) {
            this.getPageCache().remove("isaddnew");
        }
        switch (key) {
            case "select": 
            case "combotype": 
            case "combosymbol": 
            case "connector": {
                this.createDetail(e);
                break;
            }
            case "workscopetpl": {
                DynamicObject workScopeTel = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.workScopeTplChanged(workScopeTel, true);
                this.getView().updateView("workcategory");
                this.getView().updateView("workdetail");
                break;
            }
            case "priority": {
                this.priorityChanged(e);
                this.createDetail(e);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            DynamicObject defTpl = WorkScopeHelper.getDefTpl();
            this.getModel().beginInit();
            this.getModel().setValue("workscopetpl", (Object)defTpl);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
            this.workScopeTplChanged(defTpl, false);
            this.getPageCache().put("isaddnew", "1");
        }
    }

    private void workScopeTplChanged(DynamicObject workScopeTel, boolean flag) {
        String wDetail;
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        dataModel.deleteEntryData("workcategory");
        dataModel.setValue("contentdetail", null);
        dataModel.setValue("contentdetail_tag", null);
        if (workScopeTel == null) {
            return;
        }
        workScopeTel = WorkScopeHelper.queryWorkScopeTpl((Object)workScopeTel.getPkValue());
        String comboType = workScopeTel.getString("combotype");
        String combosymbol = workScopeTel.getString("combosymbol");
        dataModel.setValue("combotype", (Object)comboType);
        dataModel.setValue("combosymbol", (Object)combosymbol);
        StringBuilder wsDetailString = new StringBuilder();
        DynamicObjectCollection wsworkcategorys = workScopeTel.getDynamicObjectCollection("workcategory");
        if (CollectionUtils.isEmpty((Collection)wsworkcategorys)) {
            return;
        }
        List workCateIds = wsworkcategorys.stream().filter(i -> {
            DynamicObject wsworkCate = i.getDynamicObject("workcate");
            return wsworkCate != null && StringUtils.equals((CharSequence)"1", (CharSequence)wsworkCate.getString("enable"));
        }).map(i -> i.getDynamicObject("workcate").getPkValue()).collect(Collectors.toList());
        DynamicObject[] workCates = WorkScopeHelper.queryWorkCategoryByPks(workCateIds);
        HashMap<Object, DynamicObject> workcategoryMap = new HashMap<Object, DynamicObject>(workCateIds.size());
        for (DynamicObject object : workCates) {
            workcategoryMap.put(object.getPkValue(), object);
        }
        DynamicObjectCollection workcategorys = dataModel.getEntryEntity("workcategory");
        for (DynamicObject wsworkcategory : wsworkcategorys) {
            DynamicObject wsworkCate = wsworkcategory.getDynamicObject("workcate");
            if (wsworkCate == null || StringUtils.equals((CharSequence)"0", (CharSequence)wsworkCate.getString("enable"))) continue;
            DynamicObject workcategory = workcategorys.addNew();
            String con = wsworkcategory.getString("connector");
            workcategory.set("priority", wsworkcategory.get("priority"));
            workcategory.set("workcate", (Object)wsworkCate);
            workcategory.set("connector", (Object)con);
            DynamicObject workCate = (DynamicObject)workcategoryMap.get(wsworkCate.getPkValue());
            DynamicObjectCollection workCateDetials = workCate.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection wsworkdetails = wsworkcategory.getDynamicObjectCollection("workdetail");
            Map wsworkdetailsMap = wsworkdetails.stream().filter(i -> i.getDynamicObject("details") != null).collect(Collectors.toMap(i -> i.getDynamicObject("details").getPkValue(), Function.identity()));
            DynamicObjectCollection workdetails = workcategory.getDynamicObjectCollection("workdetail");
            for (DynamicObject wsworkdetail : workCateDetials) {
                DynamicObject wsworkScopeDetail = wsworkdetail.getDynamicObject("workdetail");
                if (wsworkScopeDetail == null || StringUtils.equals((CharSequence)"0", (CharSequence)wsworkScopeDetail.getString("enable"))) continue;
                DynamicObject workdetail = workdetails.addNew();
                Object detailId = wsworkScopeDetail.getPkValue();
                DynamicObject wsDetail = (DynamicObject)wsworkdetailsMap.get(detailId);
                if (wsDetail != null) {
                    workdetail.set("select", wsDetail.get("select"));
                }
                workdetail.set("details", (Object)wsworkScopeDetail);
            }
            String typeDesc = this.creatEntryDetail(workCate.getString("name"), workdetails, con, combosymbol, comboType);
            if (typeDesc.length() > 0) {
                wsDetailString.append(typeDesc).append(con);
            }
            workcategory.set("typedesc_tag", (Object)typeDesc);
            if (typeDesc.length() > 255) {
                workcategory.set("typedesc", (Object)typeDesc.substring(0, 255));
                continue;
            }
            workcategory.set("typedesc", (Object)typeDesc);
        }
        if (wsDetailString.length() > 0) {
            wsDetailString.deleteCharAt(wsDetailString.length() - 1);
        }
        if ((wDetail = wsDetailString.toString()).length() > 255) {
            this.getModel().setValue("contentdetail", (Object)wDetail.substring(0, 255));
        } else {
            this.getModel().setValue("contentdetail", (Object)wDetail);
        }
        this.getModel().setValue("contentdetail_tag", (Object)wDetail);
        if (flag) {
            dataModel.updateEntryCache(workcategorys);
        }
        dataModel.endInit();
        this.getView().updateView("workcategory");
        this.getView().updateView("workdetail");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("1".equals(this.getPageCache().get("isaddnew"))) {
            this.getModel().setDataChanged(false);
        }
    }
}

