/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.mmc.operation.validator.ConfigEntryEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;

public class CheckMTOStrategyValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CheckMTOStrategyValidator.class);
    private static final String[] ARR = new String[]{"GZ004", "GZ005", "GZ007"};
    private static final String SAVE = "save";
    private static final String IMPORTTYPE = "importtype";
    private static final String NOTCHECK_OTHERS_BIZTYPE = "notcheck_others_biztype";
    private static final String NOTCHECK_OTHERS_BIZTYPENAME = "notcheck_others_biztypename";
    private static final String GZ001 = "GZ001";
    private static final String GZ002 = "GZ002";
    private static final String GZ003 = "GZ003";
    private static final String GZ004 = "GZ004";
    private static final String GZ007 = "GZ007";
    private static final String GZ005 = "GZ005";
    private final String key_seq = "seq";
    private final String key_org = "org";
    private final String key_materialinv = "materialinv";
    private final String key_tracknumber = "tracknumber";
    private final String key_project = "project";
    private final String key_material = "material";
    private final String key_entryseq = "entryseq";
    private final String key_subentryseq = "key_subentryseq";
    private final String key_configcode = "configcode";

    public void validate() {
        Long startTime = System.currentTimeMillis();
        log.warn("--------CheckMTOStrategyValidator BEGIN------------");
        if (SAVE.equals(this.getOperateKey()) && !this.getOption().getVariables().containsKey(IMPORTTYPE)) {
            return;
        }
        QFilter qf = new QFilter("status", "=", (Object)"C");
        QFilter qf1 = new QFilter("enable", "=", (Object)"1");
        QFilter qf2 = new QFilter("entryentity.billentity", "=", (Object)this.entityKey);
        QFilter qf3 = new QFilter("traceway.fbasedataid", "is not null", null);
        QFilter qf4 = new QFilter("tracerange.fbasedataid", "is not null", null);
        if (!QueryServiceHelper.exists((String)"bd_manustrconfig", (QFilter[])new QFilter[]{qf, qf1, qf2})) {
            return;
        }
        MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)this.entityKey);
        DataEntityPropertyCollection properties = appBillMainType.getProperties();
        ArrayList<Map<String, String>> ischeckMapList = new ArrayList<Map<String, String>>();
        ArrayList<ConfigEntryEntity> configList = new ArrayList<ConfigEntryEntity>();
        Long startTime1 = System.currentTimeMillis();
        List<Map<String, String>> filedMapList = this.getFieldMap(ischeckMapList, configList);
        log.warn("--------CheckMTOStrategyValidator getFieldMap End------------" + (System.currentTimeMillis() - startTime1) / 1000L + 's');
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_manustrategydim", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "is not null", (Object)"")}, null);
        for (Row row : queryDataSet) {
            if (!this.getOption().getVariables().containsKey("notcheck_" + row.getString("number").toLowerCase())) continue;
            int n = ischeckMapList.size();
            for (int i = 0; i < n; ++i) {
                ((Map)ischeckMapList.get(i)).remove(row.getString("number"));
                filedMapList.get(i).remove(row.getString("number"));
                ((ConfigEntryEntity)configList.get(i)).getFields().remove(row.getString("number"));
            }
        }
        for (int i = ischeckMapList.size() - 1; i >= 0; --i) {
            if (!((Map)ischeckMapList.get(i)).isEmpty()) continue;
            filedMapList.remove(i);
            ischeckMapList.remove(i);
            configList.remove(i);
        }
        if (ischeckMapList.isEmpty()) {
            return;
        }
        int rowCount = 0;
        int n = filedMapList.size();
        for (int i = 0; i < n; ++i) {
            DynamicObject[] load;
            DataSet billDataSet;
            HashSet<Object> invSet;
            Throwable throwable;
            AlgoContext context;
            boolean isExist;
            Map<String, String> filedMap = filedMapList.get(i);
            ConfigEntryEntity configEntity = (ConfigEntryEntity)configList.get(i);
            HashMap<String, String> headMap = new HashMap<String, String>(8);
            HashMap<String, String> entryMap = new HashMap<String, String>(8);
            Map<String, String> entryEntityMap = this.getEntryFields(headMap, entryMap, filedMap, properties);
            String entryName = "".equals(entryEntityMap.get("entryname")) ? "\u5355\u636e\u4f53" : entryEntityMap.get("entryname");
            String subentryName = "".equals(entryEntityMap.get("subentryname")) ? "\u5b50\u5355\u636e\u4f53" : entryEntityMap.get("subentryname");
            boolean bl = isExist = filedMap.get(GZ005) == null || filedMap.get(GZ004) == null;
            if (isExist && filedMap.get(GZ007) == null) continue;
            if (filedMap.get(GZ007) != null && !"".equals(filedMap.get(GZ007))) {
                startTime1 = System.currentTimeMillis();
                context = Algo.newContext();
                throwable = null;
                try {
                    invSet = new HashSet(this.dataEntities.length);
                    billDataSet = this.buildBillDataSet(entryEntityMap.get("entry"), entryEntityMap.get("subentry"), headMap, entryMap, invSet);
                    DataSet invDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialinventoryinfo", (String)"id invid,manustrategy", (QFilter[])new QFilter[]{qf, qf1, new QFilter("id", "in", invSet)}, null);
                    DataSet finish = billDataSet.leftJoin(invDataSet).select(new String[]{"seq", "org", "materialinv", "tracknumber", "project", "configcode", "entryseq", "key_subentryseq", "invid", "manustrategy"}).on("materialinv", "invid").finish();
                    finish = finish.where("manustrategy != 0 or manustrategy != null");
                    for (DynamicObject obj : load = BusinessDataServiceHelper.load((String)"bd_manustrategy", (String)"id,traceway,tracerange", (QFilter[])new QFilter[]{qf, qf1, qf3, qf4})) {
                        DataSet dataSet = finish.copy().where("manustrategy = " + obj.getPkValue());
                        if (dataSet.isEmpty()) continue;
                        for (Row row : dataSet) {
                            ++rowCount;
                            Set rangeSet = obj.getDynamicObjectCollection("tracerange").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
                            if (!rangeSet.contains(configEntity.getDomain())) continue;
                            Set<String> fields = configEntity.getFields();
                            Set<String> waySet = obj.getDynamicObjectCollection("traceway").stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet());
                            waySet.forEach(traceway -> {
                                if (fields.contains(traceway)) {
                                    if (GZ001.equals(traceway)) {
                                        if (row.get("tracknumber") == null) {
                                            if (row.get("entryseq") == null) {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_0", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                            } else if (row.get("key_subentryseq") == null) {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                            } else {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ddf\u8e2a\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                            }
                                        }
                                    } else if (GZ002.equals(traceway)) {
                                        if (row.get("project") == null) {
                                            if (row.get("entryseq") == null) {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_3", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                            } else if (row.get("key_subentryseq") == null) {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u9879\u76ee\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_4", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                            } else {
                                                this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_5", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                            }
                                        }
                                    } else if (GZ003.equals(traceway) && row.get("configcode") == null) {
                                        if (row.get("entryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_6", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                        } else if (row.get("key_subentryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_7", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                        } else {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_8", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Throwable invSet2) {
                    throwable = invSet2;
                    throw invSet2;
                }
                finally {
                    if (context != null) {
                        if (throwable != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable invSet2) {
                                throwable.addSuppressed(invSet2);
                            }
                        } else {
                            context.close();
                        }
                    }
                }
                log.warn("--------CheckMTOStrategyValidator getFieldMap INVENTORY END------------" + (System.currentTimeMillis() - startTime1) / 1000L + 's');
                continue;
            }
            startTime1 = System.currentTimeMillis();
            context = Algo.newContext();
            throwable = null;
            try {
                DynamicObject[] load2;
                invSet = new HashSet<Object>(this.dataEntities.length);
                billDataSet = this.buildBillDataSet(entryEntityMap.get("entry"), entryEntityMap.get("subentry"), headMap, entryMap, invSet);
                HashMap org4MaterialMap = new HashMap(8);
                DataSet billDataSet1 = billDataSet.copy();
                load = billDataSet1.iterator();
                while (load.hasNext()) {
                    Set<Long> set;
                    Row row = (Row)load.next();
                    if (row.getLong("org") == null || row.getLong("material") == null) continue;
                    Long org = row.getLong("org");
                    Long material = row.getLong("material");
                    if (org4MaterialMap.containsKey(org)) {
                        set = (Set)org4MaterialMap.get(org);
                        set.add(material);
                        continue;
                    }
                    set = new HashSet();
                    set.add(material);
                    org4MaterialMap.put(org, set);
                }
                ArrayList<Field> field = new ArrayList<Field>();
                field.add(new Field("org", (DataType)DateType.LongType, true));
                field.add(new Field("material", (DataType)DateType.IntegerType, true));
                field.add(new Field("materialinv", (DataType)DateType.LongType, true));
                field.add(new Field("manustrategy", (DataType)DateType.LongType, true));
                RowMeta metas = new RowMeta(field.toArray(new Field[0]));
                Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
                DataSetBuilder builder = algo.createDataSetBuilder(metas);
                Object[] rowData = new Object[4];
                builder.append(rowData);
                DataSet build = builder.build();
                for (Map.Entry en : org4MaterialMap.entrySet()) {
                    QFilter qFilterUseOrg = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)en.getKey()));
                    QFilter qFilterMasterid = new QFilter("masterid", "in", en.getValue());
                    DataSet invDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialinventoryinfo", (String)(en.getKey() + " org,masterid material,id materialinv,manustrategy"), (QFilter[])new QFilter[]{qf, qf1, qFilterUseOrg, qFilterMasterid}, null);
                    build = build.union(invDataSet);
                }
                DataSet finish = billDataSet.leftJoin(build).select(new String[]{"seq", "org", "material", "tracknumber", "project", "configcode", "entryseq", "key_subentryseq"}, new String[]{"materialinv", "manustrategy"}).on("org", "org").on("material", "material").finish();
                finish = finish.where("manustrategy != 0 or manustrategy != null");
                for (DynamicObject obj : load2 = BusinessDataServiceHelper.load((String)"bd_manustrategy", (String)"id,traceway,tracerange", (QFilter[])new QFilter[]{qf, qf1, qf3, qf4})) {
                    DataSet dataSet = finish.copy().where("manustrategy = " + obj.getPkValue());
                    if (dataSet.isEmpty()) continue;
                    for (Row row : dataSet) {
                        ++rowCount;
                        Set rangeSet = obj.getDynamicObjectCollection("tracerange").stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
                        if (!rangeSet.contains(configEntity.getDomain())) continue;
                        Set<String> fields = configEntity.getFields();
                        Set<String> waySet = obj.getDynamicObjectCollection("traceway").stream().map(x -> x.getString("fbasedataid.number")).collect(Collectors.toSet());
                        waySet.forEach(traceway -> {
                            if (fields.contains(traceway)) {
                                if (GZ001.equals(traceway)) {
                                    if (row.get("tracknumber") == null) {
                                        if (row.get("entryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_0", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                        } else if (row.get("key_subentryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                        } else {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ddf\u8e2a\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                        }
                                    }
                                } else if (GZ002.equals(traceway)) {
                                    if (row.get("project") == null) {
                                        if (row.get("entryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_3", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                        } else if (row.get("key_subentryseq") == null) {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u9879\u76ee\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_4", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                        } else {
                                            this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9879\u76ee\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_5", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                        }
                                    }
                                } else if (GZ003.equals(traceway) && row.get("configcode") == null) {
                                    if (row.get("entryseq") == null) {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_6", (String)"bos-ext-mmc", (Object[])new Object[0]));
                                    } else if (row.get("key_subentryseq") == null) {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c:\u201c\u914d\u7f6e\u53f7\u201d\u3002", (String)"CheckMTOStrategyValidator_7", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq")));
                                    } else {
                                        this.addErrorMessage(this.dataEntities[row.getInteger("seq")], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u914d\u7f6e\u53f7\u201d\uff1a\u201c%1$s\u201d\u7b2c%2$s\u884c,\u201c%3$s\u201d\u7b2c%4$s\u884c\u3002", (String)"CheckMTOStrategyValidator_8", (String)"bos-ext-mmc", (Object[])new Object[0]), entryName, row.get("entryseq"), subentryName, row.get("key_subentryseq")));
                                    }
                                }
                            }
                        });
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context != null) {
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        context.close();
                    }
                }
            }
            log.warn("--------CheckMTOStrategyValidator getFieldMap MATERIAL END------------" + (System.currentTimeMillis() - startTime1) / 1000L + 's');
        }
        log.warn(String.format("--------CheckMTOStrategyValidator END ROW:%s------------%ss", rowCount, (System.currentTimeMillis() - startTime) / 1000L));
    }

    private DataSetBuilder createBuilder() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("seq", (DataType)DateType.IntegerType, true));
        fields.add(new Field("org", (DataType)DateType.LongType, true));
        fields.add(new Field("materialinv", (DataType)DateType.LongType, true));
        fields.add(new Field("tracknumber", (DataType)DateType.StringType, true));
        fields.add(new Field("project", (DataType)DateType.StringType, true));
        fields.add(new Field("material", (DataType)DateType.LongType, true));
        fields.add(new Field("entryseq", (DataType)DateType.IntegerType, true));
        fields.add(new Field("key_subentryseq", (DataType)DateType.IntegerType, true));
        fields.add(new Field("configcode", (DataType)DateType.StringType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        return builder;
    }

    private DataSet buildBillDataSet(String entryEntity, String subEntryEntity, Map<String, String> headMap, Map<String, String> entryMap, Set<Object> invSet) {
        DataSetBuilder builder = this.createBuilder();
        boolean isExist = false;
        String bizTypeName = "";
        List bizIdList = new ArrayList();
        if (this.getOption().getVariables().containsKey(NOTCHECK_OTHERS_BIZTYPE) && this.getOption().getVariables().containsKey(NOTCHECK_OTHERS_BIZTYPENAME)) {
            isExist = true;
            bizTypeName = (String)this.getOption().getVariables().get(NOTCHECK_OTHERS_BIZTYPENAME);
            bizIdList = SerializationUtils.fromJsonStringToList((String)((String)this.getOption().getVariables().get(NOTCHECK_OTHERS_BIZTYPE)), Long.class);
        }
        int n = this.dataEntities.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject bizType;
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            if (isExist && bizIdList.contains((bizType = dataEntity.getDynamicObject(bizTypeName)).getPkValue())) continue;
            if (entryMap.isEmpty()) {
                Object[] rowData = new Object[9];
                rowData[0] = i;
                headMap.forEach((k, v) -> this.setRowData(invSet, dataEntity, rowData, (String)k, (String)v));
                builder.append(rowData);
                continue;
            }
            DynamicObjectCollection col = dataEntity.getDynamicObjectCollection(entryEntity);
            if (!"".equals(subEntryEntity)) {
                for (DynamicObject entry : col) {
                    DynamicObjectCollection subCol = entry.getDynamicObjectCollection(subEntryEntity);
                    for (DynamicObject subEntry : subCol) {
                        Object[] rowData = new Object[9];
                        rowData[0] = i;
                        rowData[6] = entry.get("seq");
                        rowData[7] = subEntry.get("seq");
                        for (Map.Entry<String, String> e : headMap.entrySet()) {
                            if (GZ001.equals(e.getKey())) {
                                rowData[3] = dataEntity.get(e.getValue());
                                continue;
                            }
                            if (GZ002.equals(e.getKey())) {
                                rowData[4] = dataEntity.get(e.getValue());
                                continue;
                            }
                            if (GZ004.equals(e.getKey())) {
                                rowData[1] = dataEntity.get(e.getValue());
                                continue;
                            }
                            if (GZ007.equals(e.getKey())) {
                                rowData[2] = dataEntity.get(e.getValue());
                                invSet.add(dataEntity.get(e.getValue()));
                                continue;
                            }
                            if (GZ005.equals(e.getKey())) {
                                rowData[5] = dataEntity.get(e.getValue());
                                continue;
                            }
                            if (!GZ003.equals(e.getKey())) continue;
                            rowData[8] = dataEntity.get(e.getValue());
                        }
                        for (Map.Entry<String, String> e : entryMap.entrySet()) {
                            String value = e.getValue().replace(subEntryEntity + ".", "");
                            if (e.getValue().startsWith(subEntryEntity)) {
                                if (GZ001.equals(e.getKey())) {
                                    rowData[3] = subEntry.get(value);
                                    continue;
                                }
                                if (GZ002.equals(e.getKey())) {
                                    rowData[4] = subEntry.get(value);
                                    continue;
                                }
                                if (GZ004.equals(e.getKey())) {
                                    rowData[1] = subEntry.get(value);
                                    continue;
                                }
                                if (GZ007.equals(e.getKey())) {
                                    rowData[2] = subEntry.get(value);
                                    invSet.add(subEntry.get(value));
                                    continue;
                                }
                                if (GZ005.equals(e.getKey())) {
                                    rowData[5] = subEntry.get(value);
                                    continue;
                                }
                                if (!GZ003.equals(e.getKey())) continue;
                                rowData[8] = subEntry.get(value);
                                continue;
                            }
                            if (GZ001.equals(e.getKey())) {
                                rowData[3] = entry.get(e.getValue());
                                continue;
                            }
                            if (GZ002.equals(e.getKey())) {
                                rowData[4] = entry.get(e.getValue());
                                continue;
                            }
                            if (GZ004.equals(e.getKey())) {
                                rowData[1] = entry.get(e.getValue());
                                continue;
                            }
                            if (GZ007.equals(e.getKey())) {
                                rowData[2] = entry.get(e.getValue());
                                invSet.add(entry.get(e.getValue()));
                                continue;
                            }
                            if (GZ005.equals(e.getKey())) {
                                rowData[5] = entry.get(e.getValue());
                                continue;
                            }
                            if (!GZ003.equals(e.getKey())) continue;
                            rowData[8] = entry.get(e.getValue());
                        }
                        builder.append(rowData);
                    }
                }
                continue;
            }
            for (DynamicObject entry : col) {
                Object[] rowData = new Object[9];
                rowData[0] = i;
                rowData[6] = entry.get("seq");
                headMap.forEach((k, v) -> this.setRowData(invSet, dataEntity, rowData, (String)k, (String)v));
                entryMap.forEach((k, v) -> this.setRowData(invSet, entry, rowData, (String)k, (String)v));
                builder.append(rowData);
            }
        }
        return builder.build();
    }

    private void setRowData(Set<Object> invSet, DynamicObject dataEntity, Object[] rowData, String k, String v) {
        if (GZ001.equals(k)) {
            rowData[3] = dataEntity.get(v);
        } else if (GZ002.equals(k)) {
            rowData[4] = dataEntity.get(v);
        } else if (GZ004.equals(k)) {
            rowData[1] = dataEntity.get(v);
        } else if (GZ007.equals(k)) {
            rowData[2] = dataEntity.get(v);
            invSet.add(dataEntity.get(v));
        } else if (GZ005.equals(k)) {
            rowData[5] = dataEntity.get(v);
        } else if (GZ003.equals(k)) {
            rowData[8] = dataEntity.get(v);
        }
    }

    private Map<String, String> getEntryFields(Map<String, String> headMap, Map<String, String> entryMap, Map<String, String> filedMap, DataEntityPropertyCollection properties) {
        String entryEntityName = "";
        String subEntryEntityName = "";
        String entryName = "";
        String subEntryName = "";
        String name = "";
        for (Map.Entry<String, String> en : filedMap.entrySet()) {
            if (en == null || StringUtils.isEmpty((String)en.getValue())) continue;
            int index = en.getValue().indexOf(".");
            if (index < 0) {
                headMap.put(en.getKey(), en.getValue());
                continue;
            }
            String substring = en.getValue().substring(0, index);
            if (properties.get((Object)substring) instanceof EntryProp) {
                entryMap.put(en.getKey(), en.getValue().substring(index + 1, en.getValue().length()));
                entryEntityName = substring;
                entryName = ((IDataEntityProperty)properties.get((Object)substring)).getDisplayName().toString();
                name = en.getValue().substring(index + 1, en.getValue().length());
                DynamicObjectType propertyType = ((EntryProp)properties.get((Object)substring)).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProp = propertyType.getProperties();
                if (!(entryProp.get((Object)name.substring(0, name.indexOf("."))) instanceof SubEntryProp)) continue;
                subEntryEntityName = name.substring(0, name.indexOf("."));
                subEntryName = ((IDataEntityProperty)entryProp.get((Object)name.substring(0, name.indexOf(".")))).getDisplayName().toString();
                continue;
            }
            headMap.put(en.getKey(), en.getValue());
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("entry", entryEntityName);
        map.put("subentry", subEntryEntityName);
        map.put("entryname", entryName);
        map.put("subentryname", subEntryName);
        return map;
    }

    private List<Map<String, String>> getFieldMap(List<Map<String, String>> ischeckMapList, List<ConfigEntryEntity> configList) {
        QFilter qf = new QFilter("status", "=", (Object)"C");
        QFilter qf1 = new QFilter("enable", "=", (Object)"1");
        QFilter qf2 = new QFilter("entryentity.billentity", "=", (Object)this.entityKey);
        ArrayList<Map<String, String>> filedMapList = new ArrayList<Map<String, String>>();
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"bd_manustrconfig", (String)"entryentity.domain,entryentity.billentity,entryentity.subentryentity,subentryentity.dimension,subentryentity.field", (QFilter[])new QFilter[]{qf, qf1, qf2});
        if (load == null) {
            return filedMapList;
        }
        DynamicObjectCollection col = load.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : col) {
            if (!this.entityKey.equals(entry.getString("billentity.id"))) continue;
            ConfigEntryEntity configEntity = new ConfigEntryEntity();
            HashMap filedMap = new HashMap(8);
            configEntity.setDomain(entry.getLong("domain.id"));
            HashSet<String> li = new HashSet<String>(8);
            HashMap ischeckMap = new HashMap(8);
            entry.getDynamicObjectCollection("subentryentity").forEach(subEntry -> {
                String dimesion = subEntry.getString("dimension.number");
                if (!Arrays.asList(ARR).contains(dimesion)) {
                    ischeckMap.put(dimesion, subEntry.getString("field"));
                }
                li.add(dimesion);
                filedMap.put(dimesion, subEntry.getString("field"));
            });
            configEntity.setFields(li);
            configList.add(configEntity);
            filedMapList.add(filedMap);
            ischeckMapList.add(ischeckMap);
        }
        return filedMapList;
    }
}

