/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.operation;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.ext.scmc.changemodel.validator.ReviseSubmitValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ReviseSubmitOpServise
extends EntityOperateService {
    private static final Log log = LogFactory.getLog(ReviseSubmitOpServise.class);

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(this.billEntityType.getName());
        if (fieldMapping != null && fieldMapping.size() > 0) {
            fieldKeys.addAll(ChangeModelHelper.getPreparePropertys(fieldMapping, this.getBillEntityType()));
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> e) {
        super.addDefaultValidator(e);
        List<AbstractValidator> validators = ChangeModelHelper.getReviseValidations(this.billEntityType.getName(), this.operationKey);
        if (validators != null) {
            e.addAll(validators);
        }
        if (!"false".equals(this.getOption().getVariableValue("isNeedValidStatus"))) {
            e.add(new ReviseSubmitValidator());
        }
    }

    protected void executeOperate(DynamicObject[] dynamicObjects) {
        try {
            Map variables = this.getOption().getVariables();
            String changerId = "";
            String changeDateId = "";
            String changeStatusId = "";
            if (variables.containsKey("changer")) {
                changerId = this.getOption().getVariableValue("changer");
            }
            if (variables.containsKey("changedate")) {
                changeDateId = this.getOption().getVariableValue("changedate");
            }
            if (variables.containsKey("changestatus")) {
                changeStatusId = this.getOption().getVariableValue("changestatus");
            }
            if (dynamicObjects != null) {
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    DynamicObject bill = dynamicObjects[i];
                    DynamicObjectType dynamicObjectType = bill.getDynamicObjectType();
                    DynamicProperty prop = dynamicObjectType.getProperty(changerId);
                    if (prop != null) {
                        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
                        bill.set(changerId, (Object)user);
                    }
                    if ((prop = dynamicObjectType.getProperty(changeDateId)) != null) {
                        bill.set(changeDateId, (Object)TimeServiceHelper.now());
                    }
                    if ((prop = dynamicObjectType.getProperty(changeStatusId)) != null) {
                        bill.set(changeStatusId, (Object)"");
                        bill.set(changeStatusId, (Object)"B2");
                    }
                    DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)this.getBillEntityType().getName(), (String)String.join((CharSequence)",", ChangeModelHelper.getPreparePropertys(this.getOption().getVariables(), this.getBillEntityType())));
                    dynamicObjects[i] = ChangeModelHelper.invokeReviseLogServise(originalBill, bill, "submit");
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c\u201c\u66f4\u6b63\u63d0\u4ea4\u201d\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"ReviseSubmitOpServise_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }
}

