/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.changemodel.plugin;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.changemodel.helper.ChangeDisplayHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeLogHelper;
import kd.bos.ext.scmc.changemodel.helper.ChangeModelHelper;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mutex.impl.MutexLockInfo;

public class ReviseFormPlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        String entityId = this.getModel().getDataEntityType().getName();
        if (parentView != null) {
            String isRevise = parentView.getPageCache().get("isRevise" + pkValue);
            if (isRevise != null) {
                this.releaseMutex();
                this.addMutex();
                Set<String> canReviseFields = ChangeModelHelper.getCanReviseFields(entityId);
                if (canReviseFields == null || canReviseFields.size() == 0) {
                    return;
                }
                ChangeDisplayHelper.setReviseDisplay(this.getView(), canReviseFields);
                Map<String, String> fieldMapping = ChangeModelHelper.getCusParaMapping(entityId);
                String changeStatusId = fieldMapping.get("changestatus");
                if (this.getModel().getDataEntityType().findProperty(changeStatusId) != null) {
                    this.getModel().setValue(changeStatusId, (Object)"B1");
                    this.getView().getModel().setDataChanged(false);
                }
                parentView.getPageCache().remove("isRevise" + pkValue);
            } else {
                String status = ChangeLogHelper.getChangeStatusByLog(entityId, pkValue);
                if (!"B1".equals(status)) {
                    ChangeDisplayHelper.reNewBillDisplay(this.getView());
                    this.getView().getFormShowParameter().setCustomParam("opkey" + pkValue, null);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseMutex();
    }

    private void addMutex() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey" + pkValue);
        if (StringUtils.isNotEmpty((CharSequence)opKey)) {
            String pkId = this.getModel().getDataEntity().getPkValue().toString();
            String billNoId = ((BillEntityType)this.getModel().getDataEntityType()).getBillNo();
            String entityId = this.getModel().getDataEntityType().getName();
            MutexLockInfo lockInfo = new MutexLockInfo(pkId, (String)this.getModel().getValue(billNoId), "default_netctrl", entityId, opKey, true, null);
            StringBuilder errorMsg = new StringBuilder();
            boolean isMutexLocked = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errorMsg);
            if (!isMutexLocked) {
                throw new KDBizException(errorMsg.toString());
            }
        }
    }

    private void releaseMutex() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        String opKey = (String)this.getView().getFormShowParameter().getCustomParam("opkey" + pkValue);
        if (StringUtils.isNotEmpty((CharSequence)opKey)) {
            String entityName = this.getModel().getDataEntityType().getName();
            MutexHelper.release((String)entityName, (String)opKey, (String)String.valueOf(pkValue));
        }
    }
}

