/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.handle;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.scmc.chargeagainst.handle.RemoteServiceHandle;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.BotpLinkHelper;
import kd.bos.ext.scmc.chargeagainst.util.CaModelField;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.vo.CaPageVo;
import kd.bos.ext.scmc.chargeagainst.vo.RedBlueWfVo;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RedBlueBillHandle {
    private Map<String, List<RedBlueWfVo>> redBlueBills = new HashMap<String, List<RedBlueWfVo>>(16);
    private RemoteServiceHandle remoteServiceHandle;
    private CaLogService caLogService;
    private OperateOption option;
    private CaPageVo caPageVo;
    private static final String GET_ALL_CABILLED = "getAllCaBilled";
    private static final String GET_ALL_CABILL = "getAllCaBill";

    public static RedBlueBillHandle build(OperateOption option, CaLogService caLogService, RemoteServiceHandle remote, CaPageVo caPageVo) {
        RedBlueBillHandle handle = new RedBlueBillHandle();
        handle.setOption(option);
        handle.setCaLogService(caLogService);
        handle.setRemoteServiceHandle(remote);
        handle.setCaPageVo(caPageVo);
        return handle;
    }

    public void copyBillAndCaWfRecord(List<DynamicObject> bills) {
        Map<String, List<Object>> caedBills = this.addCaedBill(bills);
        for (Map.Entry<String, List<Object>> entry : caedBills.entrySet()) {
            String key = entry.getKey();
            this.copyBillData(entry, key);
        }
    }

    private void addRedBlueBill(DynamicObject caBilled, DynamicObject copyBill) {
        String billType = copyBill.getDataEntityType().getName();
        List<RedBlueWfVo> redBlueWfVo = this.redBlueBills.get(billType);
        if (redBlueWfVo == null) {
            redBlueWfVo = new ArrayList<RedBlueWfVo>(16);
        }
        redBlueWfVo.add(new RedBlueWfVo(copyBill, caBilled));
        this.redBlueBills.put(billType, redBlueWfVo);
    }

    private Map<String, List<Object>> addCaedBill(List<DynamicObject> bills) {
        String entityName;
        List<Object> billList;
        Map<String, List<Object>> copyBillMap = this.getVirtBills();
        if (CollectionUtils.isEmpty(copyBillMap)) {
            copyBillMap = new HashMap<String, List<Object>>(16);
        }
        if ((billList = copyBillMap.get(entityName = bills.get(0).getDataEntityType().getName())) == null) {
            billList = new ArrayList<Object>(16);
        }
        List pks = bills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        billList.addAll(pks);
        copyBillMap.put(entityName, billList);
        return copyBillMap;
    }

    private Map<String, List<Object>> getVirtBills() {
        String variableValue = this.getOption().getVariableValue("CA_ISVIRTLIST", "");
        if (StringUtils.isEmpty((CharSequence)variableValue)) {
            return null;
        }
        return (Map)JSONObject.parseObject((String)variableValue, Map.class);
    }

    private void copyBillData(Map.Entry<String, List<Object>> entry, String billType) {
        List<Object> values = entry.getValue();
        Object[] pks = values.toArray(new Object[values.size()]);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        DynamicObject[] virts = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)dataEntityType);
        List<DynamicObject> virtList = Arrays.asList(virts);
        this.remoteServiceHandle.chargeWfRecord(virtList);
        this.copyBill(virtList);
    }

    public Map<String, List<DynamicObject>> getAllCaBilled() {
        return this.getAllBillMap(GET_ALL_CABILLED);
    }

    public Map<String, List<DynamicObject>> getAllCaBill() {
        return this.getAllBillMap(GET_ALL_CABILL);
    }

    private Map<String, List<DynamicObject>> getAllBillMap(String name) {
        Map<String, List<RedBlueWfVo>> redBlueBills = this.getRedBlueBills();
        HashMap<String, List<DynamicObject>> redBlueBillMap = new HashMap<String, List<DynamicObject>>(16);
        for (Map.Entry<String, List<RedBlueWfVo>> redBlueBill : redBlueBills.entrySet()) {
            String billKey = redBlueBill.getKey();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
            List<RedBlueWfVo> redBlueWfVoList = redBlueBill.getValue();
            for (RedBlueWfVo vo : redBlueWfVoList) {
                if (GET_ALL_CABILL.equals(name)) {
                    list.add(vo.getCabill());
                    continue;
                }
                if (!GET_ALL_CABILLED.equals(name)) continue;
                list.add(vo.getCaBilled());
            }
            redBlueBillMap.put(billKey, list);
        }
        return redBlueBillMap;
    }

    private void copyBill(List<DynamicObject> srcBillList) {
        DynamicObject[] loads;
        if (CollectionUtils.isEmpty(srcBillList)) {
            return;
        }
        Set pks = srcBillList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObjectType dynamicObjectType = srcBillList.get(0).getDynamicObjectType();
        for (DynamicObject srcBill : loads = BusinessDataServiceHelper.load((Object[])pks.toArray(), (DynamicObjectType)dynamicObjectType)) {
            DynamicObject copyData = (DynamicObject)OrmUtils.clone((IDataEntityBase)srcBill, (boolean)true, (boolean)true);
            this.copyBillSetHeadField(srcBill, copyData);
            DynamicObjectCollection copyBillEntryList = this.copyBillSetEntryField(srcBill, copyData);
            BotpLinkHelper.clearBillLink(copyData);
            BotpLinkHelper.clearBillEntryLink(copyBillEntryList);
            BotpLinkHelper.addBillLink(srcBill, copyData);
            this.addRedBlueBill(srcBill, copyData);
            this.caLogService.buildCaLogCaBillEntryData(srcBill, copyData);
        }
    }

    private void copyBillSetHeadField(DynamicObject srcBill, DynamicObject copyData) {
        String billType = srcBill.getDataEntityType().getName();
        String billNoKey = ((BillEntityType)copyData.getDataEntityType()).getBillNo();
        String origBillNo = srcBill.getString(billNoKey);
        String number = "CX-" + origBillNo;
        copyData.set(billNoKey, (Object)number);
        String remake = StringUtils.isEmpty((CharSequence)this.caPageVo.getReason()) ? ResManager.loadKDString((String)"\u51b2\u9500{0}\u3002", (String)"IM-S-541823", (String)"bos-ext-scmc", (Object[])new Object[]{srcBill.getString(billNoKey)}) : ResManager.loadKDString((String)"\u51b2\u9500{0}\uff1a{1}\u3002", (String)"IM-S-001170", (String)"bos-ext-scmc", (Object[])new Object[]{srcBill.getString(billNoKey), this.caPageVo.getReason()});
        CaModelField caModelField = this.caPageVo.getModelField().getCaModelField(billType);
        copyData.set(caModelField.getComment(), (Object)remake);
        copyData.set(caModelField.getBizTime(), (Object)this.caPageVo.getCaDate());
        copyData.set("billstatus", (Object)"A");
        copyData.set(caModelField.getIsChargeOff(), (Object)Boolean.TRUE);
        copyData.set("createtime", (Object)new Date());
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        copyData.set("creator", (Object)user);
        copyData.set(caModelField.getBookDate(), (Object)this.caPageVo.getBookDate());
    }

    private DynamicObjectCollection copyBillSetEntryField(DynamicObject srcBill, DynamicObject copyData) {
        String billType = srcBill.getDataEntityType().getName();
        CaModelField caModelField = this.caPageVo.getModelField().getCaModelField(billType);
        String billEntryKey = caModelField.getBillEntry();
        DynamicObjectCollection billEntryList = srcBill.getDynamicObjectCollection(billEntryKey);
        DynamicObjectCollection copyBillEntryList = copyData.getDynamicObjectCollection(billEntryKey);
        List<String> proList = CommonUtil.getAmoutAndQtyFieldList(copyData, billEntryKey);
        List<String> afterProList = CommonUtil.getAmoutAndQtyFieldList(copyData, "afterentity");
        for (int i = 0; i < copyBillEntryList.size(); ++i) {
            boolean isTransList;
            DynamicObject copyEntry = (DynamicObject)copyBillEntryList.get(i);
            DynamicObject billEntry = (DynamicObject)billEntryList.get(i);
            copyEntry.set(caModelField.getSrcBillEntity(), (Object)billType);
            copyEntry.set(caModelField.getSrcBillId(), srcBill.getPkValue());
            copyEntry.set(caModelField.getSrcbBillEntryId(), billEntry.getPkValue());
            if ("im_transinbill".equals(billType)) {
                copyEntry.set("isovertrans", (Object)Boolean.FALSE);
            } else if ("im_transoutbill".equals(billType) && StringUtils.isBlank((CharSequence)copyEntry.getString(caModelField.getGroupNumber()))) {
                copyEntry.set(caModelField.getGroupNumber(), srcBill.getPkValue());
                copyEntry.set(caModelField.getGroupSeq(), billEntry.getPkValue());
            }
            for (String field : proList) {
                BigDecimal value = copyEntry.getBigDecimal(field);
                if (value == null) continue;
                copyEntry.set(field, (Object)BigDecimal.ZERO.subtract(value));
            }
            boolean bl = isTransList = "im_adjustbill".equals(billType) || "im_disassemblebill".equals(billType) || "im_assembbill".equals(billType);
            if (!isTransList) continue;
            DynamicObjectCollection copyBillAfterEntryList = copyEntry.getDynamicObjectCollection("afterentity");
            DynamicObjectCollection billAfterEntryList = billEntry.getDynamicObjectCollection("afterentity");
            for (int j = 0; j < copyBillAfterEntryList.size(); ++j) {
                DynamicObject copyAfterEntry = (DynamicObject)copyBillAfterEntryList.get(j);
                DynamicObject afterEntry = (DynamicObject)billAfterEntryList.get(j);
                copyAfterEntry.set("subsrcbillentity", (Object)billType);
                copyAfterEntry.set("subsrcbillid", srcBill.getPkValue());
                copyAfterEntry.set("subsrcbillentryid", afterEntry.getPkValue());
                for (String field : afterProList) {
                    BigDecimal value = copyAfterEntry.getBigDecimal(field);
                    if (value == null) continue;
                    copyAfterEntry.set(field, (Object)BigDecimal.ZERO.subtract(value));
                }
            }
        }
        return copyBillEntryList;
    }

    public RemoteServiceHandle getRemoteServiceHandle() {
        return this.remoteServiceHandle;
    }

    private void setRemoteServiceHandle(RemoteServiceHandle remoteServiceHandle) {
        this.remoteServiceHandle = remoteServiceHandle;
    }

    public Map<String, List<RedBlueWfVo>> getRedBlueBills() {
        return this.redBlueBills;
    }

    public CaPageVo getCaPageVo() {
        return this.caPageVo;
    }

    private void setCaPageVo(CaPageVo caPageVo) {
        this.caPageVo = caPageVo;
    }

    public void setRedBlueBills(Map<String, List<RedBlueWfVo>> redBlueBills) {
        this.redBlueBills = redBlueBills;
    }

    public CaLogService getCaLogService() {
        return this.caLogService;
    }

    private void setCaLogService(CaLogService caLogService) {
        this.caLogService = caLogService;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }
}

