/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.scmc.chargeagainst.util.SystemCallParamHelper;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ChargeAgainstPlugin
extends AbstractFormPlugin
implements IFormPlugin {
    private static final Log logger = LogFactory.getLog(ChargeAgainstPlugin.class);
    private static final String CANCEL = "cancel";
    private static final String CONFIRM = "confirm";
    private static final String ENTITY_SCMC_PARAM = "sbs_scmcapplevelparam";
    private static final String ENABLE_BOOKDATE_EQUALS_BIZTIME = "INV0004";
    private static final String BOOK_DATE = "bookdate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CONFIRM});
    }

    public void click(EventObject e) {
        Control c = (Control)e.getSource();
        String key = c.getKey();
        if (StringUtils.isNotBlank((CharSequence)key) && CONFIRM.equals(key)) {
            this.returnData();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean enable = SystemCallParamHelper.isEnable(ENTITY_SCMC_PARAM, ENABLE_BOOKDATE_EQUALS_BIZTIME);
        if (enable) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BOOK_DATE});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "cadate": {
                boolean enable = SystemCallParamHelper.isEnable(ENTITY_SCMC_PARAM, ENABLE_BOOKDATE_EQUALS_BIZTIME);
                if (!enable) break;
                this.getModel().setValue(BOOK_DATE, this.getModel().getValue("cadate"));
                break;
            }
        }
    }

    private void returnData() {
        JSONObject returnData = new JSONObject();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        returnData.put("cadate", (Object)dataEntity.getDate("cadate"));
        returnData.put("careason", (Object)dataEntity.getString("careason"));
        returnData.put("bookDate", (Object)dataEntity.getDate("bookDate"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        returnData.put("caBillPk", customParams.get("caBillPk"));
        returnData.put("caBillType", customParams.get("caBillType"));
        this.getView().returnDataToParent((Object)returnData);
        String pageId = this.getView().getPageId();
        logger.info("getview\u7684pageid:" + pageId);
        this.getView().close();
    }
}

