/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.util;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.botp.track.bizentity.BillTracker;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class BotpLinkHelper {
    private static final Log logger = LogFactory.getLog(BotpLinkHelper.class);

    public static void addBillLink(DynamicObject sourceBill, DynamicObject targetBill) {
        BotpLinkHelper.buildBillLink(sourceBill, targetBill, false);
    }

    public static void rebuildBillLink(DynamicObject sourceBill, DynamicObject targetBill) {
        BotpLinkHelper.buildBillLink(sourceBill, targetBill, true);
    }

    public static void buildBillLink(DynamicObject sourceBill, DynamicObject targetBill, boolean isClear) {
        String name;
        if (sourceBill == null || targetBill == null) {
            return;
        }
        Object sourceBillid = sourceBill.getPkValue();
        String sourceBillType = sourceBill.getDynamicObjectType().getName();
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)sourceBillType).getTableId();
        BillEntityType dataEntityType = (BillEntityType)targetBill.getDataEntityType();
        String lkName = BotpLinkHelper.getLkName(dataEntityType, name = dataEntityType.getName());
        if (lkName == null) {
            logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
            return;
        }
        logger.info(name + "\u7684lk\u8868\u4e3a" + lkName);
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBill.get(lkName);
        if (isClear) {
            BotpLinkHelper.clearBillLink(targetBill);
            BotpLinkHelper.clearBillEntryLink(targetBill, "billentry");
        }
        DynamicObject linkRow = linkRows.addNew();
        linkRow.set("billhead_lk_stableid", (Object)srcTableId);
        linkRow.set("billhead_lk_sbillid", sourceBillid);
        linkRow.set("billhead_lk_sid", sourceBillid);
    }

    public static void buildBillEntryLink(DynamicObject sourceBill, DynamicObject sourceBillEntry, DynamicObject targetBillEntry) {
        String sourceBillType = sourceBill.getDynamicObjectType().getName();
        if (sourceBillEntry == null || targetBillEntry == null) {
            return;
        }
        String sourceBillEntryType = sourceBillEntry.getDataEntityType().getName();
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)sourceBillEntryType).getTableId();
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBillEntry.get("billentry_lk");
        DynamicObject linkeEntryRow = linkRows.addNew();
        linkeEntryRow.set("billentry_lk_stableid", (Object)srcTableId);
        linkeEntryRow.set("billentry_lk_sbillid", sourceBill.getPkValue());
        linkeEntryRow.set("billentry_lk_sid", sourceBillEntry.getPkValue());
    }

    public static void buildBillEntryLink(DynamicObject sourceBill, DynamicObject targetBill) {
        String sourceBillType = sourceBill.getDynamicObjectType().getName();
        if (sourceBill == null || targetBill == null) {
            return;
        }
        String entryName = "billentry";
        Long srcTableId = ConvertMetaServiceHelper.loadTableDefine((String)sourceBillType, (String)entryName).getTableId();
        DynamicObjectCollection tagBillEntryList = targetBill.getDynamicObjectCollection(entryName);
        DynamicObjectCollection billEntryList = sourceBill.getDynamicObjectCollection(entryName);
        for (int i = 0; i < billEntryList.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntryList.get(i);
            DynamicObject tagEntry = (DynamicObject)tagBillEntryList.get(i);
            DynamicObjectCollection tagLinkRows = (DynamicObjectCollection)tagEntry.get("billentry_lk");
            DynamicObject linkeEntryRow = tagLinkRows.addNew();
            linkeEntryRow.set("billentry_lk_stableid", (Object)srcTableId);
            linkeEntryRow.set("billentry_lk_sbillid", sourceBill.getPkValue());
            linkeEntryRow.set("billentry_lk_sid", entry.getPkValue());
        }
    }

    public static void clearBillLink(DynamicObject targetBill) {
        String name;
        BillEntityType dataEntityType = (BillEntityType)targetBill.getDataEntityType();
        String lkName = BotpLinkHelper.getLkName(dataEntityType, name = dataEntityType.getName());
        if (lkName == null) {
            logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
            return;
        }
        DynamicObjectCollection linkRows = (DynamicObjectCollection)targetBill.get(lkName);
        linkRows.clear();
    }

    private static String getLkName(BillEntityType dataEntityType, String entryName) {
        Map entities = dataEntityType.getAllEntities();
        for (EntityType entryEntityType : entities.values()) {
            String parentName;
            if (!(entryEntityType instanceof LinkEntryType) || !entryName.equals(parentName = entryEntityType.getParent().getName())) continue;
            return entryEntityType.getName();
        }
        return null;
    }

    public static Map<Object, Object> trackUpEntryInfoMap(DynamicObjectCollection billEntries, Object sourceBillId) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (billEntries == null || billEntries.size() == 0) {
            return map;
        }
        for (DynamicObject billEntry : billEntries) {
            DynamicObjectCollection linkRows = (DynamicObjectCollection)billEntry.get("billentry_lk");
            for (DynamicObject linkRow : linkRows) {
                Object linksourceBillId = linkRow.get("billentry_lk_sbillid");
                if (!linksourceBillId.equals(sourceBillId)) continue;
                Object billEntryId = billEntry.getPkValue();
                Object upLinkEntryId = linkRow.get("billentry_lk_sid");
                map.put(billEntryId, upLinkEntryId);
            }
        }
        return map;
    }

    public static void clearBillEntryLink(DynamicObject targetBill, String entryKey) {
        DynamicObjectCollection billentries = targetBill.getDynamicObjectCollection(entryKey);
        BotpLinkHelper.clearBillEntryLink(billentries);
    }

    public static void clearBillEntryLink(DynamicObjectCollection billentries) {
        String name = billentries.getDynamicObjectType().getName();
        BillEntityType parent = (BillEntityType)billentries.getDynamicObjectType().getParent();
        String lkName = BotpLinkHelper.getLkName(parent, name);
        if (lkName == null) {
            logger.info(name + "\u7684lk\u8868\u4e3a\u7a7a");
            return;
        }
        for (DynamicObject billentry : billentries) {
            DynamicObjectCollection linkEntryRows = (DynamicObjectCollection)billentry.get(lkName);
            linkEntryRows.clear();
        }
    }

    public static void deleteTrackInfo(Object sourceBill, Object targetBill) {
        BotpLinkHelper.deleteTrackInfo("FSBILLID = ? AND FTBILLID = ?", sourceBill, targetBill);
    }

    public static void deleteTrackInfo(Set<Object> settleBillIds) {
        if (CollectionUtils.isEmpty(settleBillIds)) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("FTBILLID in (?");
        for (int i = 1; i < settleBillIds.size(); ++i) {
            sBuilder.append(",?");
        }
        sBuilder.append(')');
        BotpLinkHelper.deleteTrackInfo(sBuilder.toString(), settleBillIds.toArray());
    }

    private static void deleteTrackInfo(String filterString, final Object ... values) {
        IDataEntityType billTrackerType = OrmUtils.getDataEntityType(BillTracker.class);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM ").append(billTrackerType.getAlias()).append(' ');
        sBuilder.append("WHERE ");
        sBuilder.append(filterString);
        ResultSetHandler<List<Object>> action = new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                ArrayList<Object> ids = new ArrayList<Object>(values.length);
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    ids.add(id);
                }
                return ids;
            }
        };
        List ids = (List)DB.query((DBRoute)new DBRoute(billTrackerType.getDBRouteKey()), (String)sBuilder.toString(), (Object[])values, (ResultSetHandler)action);
        DeleteServiceHelper.delete((IDataEntityType)billTrackerType, (Object[])ids.toArray());
    }

    public static Long getTableDefines(String number) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine arToAr = reader.loadTableDefine(number, number);
        Long tableId = arToAr.getTableId();
        return tableId;
    }

    public static List<BFRowLinkDownNode> getSpecBillType(List<BFRowLinkDownNode> nodes, Set<Long> tableIds) {
        for (BFRowLinkDownNode node : nodes) {
            Map tNodes = node.getTNodes();
            Iterator childIterator = tNodes.entrySet().iterator();
            while (childIterator.hasNext()) {
                Map.Entry child = childIterator.next();
                BFRowLinkDownNode childNode = (BFRowLinkDownNode)child.getValue();
                BFRowId childRow = childNode.getRowId();
                if (tableIds.contains(childRow.getTableId())) {
                    childNode.getTNodes().clear();
                    continue;
                }
                childIterator.remove();
            }
        }
        return nodes;
    }

    public static List<BFRowLinkDownNode> getSpecBillIds(Set<Long> settleBillIds, List<BFRowLinkDownNode> nodes) {
        for (BFRowLinkDownNode node : nodes) {
            Map tNodes = node.getTNodes();
            Iterator childIterator = tNodes.entrySet().iterator();
            while (childIterator.hasNext()) {
                Map.Entry child = childIterator.next();
                BFRowLinkDownNode childNode = (BFRowLinkDownNode)child.getValue();
                BFRowId childRow = childNode.getRowId();
                if (settleBillIds.contains(childRow.getBillId())) {
                    childNode.getTNodes().clear();
                    continue;
                }
                childIterator.remove();
            }
        }
        return nodes;
    }

    public static boolean hasTrackDownBill(Map<String, Set<Object>> settleBills) {
        for (Map.Entry<String, Set<Object>> settleBillEntry : settleBills.entrySet()) {
            List nodes = BFTrackerServiceHelper.loadLinkDownNodes((String)settleBillEntry.getKey(), (String)"", (Long[])settleBillEntry.getValue().toArray(new Long[settleBillEntry.getValue().size()]));
            if (CollectionUtils.isEmpty((Collection)nodes)) continue;
            return true;
        }
        return false;
    }
}

