/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.price;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PricingUtils {
    private static final Log log = LogFactory.getLog(PricingUtils.class);
    public static final String KEY_EXATETABLE = "exchangeRateTableID";
    public static final String KEY_BASECURRENCY = "baseCurrencyID";

    static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        if (orgId == null || orgId.equals(0L)) {
            return null;
        }
        Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (mapOrg == null || mapOrg.get("id") == null) {
            return null;
        }
        log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + mapOrg);
        Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
        if (map == null || map.isEmpty()) {
            return null;
        }
        log.info("\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a" + map);
        return map;
    }

    static BigDecimal getExRate(long exchangeTableID, long sourceCurrencyID, long targetCurrencyID, Date date) {
        Object exRate = null;
        exRate = targetCurrencyID == sourceCurrencyID ? BigDecimal.ONE : (sourceCurrencyID == 0L || targetCurrencyID == 0L ? null : BaseDataServiceHelper.getExchangeRate((Long)exchangeTableID, (Long)sourceCurrencyID, (Long)targetCurrencyID, (Date)date));
        return exRate;
    }

    static Map<String, Object> getPricingParam(DynamicObject bill, Map<String, String> billKeyMap) {
        if (billKeyMap == null || billKeyMap.size() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(billKeyMap.size());
        for (Map.Entry<String, String> headMap : billKeyMap.entrySet()) {
            String key = headMap.getKey();
            Object value = bill.get(headMap.getValue());
            if (value instanceof DynamicObject) {
                DynamicObject dynaobject = (DynamicObject)value;
                if ("bd_materialinventoryinfo".equals(dynaobject.getDataEntityType().getName())) {
                    dynaobject = dynaobject.getDynamicObject("masterid");
                }
                value = dynaobject.getLong("id");
            }
            paramMap.put(key, value);
        }
        return paramMap;
    }
}

