/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.sn.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.QtyProp;
import kd.bos.ext.scmc.sn.helper.SerialNumberHelper;
import kd.bos.ext.scmc.sn.operate.ImportSerialNumberCallBack;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class SerialNumberOpUtil {
    private static final String SERIALNUM = "serialnumber";

    public static void handleSNNumber(IFormView view, String entryName, String itemKey) {
        if (StringUtils.isEmpty((String)entryName)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u64cd\u4f5c\u5206\u5f55\u3002", (String)"SerialNumberOpUtil_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject bill = model.getDataEntity();
        Long pkValue = (Long)bill.getPkValue();
        MainEntityType billEntity = model.getDataEntityType();
        String billType = billEntity.getName();
        int[] selectRows = ((EntryGrid)view.getControl(entryName)).getSelectRows();
        if (selectRows.length != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"SerialNumberOpUtil_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = (DynamicObject)model.getEntryEntity(entryName).get(selectRows[0]);
        Object entryId = entry.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !QueryServiceHelper.exists((String)billType, (Object)pkValue)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        if (entryId == null || entryId.equals(0L)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_14", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        DynamicObject cfg = SerialNumberOpUtil.getSNBillConfigByBillId(billType, entryName, pkValue);
        if (cfg == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SerialNumberOpUtil_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        String layout = "sbs_billsnrelation";
        DynamicObject entryLayoutObj = cfg.getDynamicObject("enterlayout");
        if (entryLayoutObj != null) {
            layout = entryLayoutObj.getString("id");
        }
        String materialInvCol = cfg.getString("materialcol");
        String materialCol = cfg.getString("materialmastercol");
        String invOrgCol = SerialNumberHelper.getOrgCol(cfg.getDynamicObjectCollection("snmainfentry"));
        String qtyCol = SerialNumberOpUtil.getPureKey(cfg.getString("snbaseqtycol"));
        String unitCol = SerialNumberOpUtil.getSerialUnitKey(billEntity, entryName, qtyCol);
        DynamicObject materialInvInfo = SerialNumberOpUtil.getMaterialInvInfo(bill, entry, materialInvCol, materialCol, invOrgCol, view, entryName);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject invOrgInfo = null;
        if (StringUtils.isNotEmpty((String)invOrgCol)) {
            invOrgInfo = (DynamicObject)SerialNumberOpUtil.getValueByName(bill, entry, invOrgCol);
        }
        DynamicObject unit = entry.getDynamicObject(unitCol);
        BigDecimal qty = entry.getBigDecimal(qtyCol);
        if (!SerialNumberOpUtil.isEnableSerial(materialInvInfo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_7", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        if (unit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SerialNumberOpUtil_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection snMainEntries = cfg.getDynamicObjectCollection("snmainfentry");
        String createOrgCol = null;
        String lotNumCol = null;
        for (DynamicObject snMainEntry : snMainEntries) {
            String snMainCol = snMainEntry.getString("snmainfcol");
            if ("invorg".equals(snMainCol)) {
                createOrgCol = snMainEntry.getString("snmainfsrcbillcol");
                continue;
            }
            if (!"lotnumber".equals(snMainCol)) continue;
            lotNumCol = snMainEntry.getString("snmainfsrcbillcol");
        }
        DynamicObject createOrgInfo = null;
        String lotNum = null;
        if (!StringUtils.isEmpty(createOrgCol)) {
            createOrgInfo = (DynamicObject)SerialNumberOpUtil.getValueByName(bill, entry, createOrgCol);
        }
        if (!StringUtils.isEmpty(lotNumCol)) {
            lotNum = (String)SerialNumberOpUtil.getValueByName(bill, entry, lotNumCol);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("enterlayout", layout);
        param.put("material", materialInvInfo.getPkValue());
        param.put("unit", unit.getPkValue());
        param.put("qty", qty.intValue());
        param.put("billid", pkValue);
        param.put("billtype", billType);
        param.put("entryid", entryId);
        param.put("entrykey", entryName);
        param.put("invorg", invOrgInfo != null ? invOrgInfo.getPkValue() : null);
        param.put("curwarehous", null);
        param.put("curlocation", null);
        param.put("lotnumber", lotNum);
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        if (!isFromDataBase && "checksnnumber".equals(itemKey)) {
            Object billSnRelationId = SerialNumberOpUtil.getUpSnRelationId(billType, entryName, bill, entry);
            param.put("billsnrelationid", billSnRelationId);
        } else {
            QFilter filter;
            DynamicObject billSNRelation;
            String serialnumber;
            IDataEntityProperty property = billEntity.findProperty(SERIALNUM);
            if (property != null && property.getParent() != null && entryName.equals(property.getParent().getName()) && !StringUtils.isBlank((String)(serialnumber = entry.getString(SERIALNUM)))) {
                if ("entersnnumber".equals(itemKey) || "importsnnumber".equals(itemKey)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u5df2\u5728\u7269\u6599\u660e\u7ec6\u4e2d\u5f55\u5165\uff0c\u8bf7\u52ff\u91cd\u590d\u5f55\u5165/\u5bfc\u5165\u3002", (String)"SerialNumberOpUtil_9", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    return;
                }
                if ("checksnnumber".equals(itemKey)) {
                    HashMap<String, String> serial = new HashMap<String, String>(2);
                    serial.put("snnumber", serialnumber);
                    serial.put("invorg", (String)invOrgInfo);
                    Map<Long, List<Map<String, Object>>> allEntrySerials = Collections.singletonMap((Long)entryId, Collections.singletonList(serial));
                    SerialNumberOpUtil.quickFullInputSerialNumber(billType, pkValue, entryName, allEntrySerials);
                }
            }
            if ((billSNRelation = QueryServiceHelper.queryOne((String)"sbs_billsnrelation", (String)"id", (QFilter[])(filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", (Object)pkValue).and("entryid", "=", entryId)).toArray())) != null) {
                param.put("billsnrelationid", billSNRelation.get("id"));
            }
        }
        SerialNumberOpUtil.showSerialNumberPage(view, itemKey, param);
    }

    private static DynamicObject getMaterialInvInfo(DynamicObject bill, DynamicObject entry, String materialInvCol, String materialCol, String invOrgCol, IFormView view, String entryName) {
        DynamicObject materialInvInfo = null;
        if (StringUtils.isNotEmpty((String)materialInvCol)) {
            String materialInvRealCol = materialInvCol.substring(materialInvCol.indexOf(entryName) + entryName.length() + 1);
            materialInvInfo = entry.getDynamicObject(materialInvRealCol);
            if (materialInvInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"SerialNumberOpUtil_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return null;
            }
            if ("bd_materialinventoryinfo".equals(materialInvInfo.getDynamicObjectType().getName())) {
                return materialInvInfo;
            }
            materialCol = materialInvCol;
        }
        if (StringUtils.isNotEmpty((String)materialCol)) {
            String materialRealCol = materialCol.substring(materialCol.indexOf(entryName) + entryName.length() + 1);
            DynamicObject materialInfo = entry.getDynamicObject(materialRealCol);
            if (materialInfo == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"SerialNumberOpUtil_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return null;
            }
            if (StringUtils.isNotEmpty((String)invOrgCol)) {
                DynamicObject invOrgInfo = (DynamicObject)SerialNumberOpUtil.getValueByName(bill, entry, invOrgCol);
                if (invOrgInfo != null) {
                    QFilter qFilter = new QFilter("masterid", "=", materialInfo.getPkValue()).and("enableserial", "=", (Object)true).and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)invOrgInfo.getPkValue())));
                    Map bdMaterialinventoryinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray());
                    if (bdMaterialinventoryinfo == null || bdMaterialinventoryinfo.isEmpty()) {
                        view.showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u7269\u6599\u548c\u5e93\u5b58\u7ec4\u7ec7\uff0c\u672a\u83b7\u53d6\u5230\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\u7684\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_6", (String)"bos-ext-scmc", (Object[])new Object[0]));
                        return null;
                    }
                    List objects = bdMaterialinventoryinfo.keySet().stream().sorted().collect(Collectors.toList());
                    materialInvInfo = (DynamicObject)bdMaterialinventoryinfo.get(objects.get(objects.size() - 1));
                    return materialInvInfo;
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"SerialNumberOpUtil_16", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return null;
            }
        }
        view.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7269\u6599\u5e93\u5b58\u4fe1\u606f\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\uff0c\u8bf7\u68c0\u67e5\u5e8f\u5217\u53f7\u670d\u52a1\u914d\u7f6e\u4e2d\u7684\u2019\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5b57\u6bb5\u6807\u8bc6\u2018\u3001\u2019\u7269\u6599\u5b57\u6bb5\u6807\u8bc6\u2018\u548c\u2019\u5e93\u5b58\u7ec4\u7ec7\u5b57\u6bb5\u6807\u8bc6\u2018\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"SerialNumberOpUtil_15", (String)"bos-ext-scmc", (Object[])new Object[0]));
        return null;
    }

    public static String getSerialUnitKey(MainEntityType billtypeEntity, String entrytype, String serialQtyKey) {
        Map allEntryFields = ((EntityType)billtypeEntity.getAllEntities().get(entrytype)).getFields();
        QtyProp serialQtyProp = (QtyProp)allEntryFields.get(serialQtyKey);
        return serialQtyProp.getRelatedUnit();
    }

    private static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static Object getUpSnRelationId(String billType, String entryName, DynamicObject bill, DynamicObject entry) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("botp_track_only_dirt_link", "true");
        List bfRows = BFTrackerServiceHelper.loadSourceRowIds((String)billType, (String)entryName, (Long[])new Long[]{bill.getLong("id")}, (Long[])new Long[]{entry.getLong("id")}, (OperateOption)operateOption);
        Long sourceEntryID = null;
        if (bfRows != null && !bfRows.isEmpty()) {
            sourceEntryID = ((BFRow)bfRows.get(0)).getSId().getEntryId();
        }
        Object billSnRelationId = null;
        if (sourceEntryID != null) {
            QFilter filter = new QFilter("entryid", "=", (Object)sourceEntryID);
            DynamicObject billSNRelation = QueryServiceHelper.queryOne((String)"sbs_billsnrelation", (String)"id", (QFilter[])filter.toArray());
            billSnRelationId = billSNRelation != null ? billSNRelation.get("id") : null;
        }
        return billSnRelationId;
    }

    private static void quickFullInputSerialNumber(String billType, Long billId, String entryName, Map<Long, List<Map<String, Object>>> allEntrySerials) {
        QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", (Object)billId).and("entryid", "in", allEntrySerials.keySet());
        String selector = "entryid,billtype,entrykey,billid,entryentity.handlestatus,entryentity.seq,entryentity.snnumber,entryentity.invorg";
        DynamicObject[] billSNRelationsById = BusinessDataServiceHelper.load((String)"sbs_billsnrelation", (String)selector, (QFilter[])filter.toArray());
        HashMap<Long, DynamicObject> billSNRelationsByEntryId = new HashMap<Long, DynamicObject>(billSNRelationsById.length);
        for (DynamicObject billSNRelation : billSNRelationsById) {
            Long entryId = billSNRelation.getLong("entryid");
            billSNRelationsByEntryId.put(entryId, billSNRelation);
        }
        ArrayList<DynamicObject> billSNRelationsForSave = new ArrayList<DynamicObject>(allEntrySerials.size());
        for (Map.Entry<Long, List<Map<String, Object>>> entrySerials : allEntrySerials.entrySet()) {
            DynamicObjectCollection entryEntity;
            Long entryId = entrySerials.getKey();
            List<Map<String, Object>> serialList = entrySerials.getValue();
            DynamicObject billSNRelation = (DynamicObject)billSNRelationsByEntryId.get(entryId);
            if (billSNRelation == null) {
                billSNRelation = BusinessDataServiceHelper.newDynamicObject((String)"sbs_billsnrelation");
                billSNRelation.set("billtype", (Object)billType);
                billSNRelation.set("entrykey", (Object)entryName);
                billSNRelation.set("billid", (Object)billId);
                billSNRelation.set("entryid", (Object)entryId);
            }
            if ((entryEntity = billSNRelation.getDynamicObjectCollection("entryentity")).size() > 0) {
                entryEntity.clear();
            }
            for (int i = 1; i <= serialList.size(); ++i) {
                Map<String, Object> serial = serialList.get(i - 1);
                DynamicObject singleSn = entryEntity.addNew();
                singleSn.set("handlestatus", (Object)"A");
                singleSn.set("seq", (Object)i);
                for (Map.Entry<String, Object> serialItem : serial.entrySet()) {
                    singleSn.set(serialItem.getKey(), serialItem.getValue());
                }
            }
            billSNRelationsForSave.add(billSNRelation);
        }
        if (!billSNRelationsForSave.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])billSNRelationsForSave.toArray(new DynamicObject[0]));
        }
    }

    private static String getSerialQtyKey(String billtype, String entrytype, Long billid, String defaultQtyKey) {
        DynamicObject cfg = SerialNumberOpUtil.getSNBillConfigByBillId(billtype, entrytype, billid);
        if (cfg != null) {
            String serialQtyKey = SerialNumberOpUtil.getPureKey(cfg.getString("snbaseqtycol"));
            return serialQtyKey;
        }
        return defaultQtyKey;
    }

    public static String getPureKey(String currentKey) {
        if (StringUtils.isNotEmpty((String)currentKey) && currentKey.lastIndexOf(46) != -1) {
            return currentKey.substring(currentKey.lastIndexOf(46) + 1);
        }
        return currentKey;
    }

    public static DynamicObject getSNBillConfigByBillId(String billtype, String entrytype, Long billid) {
        Collection<DynamicObject> cfgs = SerialNumberOpUtil.getSNBillConfig(billtype, entrytype);
        for (DynamicObject cfg : cfgs) {
            DynamicObject result;
            QFilter filter = new QFilter("id", "=", (Object)billid);
            QFilter cfgFilter = SerialNumberOpUtil.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            if ((result = QueryServiceHelper.queryOne((String)billtype, (String)"id", (QFilter[])filter.toArray())) == null) continue;
            return cfg;
        }
        return null;
    }

    private static QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    private static Collection<DynamicObject> getSNBillConfig(String billtype, String entrytype) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"sbs_snbillconfig", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted((cfg1, cfg2) -> {
            Long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
            return result > 0L ? 1 : (result < 0L ? -1 : 0);
        }).collect(Collectors.toList());
    }

    private static void showSerialNumberPage(IFormView view, String itemKey, Map<String, Object> param) {
        IDataModel model = view.getModel();
        switch (itemKey) {
            case "checksnnumber": {
                SerialNumberOpUtil.showPageCheckSNNumber(view, param);
                break;
            }
            case "entersnnumber": {
                if (!"A".equals(model.getValue("billstatus"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5f55\u5165\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_10", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    return;
                }
                SerialNumberOpUtil.showPageEnterSNNumber(view, param);
                break;
            }
            case "importsnnumber": {
                if (!"A".equals(model.getValue("billstatus"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u4e3a\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_11", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    return;
                }
                if (SerialNumberOpUtil.checkExistBotpSrcSeq(param)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u6ca1\u6709\u5e8f\u5217\u53f7\u5173\u8054\u65f6\u624d\u80fd\u5bfc\u5165\u5e8f\u5217\u53f7\u3002", (String)"SerialNumberOpUtil_12", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    return;
                }
                SerialNumberOpUtil.showPageImportSNNumber(view, param);
                break;
            }
        }
    }

    private static boolean checkExistBotpSrcSeq(Map<String, Object> param) {
        Long billid = (Long)param.get("billid");
        String billtype = (String)param.get("billtype");
        Long entryid = (Long)param.get("entryid");
        String entrykey = (String)param.get("entrykey");
        boolean srcSeqFlag = QueryServiceHelper.exists((String)"sbs_billsnrelation", (QFilter[])new QFilter("billtype", "=", (Object)billtype).and("billid", "=", (Object)billid).and("entrykey", "=", (Object)entrykey).and("entryid", "=", (Object)entryid).and("srcbillid", "!=", (Object)0).toArray());
        return srcSeqFlag;
    }

    private static void showPageCheckSNNumber(IFormView view, Map<String, Object> showCheckSNNumberParam) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u5e8f\u5217\u53f7", (String)"SerialNumberOpUtil_17", (String)"bos-ext-scmc", (Object[])new Object[0]));
        baseShowParameter.setFormId((String)showCheckSNNumberParam.get("enterlayout"));
        Object relationId = showCheckSNNumberParam.get("billsnrelationid");
        if (relationId != null) {
            baseShowParameter.setPkId(relationId);
        }
        baseShowParameter.setFormId((String)showCheckSNNumberParam.get("enterlayout"));
        baseShowParameter.setCustomParams(showCheckSNNumberParam);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    private static void showPageEnterSNNumber(IFormView view, Map<String, Object> showEnterSNNumberParam) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u5f55\u5165\u5e8f\u5217\u53f7", (String)"SerialNumberOpUtil_13", (String)"bos-ext-scmc", (Object[])new Object[0]));
        baseShowParameter.setFormId((String)showEnterSNNumberParam.get("enterlayout"));
        Object relationId = showEnterSNNumberParam.get("billsnrelationid");
        if (relationId != null) {
            baseShowParameter.setPkId(relationId);
        }
        baseShowParameter.setCustomParams(showEnterSNNumberParam);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        view.showForm((FormShowParameter)baseShowParameter);
    }

    private static void showPageImportSNNumber(IFormView view, Map<String, Object> showImportSNNumberParam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sbs_importsn");
        showParameter.setCustomParams(showImportSNNumberParam);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack(ImportSerialNumberCallBack.class.getName(), "sbs_importsn"));
        view.showForm(showParameter);
    }

    public static Object getValueByName(DynamicObject bill, DynamicObject entry, String colName) {
        if (colName.contains(".")) {
            return entry.get(SerialNumberOpUtil.getPureKey(colName));
        }
        return bill.get(colName);
    }
}

