/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ContPerformCtrlValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject[] bills = new DynamicObject[this.dataEntities.length];
        for (int i = 0; i < bills.length; ++i) {
            bills[i] = this.dataEntities[i].getDataEntity();
        }
        Map results = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"IContPerformCtrlService", (String)"validate", (Object[])new Object[]{bills, this.getOperateKey()});
        if (results != null && !results.isEmpty()) {
            this.handle(results, this.dataEntities, this);
        }
    }

    private void handle(Map<String, Object> results, ExtendedDataEntity[] dataEntities, ContPerformCtrlValidator validator) {
        Boolean success = (Boolean)results.get("success");
        if (success.booleanValue()) {
            return;
        }
        List errorMsg = (List)results.get("errorInfos");
        if (errorMsg != null && !errorMsg.isEmpty()) {
            Map<String, List<OperateErrorInfo>> groupByBill = errorMsg.stream().collect(Collectors.groupingBy(a -> String.valueOf(a.getPkValue())));
            for (ExtendedDataEntity dt : dataEntities) {
                List<OperateErrorInfo> errorInfos = groupByBill.get(dt.getDataEntity().getPkValue().toString());
                if (errorInfos == null || errorInfos.size() <= 0) continue;
                errorInfos.sort(Comparator.comparingInt(OperateInfo::getRowIndex));
                for (OperateErrorInfo info : errorInfos) {
                    String message;
                    if (info == null || !StringUtils.isNotEmpty((CharSequence)(message = info.getMessage()))) continue;
                    this.addErrorMessage(dt, message);
                }
            }
        }
    }

    public void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addErrorMessage(dataEntity, content);
    }

    public void addWarningMessage(ExtendedDataEntity dataEntity, String content) {
        super.addWarningMessage(dataEntity, content);
    }
}

