/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff.wfmanual.searcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class WfManualDataReader {
    private String entityNumber;
    private String wfMainField;
    private String mainEntryId;
    private String wfCfgFilter;
    private String curEntryKey;
    private String mainType;
    private Set<String> formulafields = new HashSet<String>(8);
    private List<QFilter> billFilters = new ArrayList<QFilter>(16);
    private Set<Object> entryIds = null;
    private Set<Object> billIds = null;
    private String expression;

    public WfManualDataReader(String entityNumber, String wfMainField, String wfCfgFilter, String curEntryKey) {
        this.entityNumber = entityNumber;
        this.wfCfgFilter = wfCfgFilter;
        this.curEntryKey = curEntryKey;
        String[] split = wfMainField.split("@@");
        this.wfMainField = split[0];
        this.mainType = split[1];
        this.getEntryKey();
    }

    private void getEntryKey() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        if ("B".equals(this.mainType)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)this.wfMainField, CRCondition.class);
            String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
            IDataEntityProperty property = dataEntityType.findProperty(columns[0]);
            String entryName = property.getParent().getName();
            this.mainEntryId = !dataEntityType.getName().equals(entryName) ? entryName + ".id" : entryName;
            List<String> fields = Arrays.asList(columns);
            this.formulafields.addAll(fields);
            this.expression = condition.getExpression();
        } else if ("A".equals(this.mainType)) {
            this.mainEntryId = this.getEntryKey(dataEntityType, this.wfMainField);
        }
    }

    public TableValueSetter createTableValueSetter(List<String> selectFields, Map<String, String> billFormFieldMap, Map<String, String> wfFieldAssitFieldMap) {
        TableValueSetter tableValueSetter;
        selectFields.remove("billid");
        selectFields.remove("billentryid");
        String selectFieldStr = this.getSelectFieldStr(this.entityNumber, selectFields);
        if (StringUtils.isEmpty((CharSequence)selectFieldStr)) {
            return new TableValueSetter(new String[0]);
        }
        try (DataSet billDs = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.entityNumber, (String)selectFieldStr, (QFilter[])this.getFilters(), null);){
            tableValueSetter = this.getTableValueSetter(selectFields, billDs, billFormFieldMap, wfFieldAssitFieldMap);
        }
        return tableValueSetter;
    }

    private TableValueSetter getTableValueSetter(List<String> formFields, DataSet billDs, Map<String, String> billFormFieldMap, Map<String, String> wfFieldAssitField) {
        this.filterHighCondition();
        boolean isEntryIdsNull = this.entryIds == null;
        boolean isBillIdsNull = this.billIds == null;
        ArrayList<String> fields = new ArrayList<String>(16);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : formFields) {
            vs.addField(billFormFieldMap.get(string), new Object[0]);
        }
        fields.addAll(formFields);
        ArrayList<String> formWfFields = new ArrayList<String>(wfFieldAssitField.keySet());
        fields.addAll(formWfFields);
        for (String item : formWfFields) {
            vs.addField(wfFieldAssitField.get(item), new Object[0]);
        }
        String string = billFormFieldMap.get("curwfdata");
        if (string != null) {
            vs.addField(string, new Object[0]);
            fields.add("curwfdata");
        }
        int valuesSizes = fields.size();
        String suffix = this.curEntryKey.replace("entry", "");
        String entryBillId = "billid" + suffix;
        String entryBillEntryId = "billentryid" + suffix;
        vs.addField(entryBillId, new Object[0]);
        vs.addField(entryBillEntryId, new Object[0]);
        valuesSizes += 2;
        for (Row row : billDs) {
            Object billId = row.get("billid");
            Object billEntryId = row.get("billentryid");
            if (!isBillIdsNull && !this.billIds.contains(billId) || !isEntryIdsNull && !this.entryIds.contains(billEntryId)) continue;
            Object[] values = new Object[valuesSizes];
            for (int i = 0; i < fields.size(); ++i) {
                if (wfFieldAssitField.containsKey(fields.get(i))) {
                    this.mainAsstFieldSetVal(fields, row, values, i);
                    continue;
                }
                this.commonFieldSetVal(fields, row, values, i);
            }
            values[fields.size()] = billId;
            values[fields.size() + 1] = billEntryId;
            vs.addRow(values);
        }
        return vs;
    }

    private void commonFieldSetVal(List<String> fields, Row row, Object[] values, int i) {
        Object result;
        values[i] = fields.get(i).endsWith("curwfdata") ? (result = this.getFormulaValue(row)) : row.get(fields.get(i));
    }

    private void mainAsstFieldSetVal(List<String> fields, Row row, Object[] values, int i) {
        Object result;
        String mainFiled = fields.get(i);
        values[i] = "curwfdata".equals(mainFiled) ? (result = this.getFormulaValue(row)) : row.get(fields.get(i));
    }

    private Object getFormulaValue(Row row) {
        HashMap<String, Object> args = new HashMap<String, Object>(16);
        for (String field : this.formulafields) {
            args.put(field, row.get(field));
        }
        return FormulaEngine.execExcelFormula((String)this.expression, args);
    }

    private void filterHighCondition() {
        if (this.wfCfgFilter.isEmpty()) {
            return;
        }
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)this.wfCfgFilter, CRCondition.class);
        String expression = condition.getExpression();
        if (expression != null && !expression.isEmpty()) {
            DynamicObject[] billDycs;
            List<String> fields = this.getFields(expression);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
            QFilter[] billfs = this.getFilters();
            String entryKey = this.mainEntryId;
            boolean isBillHead = dataEntityType.getPrimaryKey().getName().equals(entryKey);
            if (!isBillHead) {
                fields.add(entryKey);
            }
            List ids = QueryServiceHelper.queryPrimaryKeys((String)this.entityNumber, (QFilter[])billfs, null, (int)-1);
            DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)this.entityNumber, fields);
            for (DynamicObject billDyc : billDycs = BusinessDataReader.load((Object[])ids.toArray(new Object[0]), (DynamicObjectType)subDataEntityType, (Boolean)Boolean.TRUE)) {
                if (isBillHead) {
                    boolean checkPass;
                    if (this.billIds == null) {
                        this.billIds = new HashSet<Object>(16);
                    }
                    if (!(checkPass = this.checkHighCondition(dataEntityType.getName(), (MainEntityType)subDataEntityType, expression, billDyc))) continue;
                    this.billIds.add(billDyc.getPkValue());
                    continue;
                }
                if (this.entryIds == null) {
                    this.entryIds = new HashSet<Object>(16);
                }
                entryKey = entryKey.replace(".id", "");
                for (DynamicObject entryDyc : billDyc.getDynamicObjectCollection(entryKey)) {
                    boolean checkPass = this.checkHighCondition(entryKey, (MainEntityType)subDataEntityType, expression, entryDyc);
                    if (!checkPass) continue;
                    this.entryIds.add(entryDyc.getPkValue());
                }
            }
        }
    }

    private List<String> getFields(String expression) {
        String[] varFields = FormulaEngine.extractVariables((String)expression);
        List<String> fields = Arrays.asList(varFields);
        return new ArrayList<String>(fields);
    }

    private String getEntryKey(MainEntityType dataEntityType, String wfMainField) {
        int lastPointIndex;
        String entryId = null;
        entryId = wfMainField != null ? ((lastPointIndex = wfMainField.lastIndexOf(".")) == -1 ? dataEntityType.getPrimaryKey().getName() : wfMainField.substring(0, lastPointIndex) + ".id") : dataEntityType.getPrimaryKey().getName();
        return entryId;
    }

    private String getSelectFieldStr(String entityNumber, List<String> formFields) {
        StringBuilder selectFieldSb = new StringBuilder();
        if (formFields.size() < 1) {
            return selectFieldSb.toString();
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map billAllFields = dataEntityType.getAllFields();
        HashSet<String> set = new HashSet<String>(16);
        set.addAll(formFields);
        set.addAll(this.formulafields);
        this.addFormFields(set, selectFieldSb, billAllFields);
        selectFieldSb.append("id as ");
        selectFieldSb.append("billid");
        selectFieldSb.append(",");
        String entryIdKey = this.mainEntryId;
        selectFieldSb.append(entryIdKey);
        selectFieldSb.append(" as ");
        selectFieldSb.append("billentryid");
        return selectFieldSb.toString();
    }

    private void addFormFields(Set<String> formFields, StringBuilder selectFieldSb, Map<String, IDataEntityProperty> billAllFields) {
        for (String item : formFields) {
            IDataEntityProperty prop = billAllFields.get(item);
            IDataEntityType parentProp = prop.getParent();
            String field = this.getFieldPath(item, parentProp);
            selectFieldSb.append(field);
            selectFieldSb.append(" as ");
            selectFieldSb.append(item);
            selectFieldSb.append(",");
        }
    }

    private String getFieldPath(String field, IDataEntityType parentProp) {
        if (parentProp instanceof EntryType) {
            field = parentProp.getName() + "." + field;
            return this.getFieldPath(field, parentProp.getParent());
        }
        return field;
    }

    private QFilter[] getFilters() {
        QFilter[] billfs = null;
        if (this.billFilters.size() > 0) {
            billfs = this.billFilters.toArray(new QFilter[0]);
        }
        return billfs;
    }

    public void setBillFilters(List<QFilter> billFilters) {
        this.billFilters = billFilters;
    }

    private boolean checkHighCondition(String entry, MainEntityType type, String preCondition, DynamicObject dynamicObject) {
        RowDataModel rowDataModel = new RowDataModel(entry, type);
        ExpressionParameter preConditionParam = new ExpressionParameter(preCondition, rowDataModel);
        preConditionParam.setFcunLib(FunctionManage.get());
        preConditionParam.setActiveRow((Object)dynamicObject);
        return (Boolean)CalcExprParser.getExpressionValue((ExpressionParameter)preConditionParam);
    }
}

