/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.data.idi.formplugin.IDIHighLightFormPlugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SmartPanelPlugin
extends IDIHighLightFormPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(SmartPanelPlugin.class);
    private static final String KEY_BILLTYPE = "billType";
    private static final String KEY_BILLID = "billId";
    private static final String KEY_SCHEMANUMBER = "schemaNumber";
    private static final String KEY_ACTION = "action";
    private static final String KEY_REFRESHRESULT = "refreshResult";
    private static final String KEY_VERSION = "version";
    private static final String KEY_SHOWRISKCHECKDATA = "showRiskCheckData";
    private static final String KEY_SHOWBILLLIST = "showBillList";
    private static final String KEY_PARALLELRESULT = "parallelResult";
    private static final String CUSTOM_CONTROLAP = "customcontrolap";

    public void initialize() {
        super.initialize();
        String schemetabKey = StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("schemetab")) ? this.getPageCache().get("schemetab") : "tabap";
        Tab tab = (Tab)this.getControl(schemetabKey);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!"wfforpc".equals(this.getPageCache().get("schemescene"))) {
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            this.sendInvoke(dataEntity, null);
        }
    }

    protected void sendInvoke(DynamicObject bill, List<String> schemaList) {
        if (bill == null) {
            logger.info("show smart panel error : bill is null");
            return;
        }
        String pkObject = String.valueOf(bill.getPkValue());
        if ("null".equalsIgnoreCase(pkObject) || "0".equalsIgnoreCase(pkObject) || StringUtils.isBlank((CharSequence)pkObject)) {
            logger.info("show smart panel error : billid is null");
            return;
        }
        logger.info("\u5355\u636eid\uff1a" + pkObject);
        IDataEntityType dataType = bill.getDataEntityType();
        String entityName = dataType.getName();
        if (QueryServiceHelper.exists((String)entityName, (Object)bill.getPkValue())) {
            String schemaStr = "";
            if (schemaList != null && !schemaList.isEmpty()) {
                schemaStr = this.schemaListToString(schemaList);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            this.getPageCache().put(KEY_BILLID, String.valueOf(bill.getPkValue()));
            this.getPageCache().put(KEY_BILLTYPE, dataType.getName());
            map.put(KEY_ACTION, KEY_REFRESHRESULT);
            if (StringUtils.isNotBlank((CharSequence)schemaStr)) {
                this.getPageCache().put(KEY_SCHEMANUMBER, schemaStr);
            }
            map.put(KEY_VERSION, String.valueOf(System.nanoTime()));
            CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
            control.setData(map);
        } else {
            logger.info("show smart panel error : billid not saved");
        }
    }

    protected void hideSmartPanel() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{this.getSmartPanelKey()});
    }

    protected void showSmartPanel() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{this.getSmartPanelKey()});
    }

    protected String getSmartPanelKey() {
        return CUSTOM_CONTROLAP;
    }

    protected void updateSmartPanel(String billType, Object billId, List<String> schemaNumberList) {
        DynamicObject billObj;
        if (billType == null || billId == null) {
            return;
        }
        Object pk = billId;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        if (billId instanceof String && mainEntityType.getPrimaryKey().getPropertyType().equals(Long.TYPE)) {
            String billIdStr = (String)billId;
            pk = Long.valueOf(billIdStr);
        }
        if ((billObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billType, (String)"id")) == null) {
            logger.info(String.format("bill [%s][%s] not found", billType, String.valueOf(billId)));
            return;
        }
        this.updateData(billObj, schemaNumberList);
    }

    protected void updateSmartPanel(String billType, Object billId, String schemaNumber) {
        DynamicObject billObj;
        if (billType == null || billId == null) {
            return;
        }
        Object pk = billId;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        if (billId instanceof String && mainEntityType.getPrimaryKey().getPropertyType().equals(Long.TYPE)) {
            String billIdStr = (String)billId;
            pk = Long.valueOf(billIdStr);
        }
        if ((billObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billType, (String)"id")) == null) {
            logger.info(String.format("bill [%s][%s] not found", billType, String.valueOf(billId)));
            return;
        }
        this.updateData(billObj, schemaNumber);
    }

    protected boolean updateSmartPanel(DynamicObject billObj) {
        if (billObj == null) {
            return false;
        }
        Object billId = billObj.getPkValue();
        String billType = billObj.getDataEntityType().getName();
        if (billType == null || billId == null) {
            return false;
        }
        if (billId instanceof Long && (Long)billId == 0L) {
            return false;
        }
        return this.updateData(billObj, (String)null);
    }

    protected boolean updateSmartPanel(DynamicObject billObj, List<String> schemaNumberList) {
        if (billObj == null) {
            return false;
        }
        Object billId = billObj.getPkValue();
        String billType = billObj.getDataEntityType().getName();
        if (billType == null || billId == null) {
            return false;
        }
        if (billId instanceof Long && (Long)billId == 0L) {
            return false;
        }
        return this.updateData(billObj, schemaNumberList);
    }

    private boolean updateData(DynamicObject billObj, List<String> schemaNumberList) {
        Object[] params;
        String billType = billObj.getDataEntityType().getName();
        Object billId = billObj.getPkValue();
        String pageId = this.getBillPageId();
        this.getPageCache().put(KEY_BILLTYPE, billType);
        this.getPageCache().put(KEY_BILLID, String.valueOf(billId));
        if (schemaNumberList != null && !schemaNumberList.isEmpty()) {
            params = new Object[]{billObj, schemaNumberList, pageId};
            this.getPageCache().put(KEY_SCHEMANUMBER, this.schemaListToString(schemaNumberList));
        } else {
            params = new Object[]{billObj, new ArrayList(), pageId};
            this.getPageCache().remove(KEY_SCHEMANUMBER);
        }
        String result = null;
        try {
            result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaParallelService", (String)"executeSchemaByList", (Object[])params);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        logger.info("schemescene is " + this.getPageCache().get("schemescene"));
        return !"wfforpc".equals(this.getPageCache().get("schemescene")) ? this.processResult(result) : this.processResultByWorkFlow(result);
    }

    private String schemaListToString(List<String> schemaNumberList) {
        StringBuilder sb = new StringBuilder();
        for (String number : schemaNumberList) {
            sb.append(number).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean updateData(DynamicObject billObj, String schemaNumber) {
        Object[] params;
        String billType = billObj.getDataEntityType().getName();
        Object billId = billObj.getPkValue();
        String pageId = this.getBillPageId();
        this.getPageCache().put(KEY_BILLTYPE, billType);
        this.getPageCache().put(KEY_BILLID, String.valueOf(billId));
        if (StringUtils.isNotEmpty((CharSequence)schemaNumber)) {
            params = new Object[]{billObj, schemaNumber, pageId};
            this.getPageCache().put(KEY_SCHEMANUMBER, schemaNumber);
        } else {
            params = new Object[]{billObj, pageId};
            this.getPageCache().remove(KEY_SCHEMANUMBER);
        }
        String result = null;
        try {
            result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaParallelService", (String)"executeSchema", (Object[])params);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        logger.info("schemescene is " + this.getPageCache().get("schemescene"));
        return !"wfforpc".equals(this.getPageCache().get("schemescene")) ? this.processResult(result) : this.processResultByWorkFlow(result);
    }

    protected boolean processResult(String result) {
        logger.info(result);
        CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                if ("success".equalsIgnoreCase((String)map.get("status"))) {
                    map.put(KEY_VERSION, System.nanoTime());
                    this.visibleCustomControl(true);
                    control.setData((Object)map);
                    return true;
                }
                this.visibleCustomControl(false);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        return false;
    }

    private String getCustomParent(Container container) {
        for (Control c : container.getItems()) {
            if (c instanceof Container) {
                String hasCustomAp = this.getCustomParent((Container)c);
                if (!StringUtils.isNotEmpty((CharSequence)hasCustomAp)) continue;
                return hasCustomAp;
            }
            if (!this.getSmartPanelKey().equals(c.getKey())) continue;
            return container.getKey();
        }
        return "";
    }

    protected String getInvoiceEventName() {
        return "searchResult";
    }

    protected String getInvoiceFormId() {
        return "idi_invoiceview";
    }

    protected String getInvoiceFormParameter() {
        return "invoiceresult";
    }

    public void customEvent(CustomEventArgs e) {
        logger.info(String.format("customEventArgs's key is %s\u3002 customEventArgs's eventName is %s\u3002 customEventArgs's eventArgs is %s", e.getKey(), e.getEventName(), e.getEventArgs()));
        if (this.getSmartPanelKey().equalsIgnoreCase(e.getKey())) {
            if (this.getInvoiceEventName().equalsIgnoreCase(e.getEventName())) {
                RequestContext ctx = RequestContext.get();
                String invoiceResult = e.getEventArgs();
                if (StringUtils.isNotEmpty((CharSequence)invoiceResult)) {
                    List list = JSON.parseArray((String)invoiceResult, Map.class);
                    String imageNo = (String)((Map)list.get(0)).get("imageNo");
                    String url = ImageServiceHelper.viewPhoto((String)imageNo, (String)ctx.getUserId(), (String)ctx.getUserName());
                    if (url == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"NoPhoto", (String)"bos-ext-data", (Object[])new Object[0]));
                    } else {
                        this.getView().openUrl(url);
                    }
                }
            } else if (KEY_REFRESHRESULT.equalsIgnoreCase(e.getEventName())) {
                String billType = this.getPageCache().get(KEY_BILLTYPE);
                String billId = this.getPageCache().get(KEY_BILLID);
                String schemaNumber = this.getPageCache().get(KEY_SCHEMANUMBER);
                if (StringUtils.isNotEmpty((CharSequence)billType) && StringUtils.isNotEmpty((CharSequence)billId)) {
                    if (!StringUtils.isBlank((CharSequence)schemaNumber) && schemaNumber.indexOf(",") > 0) {
                        List<String> schemaNumberList = Arrays.asList(schemaNumber.split(","));
                        this.updateSmartPanel(billType, (Object)billId, schemaNumberList);
                    } else {
                        this.updateSmartPanel(billType, (Object)billId, schemaNumber);
                    }
                }
            } else if ("showBillForm".equalsIgnoreCase(e.getEventName())) {
                String showBillFormResult = e.getEventArgs();
                if (StringUtils.isNotEmpty((CharSequence)showBillFormResult)) {
                    boolean permission;
                    Map map = (Map)JSON.parseObject((String)showBillFormResult, Map.class);
                    Object pkValue = map.get(KEY_BILLID);
                    String entityNum = String.valueOf(map.get("entityNumber"));
                    MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNum);
                    Class primaryKeyType = mainType.getPrimaryKey().getPropertyType();
                    if (Long.TYPE == primaryKeyType || Long.class == primaryKeyType) {
                        pkValue = Long.valueOf(pkValue.toString());
                    } else if (String.class == primaryKeyType) {
                        pkValue = pkValue.toString();
                    }
                    logger.info("\u8868\u5355\u6807\u8bc6\uff1a" + entityNum);
                    RequestContext context = RequestContext.get();
                    String orgPermField = this.getOrgField(mainType);
                    logger.info("\u6743\u9650\u63a7\u5236\u5b57\u6bb5\uff1a" + orgPermField);
                    Long orgId = null;
                    if (StringUtils.isNotEmpty((CharSequence)orgPermField)) {
                        DynamicObject billObj = QueryServiceHelper.queryOne((String)mainType.getName(), (String)orgPermField, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
                        orgId = billObj.getLong(orgPermField);
                    }
                    logger.info("\u5355\u636e\u6743\u9650\u63a7\u5236\u5b57\u6bb5\u503c\uff1a" + orgId);
                    boolean bl = permission = orgId == null || PermissionServiceHelper.checkPermission((Long)context.getCurrUserId(), (Long)orgId, (String)mainType.getAppId(), (String)entityNum, (String)"47150e89000000ac") > 0;
                    if (permission) {
                        BillShowParameter billShowParameter = new BillShowParameter();
                        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
                        billShowParameter.setStatus(OperationStatus.VIEW);
                        billShowParameter.setFormId(entityNum);
                        billShowParameter.setPkId(pkValue);
                        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        this.getView().showForm((FormShowParameter)billShowParameter);
                        String highLightVal = (String)map.get("highLightKey");
                        if (kd.bos.util.StringUtils.isNotEmpty((String)highLightVal)) {
                            String pageId = billShowParameter.getPageId();
                            HashMap<String, Object> heightVisibleMap = new HashMap<String, Object>(3);
                            heightVisibleMap.put(KEY_ACTION, "linkBillHeightVisible");
                            heightVisibleMap.put("pageId", pageId);
                            heightVisibleMap.put("highLightKey", highLightVal);
                            heightVisibleMap.put(KEY_BILLTYPE, entityNum);
                            heightVisibleMap.put(KEY_BILLID, String.valueOf(pkValue));
                            heightVisibleMap.put("needDelay", this.hasChild());
                            CustomControl control = (CustomControl)this.getView().getControl(CUSTOM_CONTROLAP);
                            control.setData(heightVisibleMap);
                        }
                    } else {
                        String field = "billno";
                        if (mainType instanceof BasedataEntityType) {
                            field = "number";
                        }
                        DynamicObject billObj = QueryServiceHelper.queryOne((String)entityNum, (String)field, (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5355\u636e%s\u7684\u6570\u636e\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SmartPanelPlugin_0", (String)"bos-ext-data", (Object[])new Object[0]), billObj.getString(field)));
                    }
                }
            } else if ("chatYZJ".equalsIgnoreCase(e.getEventName())) {
                String chatYZJParamStr = e.getEventArgs();
                if (StringUtils.isNotEmpty((CharSequence)chatYZJParamStr)) {
                    Map map = (Map)JSON.parseObject((String)chatYZJParamStr, Map.class);
                    Object userId = map.get("userId");
                    ArrayList<Long> userList = new ArrayList<Long>();
                    userList.add(Long.valueOf(String.valueOf(userId)));
                    UserOperationUtils.chatYZJ((IFormView)this.getView(), userList);
                }
            } else if ("showInvoiceForm".equals(e.getEventName())) {
                String showInvoiceParamStr = e.getEventArgs();
                logger.info(String.format("\u8fdb\u5165\u53d1\u7968\u67e5\u770b\u64cd\u4f5c\uff0c\u53c2\u6570%s", showInvoiceParamStr));
                if (StringUtils.isNotBlank((CharSequence)showInvoiceParamStr)) {
                    Map map = (Map)JSON.parseObject((String)showInvoiceParamStr, Map.class);
                    Object serialNo = map.get("serialNo");
                    logger.info(String.format("\u53d1\u7968\u5e8f\u5217\u53f7%s", serialNo));
                    if (serialNo != null && StringUtils.isNotBlank((CharSequence)String.valueOf(serialNo))) {
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setCustomParam("serialNo", serialNo);
                        showParameter.setCustomParam("editAllow", (Object)Boolean.FALSE);
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setFormId("rim_inv_collect_edit");
                        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u9884\u89c8", (String)"IDIFloatLayerFormPlugin_8", (String)"data-idi-formplugin", (Object[])new Object[0]));
                        this.getView().showForm(showParameter);
                    }
                }
            } else if (KEY_SHOWRISKCHECKDATA.equalsIgnoreCase(e.getEventName())) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("idi_data_riskcheck");
                showParameter.setShowTitle(false);
                showParameter.setCustomParam("riskData", (Object)e.getEventArgs());
                this.getView().showForm(showParameter);
            } else if (KEY_SHOWBILLLIST.equalsIgnoreCase(e.getEventName())) {
                this.showBillListFromHyperlink(e.getEventArgs());
            } else if (KEY_PARALLELRESULT.equalsIgnoreCase(e.getEventName())) {
                String entityNumber = this.getPageCache().get(KEY_BILLTYPE);
                String billId = this.getPageCache().get(KEY_BILLID);
                String billNumber = entityNumber != null && !entityNumber.isEmpty() ? FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId() : entityNumber;
                DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billNumber, (String)"id");
                String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaParallelService", (String)"querySchemaResult", (Object[])new Object[]{dynamicObj, this.getBillPageId()});
                CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
                if (result != null && !result.isEmpty()) {
                    Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                    resultMap.put(KEY_VERSION, System.nanoTime());
                    resultMap.put("norefresh", Boolean.TRUE);
                    control.setData((Object)resultMap);
                }
            } else {
                this.highLightCustomEvent(e);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String billId = this.getPageCache().get("businesskey");
        String schemetabDetail = this.getPageCache().get("schemetabdetail");
        String tabApKey = StringUtils.isNotEmpty((CharSequence)this.getPageCache().get("schemetabdetail")) ? this.getPageCache().get("schemetabdetail") : "tabpageap_advappscheme";
        logger.info(String.format("workflow tabApKey:%s, schemetabdetail:%s, tabkey in event:%s, billId:%s", tabApKey, schemetabDetail, evt.getTabKey(), billId));
        if (tabApKey.equals(evt.getTabKey()) && StringUtils.isNotEmpty((CharSequence)billId)) {
            String loadedKey = "idi_customer_page_load_" + billId;
            logger.info(String.format("loadedKey:%s", this.getPageCache().get(loadedKey)));
            if (!"T".equals(this.getPageCache().get(loadedKey))) {
                DynamicObject billObj;
                String entitynumber = this.getPageCache().get("entitynumber");
                String schemaNumber = this.getPageCache().get("schemenumber");
                logger.info(String.format("workflow entity:%s, billId:%s, schemaNumber: %s", entitynumber, billId, schemaNumber));
                if (StringUtils.isNotEmpty((CharSequence)entitynumber) && StringUtils.isNotEmpty((CharSequence)billId) && StringUtils.isNotEmpty((CharSequence)schemaNumber) && (billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entitynumber, (String)"id")) != null) {
                    try {
                        boolean resultStatus = false;
                        if (!StringUtils.isBlank((CharSequence)schemaNumber) && schemaNumber.indexOf(",") > 0) {
                            List<String> schemaNumberList = Arrays.asList(schemaNumber.split(","));
                            resultStatus = this.updateSmartPanel(billObj, schemaNumberList);
                        } else {
                            resultStatus = this.updateData(billObj, schemaNumber);
                        }
                        if (resultStatus) {
                            this.getPageCache().put(loadedKey, "T");
                        }
                    }
                    catch (Exception e) {
                        this.getView().showErrorNotification(e.getMessage());
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operationKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equalsIgnoreCase(operationKey) || "submit".equalsIgnoreCase(operationKey)) {
            List successIds;
            OperationResult oprationResult = afterDoOperationEventArgs.getOperationResult();
            if (oprationResult.isSuccess() && (successIds = oprationResult.getSuccessPkIds()) != null && !successIds.isEmpty()) {
                String billId = String.valueOf(successIds.get(0));
                IDataModel model = this.getModel();
                String billType = model.getDataEntityType().getName();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(KEY_ACTION, KEY_REFRESHRESULT);
                map.put(KEY_VERSION, String.valueOf(System.nanoTime()));
                this.getPageCache().put(KEY_BILLID, String.valueOf(billId));
                this.getPageCache().put(KEY_BILLTYPE, billType);
                this.visibleCustomControl(true);
                CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
                control.setData(map);
            }
        } else if ("new".equalsIgnoreCase(operationKey)) {
            this.visibleCustomControl(false);
        }
    }

    private void visibleCustomControl(boolean isVisible) {
        FormView view = (FormView)this.getView();
        FormRoot fr = view.getRootControl();
        String parentKey = this.getCustomParent((Container)fr);
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{parentKey});
    }

    private boolean processResultByWorkFlow(String result) {
        logger.info(result);
        CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                map.put(KEY_VERSION, System.nanoTime());
                this.visibleCustomControl(true);
                control.setData((Object)map);
                return true;
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        return false;
    }

    private String getOrgField(MainEntityType mainType) {
        String field = null;
        PermissionControlType permCtrlType = mainType.getPermissionControlType();
        if ("DIM_ORG".equals(permCtrlType.getDimension())) {
            field = permCtrlType.getDataDimensionField();
        }
        return field;
    }

    private void showBillListFromHyperlink(String billHoverJson) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)billHoverJson)) {
            Map map = (Map)JSON.parseObject((String)billHoverJson, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            String entityNumber = String.valueOf(map.get("entityNumber"));
            String billIdJson = (String)map.get(KEY_BILLID);
            Set billIdSet = (Set)JSON.parseObject((String)billIdJson, (TypeReference)new TypeReference<Set<Long>>(){}, (Feature[])new Feature[0]);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String numberField = "billno";
            if (mainType instanceof BasedataEntityType) {
                numberField = "number";
            }
            String orgPermField = this.getOrgField(mainType);
            logger.info(String.format("showBillList entityNumber : %s, numberField : %s, orgField : %s", entityNumber, numberField, orgPermField));
            String pkField = mainType.getPrimaryKey().getName();
            QFilter billIdsFilter = new QFilter(pkField, "in", (Object)billIdSet);
            HashSet<Object> noPermissionOrgIdSet = new HashSet<Object>(4);
            ArrayList<Long> noPermissionBillIdList = new ArrayList<Long>(4);
            ArrayList<Long> hasPermissionBillIdList = new ArrayList<Long>(4);
            Long currUserId = RequestContext.get().getCurrUserId();
            if (kd.bos.util.StringUtils.isNotEmpty((String)orgPermField) && !PermissionServiceHelper.isAdminUser((long)currUserId) && !PermissionServiceHelper.isSuperUser((long)currUserId)) {
                DynamicObjectCollection allCol = QueryServiceHelper.query((String)entityNumber, (String)(pkField + "," + orgPermField), (QFilter[])billIdsFilter.toArray());
                HashMap<Object, Boolean> orgAndPermissionMap = new HashMap<Object, Boolean>(allCol.size());
                for (DynamicObject dynamicObject : allCol) {
                    boolean hasPermission;
                    Long orgId = dynamicObject.getLong(orgPermField);
                    Long billPk = dynamicObject.getLong(pkField);
                    if (!orgAndPermissionMap.containsKey(orgId)) {
                        hasPermission = PermissionServiceHelper.checkPermission((Long)currUserId, (Long)orgId, (String)mainType.getAppId(), (String)entityNumber, (String)"47150e89000000ac") > 0;
                        orgAndPermissionMap.put(orgId, hasPermission);
                    } else {
                        hasPermission = (Boolean)orgAndPermissionMap.get(orgId);
                    }
                    if (hasPermission) {
                        hasPermissionBillIdList.add(billPk);
                        continue;
                    }
                    noPermissionOrgIdSet.add(orgId);
                    noPermissionBillIdList.add(billPk);
                }
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)orgPermField) && !noPermissionOrgIdSet.isEmpty()) {
                HashMap<String, String> billData = new HashMap<String, String>(3);
                if (!hasPermissionBillIdList.isEmpty()) {
                    billData.put("hasPermissionBillIdList", JSON.toJSONString(hasPermissionBillIdList));
                }
                billData.put("entityNumber", entityNumber);
                billData.put("pkField", pkField);
                StringBuilder noPermissionOrgName = new StringBuilder();
                QFilter orgIdFilter = new QFilter("id", "in", noPermissionOrgIdSet);
                DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bos_org", (String)"name", (QFilter[])orgIdFilter.toArray());
                for (DynamicObject org : orgCollection) {
                    noPermissionOrgName.append(org.get("name")).append("\r\n");
                }
                String message = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4ee5\u4e0b%1$d\u4e2a\u7ec4\u7ec7\u7684%2$d\u5f20\u5355\u636e\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\u67e5\u770b\u6709\u6743\u9650\u7684\u5355\u636e\u3002", (String)"IDIFloatLayerFormPlugin_9", (String)"data-idi-formplugin", (Object[])new Object[0]), noPermissionOrgIdSet.size(), noPermissionBillIdList.size());
                this.getView().showConfirm(message, noPermissionOrgName.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(KEY_SHOWBILLLIST, (IFormPlugin)this), null, JSON.toJSONString(billData));
            } else {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId(entityNumber);
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setFormId("bos_list");
                listShowParameter.setShowTitle(false);
                listShowParameter.getListFilterParameter().setFilter(billIdsFilter);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (KEY_SHOWBILLLIST.equals(e.getCallBackId())) {
            String billDataJson;
            MessageBoxResult result = e.getResult();
            if (MessageBoxResult.Yes.getValue() == result.getValue() && kd.bos.util.StringUtils.isNotEmpty((String)(billDataJson = e.getCustomVaule()))) {
                QFilter billIdsFilter;
                Map billDataMap = (Map)JSON.parseObject((String)billDataJson, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                String pkField = (String)billDataMap.get("pkField");
                String hasPermissionBillIdListJson = (String)billDataMap.get("hasPermissionBillIdList");
                if (kd.bos.util.StringUtils.isNotEmpty((String)hasPermissionBillIdListJson)) {
                    List hasPermissionBillIdList = (List)JSON.parseObject((String)hasPermissionBillIdListJson, (TypeReference)new TypeReference<List<Long>>(){}, (Feature[])new Feature[0]);
                    billIdsFilter = new QFilter(pkField, "in", (Object)hasPermissionBillIdList);
                } else {
                    billIdsFilter = new QFilter(pkField, "=", (Object)-1L);
                }
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId((String)billDataMap.get("entityNumber"));
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setFormId("bos_list");
                listShowParameter.setShowTitle(false);
                listShowParameter.getListFilterParameter().setFilter(billIdsFilter);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    @Override
    public String getBillPageId() {
        if (!"wfforpc".equals(this.getPageCache().get("schemescene"))) {
            return super.getBillPageId();
        }
        String sourceBillPageId = this.getPageCache().get("billPageId");
        if (StringUtils.isNotBlank((CharSequence)sourceBillPageId)) {
            return sourceBillPageId.replaceAll(" ", "+");
        }
        return sourceBillPageId;
    }
}

