/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.ext.data.idi.model.EntryHighLight;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.ext.data.idi.model.HighLightHandler;
import kd.bos.form.AbstractFormView;

public class RowBaseHighLight
extends BaseHighLight {
    private EntryHighLight[] entryHighLight;
    protected Map<String, EntryHighLight> cacheEntryHighLightIndex;

    public EntryHighLight[] getEntryHighLight() {
        return this.entryHighLight;
    }

    public void setEntryHighLight(EntryHighLight[] entryHighLight) {
        this.entryHighLight = entryHighLight;
    }

    public void createCache() {
        this.cacheEntryHighLightIndex = new HashMap<String, EntryHighLight>(5);
        if (this.entryHighLight != null && this.entryHighLight.length > 0) {
            for (EntryHighLight entryHighLight : this.getEntryHighLight()) {
                this.cacheEntryHighLightIndex.put(entryHighLight.getEntryName(), entryHighLight);
            }
        }
    }

    public HighLightCursor previousCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        this.createCache();
        if (curHighLightCursor.isHead()) {
            return this.previousHeadFieldCursor(curHighLightCursor.getHeadField());
        }
        EntryHighLight[] entryHighLights = this.getEntryHighLight();
        boolean returnHead = false;
        for (int i = 0; i < entryHighLights.length; ++i) {
            EntryHighLight entryHighLight = entryHighLights[i];
            if (!entryHighLight.getEntryName().equals(curHighLightCursor.getEntryName())) continue;
            HighLightCursor cursor = entryHighLight.previousCursor(curHighLightCursor);
            if (cursor == null) {
                returnHead = true;
                break;
            }
            return cursor;
        }
        if (returnHead) {
            return this.previousHeadFieldCursor(curHighLightCursor.getEntryName());
        }
        return null;
    }

    private HighLightCursor previousHeadFieldCursor(String headFieldOrEntryName) {
        int i;
        String[] headFields = this.getHeadFields();
        if (headFields == null || headFields.length <= 0) {
            if (this.entryHighLight != null && this.entryHighLight.length > 0) {
                headFields = new String[this.entryHighLight.length];
                for (i = 0; i < this.entryHighLight.length; ++i) {
                    headFields[i] = this.entryHighLight[i].getEntryName();
                }
            } else {
                return null;
            }
        }
        for (i = 0; i < headFields.length; ++i) {
            EntryHighLight entryHighLight;
            if (!headFieldOrEntryName.equals(headFields[i])) continue;
            int preIndex = i - 1;
            if (preIndex < 0) {
                preIndex += headFields.length;
            }
            if ((entryHighLight = this.cacheEntryHighLightIndex.get(headFields[preIndex])) == null) {
                return new HighLightCursor(headFields[preIndex]);
            }
            HighLightCursor cursor = entryHighLight.findEnd();
            if (cursor == null) continue;
            return cursor;
        }
        return null;
    }

    private HighLightCursor nextHeadFieldCursor(String headFieldOrEntryName) {
        int i;
        String[] headFields = this.getHeadFields();
        if (headFields == null || headFields.length <= 0) {
            if (this.entryHighLight != null && this.entryHighLight.length > 0) {
                headFields = new String[this.entryHighLight.length];
                for (i = 0; i < this.entryHighLight.length; ++i) {
                    headFields[i] = this.entryHighLight[i].getEntryName();
                }
            } else {
                return null;
            }
        }
        for (i = 0; i < headFields.length; ++i) {
            EntryHighLight entryHighLight;
            if (!headFieldOrEntryName.equals(headFields[i])) continue;
            int nextIndex = i + 1;
            if (nextIndex >= headFields.length) {
                nextIndex %= headFields.length;
            }
            if ((entryHighLight = this.cacheEntryHighLightIndex.get(headFields[nextIndex])) == null) {
                return new HighLightCursor(headFields[nextIndex]);
            }
            HighLightCursor cursor = entryHighLight.findFirst();
            if (cursor == null) continue;
            return cursor;
        }
        return null;
    }

    public HighLightCursor nextCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        this.createCache();
        if (curHighLightCursor.isHead()) {
            return this.nextHeadFieldCursor(curHighLightCursor.getHeadField());
        }
        EntryHighLight[] entryHighLights = this.getEntryHighLight();
        boolean returnHead = false;
        if (entryHighLights != null && entryHighLights.length > 0) {
            for (int i = 0; i < entryHighLights.length; ++i) {
                EntryHighLight entryHighLight = entryHighLights[i];
                if (!entryHighLight.getEntryName().equals(curHighLightCursor.getEntryName())) continue;
                HighLightCursor cursor = entryHighLight.nextCursor(curHighLightCursor);
                if (cursor == null) {
                    returnHead = true;
                    break;
                }
                return cursor;
            }
            if (returnHead) {
                return this.nextHeadFieldCursor(curHighLightCursor.getEntryName());
            }
        }
        return null;
    }

    public HighLightCursor findFirstCursor() {
        block4: {
            block3: {
                String[] headFields = this.getHeadFields();
                if (headFields == null || headFields.length <= 0) break block3;
                this.createCache();
                for (int i = 0; i < headFields.length; ++i) {
                    EntryHighLight entryHighLight = this.cacheEntryHighLightIndex.get(headFields[i]);
                    if (entryHighLight == null) {
                        return new HighLightCursor(headFields[i]);
                    }
                    HighLightCursor cursor = entryHighLight.findFirst();
                    if (cursor == null) continue;
                    return cursor;
                }
                break block4;
            }
            EntryHighLight[] entryHighLights = this.getEntryHighLight();
            if (entryHighLights == null || entryHighLights.length <= 0) break block4;
            for (EntryHighLight entryHighLight : entryHighLights) {
                HighLightCursor cursor = entryHighLight.findFirst();
                if (cursor == null) continue;
                return cursor;
            }
        }
        return null;
    }

    public void createHighLightCommand(AbstractFormView billView, HighLightCursor cursor) {
        if (billView == null) {
            return;
        }
        String[] headFields = this.getHeadFields();
        if (headFields != null && headFields.length > 0) {
            HashSet<String> entryNameSet = new HashSet<String>(3);
            if (this.entryHighLight != null && this.entryHighLight.length > 0) {
                for (EntryHighLight highLight : this.entryHighLight) {
                    entryNameSet.add(highLight.getEntryName());
                }
            }
            Object[] objectArray = headFields;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object field = objectArray[i];
                if (entryNameSet.contains(field)) continue;
                Map<String, Object> ctls = HighLightHandler.createHeadCommand((String)field, cursor != null && cursor.isHead() && cursor.ignoreHeadField((String)field));
                billView.updateControlMetadata((String)field, ctls);
            }
        }
        if (this.entryHighLight != null && this.entryHighLight.length > 0) {
            for (EntryHighLight highLight : this.entryHighLight) {
                highLight.createHighLightCommand(billView, cursor);
            }
        }
        HighLightHandler.createScrollIntoView(cursor, billView);
    }

    public void createHighLightCommandToNewCursor(AbstractFormView billView, HighLightCursor newCursor) {
        if (billView == null) {
            return;
        }
        if (newCursor != null && newCursor.isHead()) {
            Map<String, Object> ctls = HighLightHandler.createHeadCommand(newCursor.getHeadField(), true);
            billView.updateControlMetadata(newCursor.getHeadField(), ctls);
        } else if (this.entryHighLight != null && this.entryHighLight.length > 0) {
            for (EntryHighLight highLight : this.entryHighLight) {
                highLight.createHighLightCommandToNewCursor(billView, newCursor);
            }
        }
        HighLightHandler.createScrollIntoView(newCursor, billView);
    }

    public void createCommandToCancel(AbstractFormView billView) {
        if (billView == null) {
            return;
        }
        String[] headFields = this.getHeadFields();
        if (headFields != null && headFields.length > 0) {
            for (String field : headFields) {
                Map<String, Object> ctls = HighLightHandler.createHeadCommandCancel(field);
                billView.updateControlMetadata(field, ctls);
            }
        }
        if (this.entryHighLight != null && this.entryHighLight.length > 0) {
            for (EntryHighLight highLight : this.entryHighLight) {
                highLight.createCommandToCancel(billView);
            }
        }
    }
}

