/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.bizrule.fpm.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncData;
import kd.bos.ext.tmc.bizrule.fpm.sync.SyncTableManager;

public class SyncDataManager {
    private MainEntityType entityType;
    private SyncTableManager tableMgr;
    private Map<Long, SyncData> cache;
    private boolean enableCache;

    public SyncDataManager(String entityType) {
        this(entityType, true);
    }

    public SyncDataManager(String entityType, boolean enableCache) {
        this.entityType = EntityMetadataCache.getDataEntityType((String)entityType);
        this.tableMgr = SyncTableManager.getInstance();
        if (enableCache) {
            this.cache = new HashMap<Long, SyncData>();
            this.enableCache = true;
        }
    }

    public List<SyncData> getSyncInfo(List<Long> idList) {
        if (idList == null || idList.size() == 0) {
            return new ArrayList<SyncData>(0);
        }
        ArrayList<SyncData> syncDataList = new ArrayList<SyncData>(idList.size());
        if (this.enableCache) {
            HashSet<Long> requestIdSet = new HashSet<Long>(idList);
            Set<Long> cachedIdSet = this.cache.keySet();
            requestIdSet.removeAll(cachedIdSet);
            for (Long dataId : idList) {
                SyncData syncData = this.cache.get(dataId);
                if (syncData == null) continue;
                syncDataList.add(syncData);
            }
            if (requestIdSet.size() > 0) {
                syncDataList.addAll(this.querySyncData(new ArrayList<Long>(requestIdSet)));
            }
        } else {
            syncDataList.addAll(this.querySyncData(idList));
        }
        return syncDataList;
    }

    private List<SyncData> querySyncData(List<Long> idList) {
        String routeKey = this.entityType.getDBRouteKey();
        String tableName = this.entityType.getAlias();
        List<SyncData> syncDataList = this.tableMgr.querySyncData(routeKey, tableName, idList);
        for (SyncData syncData : syncDataList) {
            this.cache.put(syncData.getId(), syncData);
        }
        return syncDataList;
    }

    public List<SyncData> getDiscardIdList() {
        String routeKey = this.entityType.getDBRouteKey();
        String tableName = this.entityType.getAlias();
        return this.tableMgr.queryDiscardInfo(routeKey, tableName);
    }

    public void syncStatus(List<SyncData> dataList, int status) {
        int statusAfter;
        int statusBefore;
        String routeKey = this.entityType.getDBRouteKey();
        String tableName = this.entityType.getAlias();
        this.tableMgr.initTable(routeKey, tableName);
        Set idSet = dataList.stream().map(SyncData::getId).collect(Collectors.toSet());
        List<SyncData> syncDataList = this.tableMgr.querySyncData(routeKey, tableName, new ArrayList<Long>(idSet));
        Set existIdSet = syncDataList.stream().map(SyncData::getId).collect(Collectors.toSet());
        idSet.removeAll(existIdSet);
        if (1 == status) {
            statusBefore = 0;
            statusAfter = 1;
        } else if (3 == status) {
            statusBefore = 2;
            statusAfter = 3;
        } else {
            if (0 == status && existIdSet.size() > 0) {
                this.tableMgr.updateSyncRecords(routeKey, tableName, new ArrayList<Long>(existIdSet), 0);
                return;
            }
            throw new IllegalArgumentException();
        }
        if (idSet.size() > 0) {
            this.tableMgr.insertSyncRecords(routeKey, tableName, statusAfter, new ArrayList<Long>(idSet));
        }
        if (existIdSet.size() > 0) {
            List<SyncData> existSyncDataList = dataList.stream().filter(o -> existIdSet.contains(o.getId())).collect(Collectors.toList());
            this.tableMgr.syncRecord(routeKey, tableName, existSyncDataList, statusBefore, statusAfter);
        }
    }
}

