/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.ImageField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.execute.ExecuteLife;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.BeforeOutputWidgetEvent;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class RecPayToVoucherPrintNew
extends AbstractPrintPlugin {
    private static final Log logger = LogFactory.getLog(RecPayToVoucherPrintNew.class);
    private static final String VOUCHER = "gl_voucher";
    private int receiptPrintPage = 0;
    private int onceCount = 150;

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        DataRowSet mainDataRow = dataSource.getMainDataRow();
        Long voucherPk = (Long)mainDataRow.getField("id").getValue();
        if ("EleReceipt".equals(dataSource.getDsName())) {
            DynamicObject voucher = BusinessDataServiceHelper.loadSingle((String)VOUCHER, (String)"id, sourcebilltype, sourcebill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)voucherPk)});
            DynamicObject voucherSource = voucher.getDynamicObject("sourcebilltype");
            if (voucherSource == null || EmptyUtil.isEmpty(voucherSource.getString("number"))) {
                logger.error("\u51ed\u8bc1" + voucherPk + "\u6e90\u5355\u7c7b\u578b\u4e3a\u7a7a\u3002");
                return;
            }
            List customDataRows = evt.getCustomDataRows();
            List queryField = dataSource.getQueryField();
            if (!queryField.isEmpty()) {
                ArrayList resultUrlList;
                String pngField = (String)queryField.get(0);
                String errMessage = ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u5173\u8054\u7684\u5355\u636e\u6ca1\u6709\u5bf9\u5e94\u7535\u5b50\u56de\u5355\u3002", (String)"RecPayToVoucherPrintNew_0", (String)"bos-ext-tmc", (Object[])new Object[0]);
                try {
                    Map receiptMap = (Map)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"getReceiptIdByIds", (Object[])new Object[]{VOUCHER, new HashSet<Long>(Collections.singletonList(voucherPk))});
                    if (receiptMap.isEmpty() || ((Set)receiptMap.get(voucherPk)).isEmpty()) {
                        logger.warn(errMessage);
                        return;
                    }
                    ArrayList receiptIds = new ArrayList((Collection)receiptMap.get(voucherPk));
                    logger.info("receiptIds.size " + receiptIds.size());
                    List receiptPart = Lists.partition(receiptIds, (int)this.onceCount);
                    resultUrlList = new ArrayList(receiptIds.size());
                    for (List receipts : receiptPart) {
                        ExecuteLife.getOrCreate().doHeartBeat();
                        List result = (List)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"voucherPrintViewReceipts", (Object[])new Object[]{Collections.singletonMap(voucherPk, new HashSet(receipts)), false});
                        resultUrlList.addAll(result);
                    }
                }
                catch (KDBizException e) {
                    logger.warn(e.getMessage());
                    return;
                }
                catch (RuntimeException re) {
                    logger.warn("RuntimeException: " + re.getMessage());
                    if (re.getCause() instanceof IllegalArgumentException || re instanceof KDException) {
                        try {
                            resultUrlList = (ArrayList)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"bei", (String)"viewreceipt", (String)"voucherPrintViewReceipts", (Object[])new Object[]{new HashSet<Long>(Collections.singletonList(voucherPk))});
                        }
                        catch (KDBizException e) {
                            logger.warn(e.getMessage());
                            return;
                        }
                    }
                    throw new RuntimeException(re);
                }
                logger.info("resultUrlList.size " + resultUrlList.size());
                if (resultUrlList.isEmpty()) {
                    logger.warn(errMessage);
                    return;
                }
                this.receiptPrintPage = resultUrlList.size();
                for (String currentPath : resultUrlList) {
                    DataRowSet rowSet = new DataRowSet();
                    rowSet.put(pngField, (Field)new ImageField(currentPath));
                    customDataRows.add(rowSet);
                }
            }
        }
    }

    public void beforeOutputWidget(BeforeOutputWidgetEvent evt) {
        super.beforeOutputWidget(evt);
        Map totalPageMap = this.getTotalPageMap();
        String widgetKey = evt.getWidgetKey();
        if ("pageText".equals(widgetKey) && !totalPageMap.isEmpty() && this.receiptPrintPage > 0) {
            logger.info("pageTextInfo receiptPrintPage: " + this.receiptPrintPage + " totalPageMap.size(): " + totalPageMap.size());
            Field pkId = this.getMainDataVisitor().getField("id");
            Integer page = (Integer)totalPageMap.get(String.valueOf(pkId.getValue()));
            if (page != null && page > 1) {
                AppCustomParam appCustomParam = new AppCustomParam(AppMetadataCache.getAppInfo((String)"bei").getId(), Collections.singleton("receiptPerPage"));
                Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)appCustomParam);
                String receiptPerPage = paramMap.getOrDefault("receiptPerPage", "1");
                String newPageText = Integer.toString((int)((double)page.intValue() - Math.ceil((double)this.receiptPrintPage / (double)Integer.parseInt(receiptPerPage))));
                evt.setOutputValue((Field)new TextField(newPageText));
            }
        }
    }
}

