/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.plugin.fbd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.ext.tmc.bizrule.fbd.pandalist.PandaCheckResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PandaWarningControlPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(PandaWarningControlPlugin.class);
    private static final List<String> PANDA_OP_LIST = Arrays.asList("save", "submit", "audit", "donothing", "committobe");
    private static final String PANDA_MENU = "fbd_pandamenu";
    private static final String DOT = ".";
    private static final int MATCH_FIELD_NUM = 3;
    private static final String PANDA_WARNING_CALLBACK = "pandaWarning";
    private static final String PANDA_CHECK_KEY = "isPandaCheck";
    private String billFormId;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int selectRowCount;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String opType = op.getType();
        if (!PANDA_OP_LIST.contains(opType)) {
            return;
        }
        OperateOption option = op.getOption();
        if (option.containsVariable("isCheck") && Boolean.parseBoolean(option.getVariableValue("isCheck"))) {
            return;
        }
        if (option.containsVariable(PANDA_CHECK_KEY) && Boolean.parseBoolean(option.getVariableValue(PANDA_CHECK_KEY))) {
            return;
        }
        this.getView().getPageCache().put("opKey", operateKey);
        this.getView().getPageCache().put("opVariables", SerializationUtils.toJsonString((Object)option.getVariables()));
        if (this.getView() instanceof IListView) {
            selectRowCount = ((IListView)this.getView()).getSelectedRows().size();
            if (selectRowCount <= 0) {
                return;
            }
        } else {
            selectRowCount = 1;
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(selectRowCount);
        if (this.getView() instanceof IListView) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list == null) {
                logger.warn("billlistap not found.");
                return;
            }
            ArrayList<Long> pkList = new ArrayList<Long>(selectRowCount);
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            Iterator iterator = selectedRows.iterator();
            while (iterator.hasNext()) {
                ListSelectedRow listSelectedRow = (ListSelectedRow)iterator.next();
                pkList.add((Long)listSelectedRow.getPrimaryKeyValue());
            }
            this.billFormId = list.getListModel().getEntityId();
            billList.addAll(Arrays.asList(BusinessDataServiceHelper.load((Object[])pkList.toArray(), (DynamicObjectType)list.getListModel().getDataEntityType())));
        } else {
            billList.add(this.getModel().getDataEntity());
            this.billFormId = this.getView().getEntityId();
        }
        logger.info("PandaWarningControlPlugin Start billFormId: " + this.billFormId + " operateKey: " + operateKey + " pkIds: " + billList.stream().map(b -> b.getLong("id")).collect(Collectors.toList()));
        HashMap<String, PandaCheckResult> warningMap = new HashMap<String, PandaCheckResult>(billList.size());
        HashSet<Long> noWarningRowIds = new HashSet<Long>(billList.size());
        for (DynamicObject dynamicObject : billList) {
            Collection<DynamicObject> pandaList;
            ArrayList<PandaCheckResult> arrayList = new ArrayList<PandaCheckResult>(10);
            String billNo = dynamicObject.getString("billno");
            noWarningRowIds.add(dynamicObject.getLong("id"));
            if (EmptyUtil.isEmpty(billNo)) {
                billNo = "0";
            }
            if (CollectionUtils.isEmpty(pandaList = this.loadPandaMenuByEntity(this.billFormId, this.getBillMainOrgId(dynamicObject)))) continue;
            List<Object> pandaIds = pandaList.stream().map(t -> t.get("id")).collect(Collectors.toList());
            Map<String, List<DynamicObject>> schemaMap = this.loadPandaSchemaByEntity(this.billFormId, pandaIds);
            for (DynamicObject panda : pandaList) {
                this.match(operateKey, dynamicObject, dynamicObject, panda, schemaMap.get(panda.getString("number")), arrayList);
            }
            if (!CollectionUtils.isNotEmpty(arrayList)) continue;
            Collections.sort(arrayList);
            PandaCheckResult result = (PandaCheckResult)arrayList.get(0);
            logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u6267\u884c\u65b9\u6848\u3010{}\u3011", new Object[]{billNo, result.getPandaNumber(), result.getSchemaName()});
            if (result.getControl() == null || !result.getControl().booleanValue()) continue;
            warningMap.put(billNo, result);
            noWarningRowIds.remove(dynamicObject.getLong("id"));
        }
        this.getView().getPageCache().put("noWarningRowIds", SerializationUtils.toJsonString(noWarningRowIds));
        if (!warningMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : warningMap.entrySet()) {
                String warningMsg = ((PandaCheckResult)entry.getValue()).getWarningMsg();
                if (EmptyUtil.isEmpty(warningMsg)) {
                    warningMsg = ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5df2\u88ab\u9ed1\u767d\u540d\u5355\u7ba1\u63a7\u65b9\u6848\u9884\u8b66\uff08\u9ed1\u767d\u540d\u5355\u7f16\u7801\uff1a%s\uff09\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u64cd\u4f5c\u5417\uff1f", (String)"PandaWarningControlPlugin_1", (String)"bos-ext-tmc", (Object[])new Object[]{((PandaCheckResult)entry.getValue()).getPandaNumber()});
                }
                if (billList.size() > 1) {
                    sb.append((String)entry.getKey());
                    sb.append(": ");
                    sb.append(warningMsg);
                    sb.append(" \n");
                    continue;
                }
                sb.append(warningMsg);
            }
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>(2);
            hashMap.put(6, ResManager.loadKDString((String)"\u7ee7\u7eed", (String)"PandaWarningControlPlugin_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
            if (billList.size() > 1) {
                String string = ResManager.loadKDString((String)"\u5171%1$s\u6761\u8bb0\u5f55\uff0c\u5f85\u786e\u8ba4%2$s\u6761", (String)"PandaWarningControlPlugin_3", (String)"bos-ext-tmc", (Object[])new Object[]{billList.size(), warningMap.size()});
                this.getView().showConfirm(string, sb.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(PANDA_WARNING_CALLBACK, (IFormPlugin)this), hashMap);
            } else {
                this.getView().showConfirm(sb.toString(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(PANDA_WARNING_CALLBACK, (IFormPlugin)this), hashMap);
            }
            option.setVariableValue(PANDA_CHECK_KEY, "false");
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (PANDA_WARNING_CALLBACK.equals(messageBoxClosedEvent.getCallBackId())) {
            String opKey = this.getView().getPageCache().get("opKey");
            if (EmptyUtil.isEmpty(opKey)) {
                logger.warn("pandaWarning opKey is empty");
                return;
            }
            OperateOption option = OperateOption.create();
            Map variables = (Map)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get("opVariables"), Map.class);
            for (Map.Entry opVariable : variables.entrySet()) {
                option.setVariableValue((String)opVariable.getKey(), (String)opVariable.getValue());
            }
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                option.setVariableValue(PANDA_CHECK_KEY, "true");
                this.getView().invokeOperation(opKey, option);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult()) && this.getView() instanceof IListView) {
                Set noWarningRowIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get("noWarningRowIds"), Set.class);
                if (noWarningRowIds == null || noWarningRowIds.isEmpty()) {
                    return;
                }
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                selectedRows = selectedRows.stream().filter(row -> noWarningRowIds.contains(row.getPrimaryKeyValue())).collect(Collectors.toCollection(ListSelectedRowCollection::new));
                option.setVariableValue("selectedRows", SerializationUtils.toJsonString((Object)selectedRows));
                option.setVariableValue(PANDA_CHECK_KEY, "true");
                this.getView().invokeOperation(opKey, option);
                this.getView().getPageCache().remove("noWarningRowIds");
            }
            this.getView().getPageCache().remove("opKey");
        }
    }

    private Long getBillMainOrgId(DynamicObject bill) {
        String mainOrg = ((MainEntityType)bill.getDataEntityType()).getMainOrg();
        if (StringUtils.isBlank((CharSequence)mainOrg) || Objects.isNull(bill.getDataEntityType()) || Objects.isNull(bill.getDataEntityType().getProperties())) {
            return 0L;
        }
        if (bill.getDataEntityType().getProperties().containsKey((Object)mainOrg) && Objects.nonNull(bill.getDynamicObject(mainOrg))) {
            return (Long)bill.getDynamicObject(mainOrg).getPkValue();
        }
        return 0L;
    }

    private Collection<DynamicObject> loadPandaMenuByEntity(String entityType, Long orgId) {
        logger.info("\u52a0\u8f7d\u5355\u636e\u7c7b\u578b\u3010{}\u3011\uff0c\u521b\u5efa\u7ec4\u7ec7\u3010{}\u3011", (Object)entityType, (Object)orgId);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)PANDA_MENU, (Long)orgId);
        if (Objects.nonNull(baseDataFilter)) {
            filter.and(baseDataFilter);
        }
        filter.and("schemeentry.bizbill", "=", (Object)entityType);
        String selectProp = "id,number,menuprop,biztype,createorg,menuentry,menuentry.menuno,menuname,menucusname";
        Map setBills = BusinessDataServiceHelper.loadFromCache((String)PANDA_MENU, (String)selectProp, (QFilter[])filter.toArray());
        if (Objects.isNull(setBills)) {
            return Collections.emptyList();
        }
        return setBills.values();
    }

    private Map<String, List<DynamicObject>> loadPandaSchemaByEntity(String entityType, List<Object> pandaIds) {
        String selectProp = "number,schemeentry,schemename,bizbill,billcheck,billmatchidfield,billmatchfield,matchway,menumatchfield,billconditionval_tag,scheme,billnotifyfield,matchtip,warningmsg";
        QFilter filter = new QFilter("id", "in", pandaIds);
        Map setBills = BusinessDataServiceHelper.loadFromCache((String)PANDA_MENU, (String)selectProp, (QFilter[])filter.toArray());
        if (Objects.isNull(setBills)) {
            return Collections.emptyMap();
        }
        return setBills.values().stream().collect(Collectors.toMap(t -> t.getString("number"), t -> t.getDynamicObjectCollection("schemeentry").stream().filter(w -> entityType.equals(w.getString("bizbill.number"))).collect(Collectors.toList())));
    }

    private void match(String operateKey, DynamicObject bill, DynamicObject cache, DynamicObject pandaList, List<DynamicObject> schemeList, List<PandaCheckResult> results) {
        Boolean isWhiteList = "W".equals(pandaList.getString("menuprop"));
        DynamicObjectCollection menuList = pandaList.getDynamicObjectCollection("menuentry");
        Integer orgMatch = this.getOrgMatch(cache, pandaList);
        String billNo = bill.getString("billno");
        String pandaNo = pandaList.getString("number");
        String opCheck = "," + operateKey + ",";
        for (DynamicObject schema : schemeList) {
            String schemaName = schema.getString("schemename");
            String billcheck = schema.getString("billcheck");
            if (!billcheck.contains(opCheck)) {
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u64cd\u4f5c\u8fc7\u6ee4", new Object[]{billNo, pandaNo, schemaName});
                continue;
            }
            if (!this.isFilterBill(schema.getString("billconditionval_tag"), bill, cache)) {
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u6761\u4ef6\u8fc7\u6ee4", new Object[]{billNo, pandaNo, schemaName});
                continue;
            }
            PandaCheckResult result = new PandaCheckResult(isWhiteList, orgMatch);
            String fieldKey = schema.getString("billmatchfield");
            String billField = this.getBillDynamicSafeString(this.getBillDynamicObject(bill, cache, fieldKey), fieldKey);
            this.processCheckResult(result, billField, schema, (List<DynamicObject>)menuList);
            if (result.getMatchType() >= 0) {
                result.setPandaNumber(pandaList.getString("number"));
                result.setSchemaName(schemaName);
                result.setBillMatchIdField(schema.getString("billmatchidfield"));
                result.setBillNotifyField(schema.getString("billnotifyfield"));
                result.setMatchTip(schema.getString("matchtip"));
                result.setWarningMsg(schema.getString("warningmsg"));
                logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u6210\u529f\u5339\u914d", new Object[]{billNo, pandaNo, schemaName});
                results.add(result);
                continue;
            }
            logger.info("\u5355\u636e\u3010{}\u3011\u5339\u914d\u540d\u5355\u3010{}\u3011\u65b9\u6848\u3010{}\u3011\u5b57\u6bb5\u8fc7\u6ee4", new Object[]{billNo, pandaNo, schemaName});
        }
    }

    private DynamicObject getBillDynamicObject(DynamicObject bill, DynamicObject cache, String key) {
        int idx = key.indexOf(DOT);
        key = idx > 0 ? key.substring(0, idx) : key;
        return bill.getDataEntityType().getProperties().containsKey((Object)key) ? bill : cache;
    }

    private void processCheckResult(PandaCheckResult result, String billField, DynamicObject schema, List<DynamicObject> menuList) {
        String controlScheme = schema.getString("scheme");
        if (result.getWhiteList().booleanValue()) {
            this.setWhiteMatchScore(billField, schema, menuList, result);
            Boolean match = result.getMatch();
            boolean isWarning = "M".equals(controlScheme) && match == false;
            result.setControl(isWarning);
        } else {
            int matchScore = this.getMatchBillList(billField, schema, menuList);
            result.setMatchType(matchScore);
            if (matchScore >= 0) {
                result.setMatchType(matchScore);
                result.setControl("W".equals(controlScheme));
            }
        }
    }

    private void setWhiteMatchScore(String billField, DynamicObject schema, List<DynamicObject> menuList, PandaCheckResult result) {
        boolean isMatch;
        String matchWay = schema.getString("matchWay");
        String menuField = schema.getString("menumatchfield");
        int wayScore = "E".equals(matchWay) ? 0 : 3;
        int menuScore = this.getMenuScore(menuField);
        if (StringUtils.isBlank((CharSequence)billField)) {
            isMatch = false;
        } else {
            List menuValList = menuList.stream().map(t -> t.getString(menuField)).filter(StringUtils::isNotBlank).flatMap(t -> {
                if ("menucusname".equals(menuField)) {
                    return Arrays.stream(StringUtils.split((String)t.replaceAll("\uff1b", ";"), (String)";"));
                }
                return Stream.of(t);
            }).collect(Collectors.toList());
            isMatch = "E".equals(matchWay) ? menuValList.contains(billField) : menuValList.stream().anyMatch(billField::contains);
        }
        result.setMatchType(wayScore + menuScore);
        result.setMatch(isMatch);
    }

    private int getMatchBillList(String billField, DynamicObject schema, List<DynamicObject> menuList) {
        if (StringUtils.isBlank((CharSequence)billField)) {
            return -1;
        }
        String matchWay = schema.getString("matchWay");
        String menuField = schema.getString("menumatchfield");
        int menuScore = this.getMenuScore(menuField);
        List menuValList = menuList.stream().map(t -> t.getString(menuField)).filter(StringUtils::isNotBlank).flatMap(t -> {
            if ("menucusname".equals(menuField)) {
                return Arrays.stream(StringUtils.split((String)t.replaceAll("\uff1b", ";"), (String)";"));
            }
            return Stream.of(t);
        }).collect(Collectors.toList());
        if ("E".equals(matchWay)) {
            if (menuValList.contains(billField)) {
                return menuScore;
            }
        } else if ("M".equals(matchWay)) {
            for (String menuVal : menuValList) {
                if (!billField.contains(menuVal)) continue;
                return 3 + menuScore;
            }
        }
        return -1;
    }

    private int getMenuScore(String menuVal) {
        switch (menuVal) {
            case "menuno": {
                return 0;
            }
            case "menuname": {
                return 1;
            }
        }
        return 2;
    }

    private Integer getOrgMatch(DynamicObject bill, DynamicObject pandaList) {
        Object orgVal;
        String createOrg = pandaList.getDynamicObject("createorg").getString("number");
        String mainOrg = ((MainEntityType)bill.getDataEntityType()).getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrg) && Objects.nonNull(orgVal = this.getBillDynamicValSafe(bill, mainOrg))) {
            DynamicObject org = (DynamicObject)orgVal;
            String billOrg = org.getString("number");
            return createOrg.equals(billOrg) ? 0 : 1;
        }
        return 1;
    }

    private Object getBillDynamicValSafe(DynamicObject object, String key) {
        try {
            return object.get(key);
        }
        catch (Exception e) {
            logger.info("\u5355\u636e\u3010{}\u3011\u83b7\u53d6\u503c\u3010{}\u3011\u5931\u8d25", object.get("billno"), (Object)key);
            return null;
        }
    }

    private String getBillDynamicSafeString(DynamicObject object, String key) {
        try {
            int idx;
            String entity;
            Object enObj;
            if (key.contains(DOT) && (enObj = object.get(entity = key.substring(0, idx = key.indexOf(DOT)))) instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection mulBase = (MulBasedataDynamicObjectCollection)enObj;
                ArrayList<String> multiList = new ArrayList<String>(mulBase.size());
                for (DynamicObject dynamicObject : mulBase) {
                    DynamicObject typeObj = (DynamicObject)dynamicObject.get("fbasedataid");
                    if (typeObj == null) continue;
                    multiList.add(this.getBillDynamicSafeString(typeObj, key.substring(idx + 1)));
                }
                return StringUtils.join(multiList, (String)";");
            }
            return object.getString(key);
        }
        catch (Exception e) {
            logger.info("\u5355\u636e\u3010{}\u3011\u83b7\u53d6\u503c\u3010{}\u3011\u5931\u8d25", object.get("billno"), (Object)key);
            return null;
        }
    }

    private boolean isFilterBill(String filterStr, DynamicObject bill, DynamicObject cache) {
        if (StringUtils.isBlank((CharSequence)filterStr)) {
            return true;
        }
        CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        ConditionFactory conditionFactory = new ConditionFactory();
        conditionFactory.init(targetCondition, this.billFormId);
        DynamicObject obj = this.convertToPlainObject(bill, cache, this.getAllFields(targetCondition));
        return conditionFactory.isMatchCondition(obj);
    }

    private List<String> getAllFields(CRCondition targetCondition) {
        Set fields = Optional.ofNullable(targetCondition.getFilterCondition().getFilterRow()).orElse(Collections.emptyList()).stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
        fields.add("id");
        return new ArrayList<String>(fields);
    }

    private DynamicObject convertToPlainObject(DynamicObject bill, DynamicObject cache, List<String> fields) {
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicObject obj = new DynamicObject(dt, true);
        obj.beginInit();
        for (String field : fields) {
            DynamicObject object = this.getBillDynamicObject(bill, cache, field);
            Class<?> propertyType = this.getPropertyType(field, object);
            DynamicSimpleProperty property = new DynamicSimpleProperty(field, propertyType, null);
            dt.registerSimpleProperty(property);
            Object val = ILocaleString.class.equals((Object)property.getPropertyType()) ? object.getString(field) : object.get(field);
            property.setValueFast((Object)obj, val);
        }
        obj.endInit();
        return obj;
    }

    private Class<?> getPropertyType(String field, DynamicObject bill) {
        int idx = field.indexOf(DOT);
        if (idx < 0) {
            return ((IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)field)).getPropertyType();
        }
        return this.getPropertyType(field.substring(idx + 1), bill.getDynamicObject(field.substring(0, idx)));
    }
}

