/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.task.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.enums.TaskExecuteStatusEnum;
import kd.bos.ext.tmc.task.thread.TaskService;
import kd.bos.ext.tmc.utils.helper.DivideGroupHelper;
import kd.bos.ext.tmc.utils.helper.TaskFlowHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TaskExecutor {
    private static final Log logger = LogFactory.getLog(TaskExecutor.class);
    private static final int minDealSize = 20;
    private static final int maxThreadSize = 10;

    public Map<String, Object> execute(DynamicObject task, Object[] allBizBills, int index, long sumLogID, DynamicObject taskFlow) {
        ArrayList<Object> ids = new ArrayList<Object>(20);
        String entityNumber = task.getDynamicObject("mainentity").getString("number");
        Pair operate = Pair.of((Object)task.getString("operatekey"), (Object)task.getString("operatename"));
        String mserviceconfig = task.getString("mserviceconfig_tag");
        boolean isCycle = task.getBoolean("iscycle");
        List<Object> allbillIds = Arrays.stream(allBizBills).collect(Collectors.toList());
        DivideGroupHelper batch = new DivideGroupHelper(allbillIds, 20, 10);
        List bizBillList = batch.getResult();
        String tenantId = RequestContext.get().getTenantId();
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)(TaskExecutor.class.getName() + tenantId + taskFlow.getString("number")), (int)bizBillList.size());
        logger.info("\u7ebf\u7a0b\u6570\uff1a" + bizBillList.size());
        ArrayList<Future> futureList = new ArrayList<Future>(10);
        for (int i = 0; i < bizBillList.size(); ++i) {
            List bizBills = bizBillList.get(i);
            Future future = pool.submit((Callable)new TaskService(entityNumber, (String)operate.getLeft(), mserviceconfig, bizBills.toArray(), i, isCycle));
            futureList.add(future);
        }
        boolean isRevoperate = taskFlow.getBoolean("isrevoperate");
        logger.info("\u662f\u5426\u53cd\u5411\uff1a" + isRevoperate);
        Map<String, Object> resultMap = isRevoperate ? this.executeRevoperateTask(allbillIds, futureList, index, sumLogID, taskFlow, entityNumber, (Pair<String, String>)operate) : this.executeOperateTask(ids, allbillIds, futureList, index, sumLogID, taskFlow, entityNumber, (Pair<String, String>)operate);
        resultMap.put("successid" + index, ids);
        pool.close();
        return resultMap;
    }

    private Map<String, Object> executeOperateTask(List<Object> ids, List<Object> allbillIds, List<Future> futureList, int index, long sumLogID, DynamicObject taskFlow, String entityNumber, Pair<String, String> operate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        StringBuilder errs = new StringBuilder();
        ArrayList<Map<String, Object>> taskLogList = new ArrayList<Map<String, Object>>(allbillIds.size());
        for (Future future : futureList) {
            try {
                OperationResult result = (OperationResult)future.get();
                List successIds = result.getSuccessPkIds();
                this.cacheExecResult(resultMap, result, index);
                Map billnoMap = result.getBillNos();
                long startTime = result.getStartTime() != null ? result.getStartTime().getTime() : 0L;
                long endTime = result.getFinishedTime() != null ? result.getFinishedTime().getTime() : 0L;
                long costTime = endTime - startTime;
                for (Map.Entry billno : billnoMap.entrySet()) {
                    Map<String, Object> taskLog = TaskFlowHelper.createDetailTaskLog(startTime, costTime, entityNumber, operate, sumLogID, taskFlow);
                    Long id = Long.valueOf((String)billno.getKey());
                    taskLog.put("BizBillId", id);
                    taskLog.put("BizBillno", billno.getValue());
                    if (result.isSuccess() || successIds.toString().contains(id.toString())) {
                        ids.add(id);
                        taskLog.put("Result", TaskExecuteStatusEnum.SUCCESS.getValue());
                    } else {
                        taskLog.put("Result", TaskExecuteStatusEnum.FAIL.getValue());
                        resultMap.put("taskresult", TaskExecuteStatusEnum.FAIL.getValue());
                    }
                    taskLog.put("Exception", TaskFlowHelper.getErrorMsgByBill(result, id));
                    taskLogList.add(taskLog);
                }
            }
            catch (Exception e) {
                errs.append(e.getMessage());
                errs.append("\n");
                resultMap.put("exception" + index, errs.toString());
                resultMap.put("result" + index, TaskExecuteStatusEnum.FAIL.getValue());
                resultMap.put("taskresult", TaskExecuteStatusEnum.FAIL.getValue());
                logger.error("TaskExecutor\u6267\u884c" + entityNumber + (String)operate.getLeft() + "\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            }
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveDetailLogs", (Object[])new Object[]{taskLogList});
        return resultMap;
    }

    private Map<String, Object> executeRevoperateTask(List<Object> allbillIds, List<Future> futureList, int index, long sumLogID, DynamicObject taskFlow, String entityNumber, Pair<String, String> operate) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        StringBuilder errs = new StringBuilder();
        ArrayList<Map<String, Object>> taskLogList = new ArrayList<Map<String, Object>>(allbillIds.size());
        HashMap<Long, String> errorBillnoMap = new HashMap<Long, String>(16);
        ArrayList successIds = new ArrayList(allbillIds.size());
        HashMap errorInfo = new HashMap(16);
        HashMap<String, Pair> costTimeMap = new HashMap<String, Pair>(16);
        for (Future future : futureList) {
            try {
                OperationResult result = (OperationResult)future.get();
                List successPkIds = result.getSuccessPkIds();
                logger.info("\u6210\u529f\u5355\u636e\uff1a" + successPkIds.toString());
                successIds.addAll(successPkIds);
                resultMap.put("result" + index, TaskExecuteStatusEnum.SUCCESS.getValue());
                if (resultMap.containsKey("sucesscount" + index)) {
                    int count = (Integer)resultMap.get("sucesscount" + index);
                    resultMap.put("sucesscount" + index, count + result.getSuccessPkIds().size());
                } else {
                    resultMap.put("sucesscount" + index, result.getSuccessPkIds().size());
                }
                Map billnoMap = result.getBillNos();
                List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                allErrorOrValidateInfo.forEach(info -> errorInfo.put(info.getPkValue() + "_" + index, Pair.of((Object)index, (Object)info.getMessage())));
                long startTime = result.getStartTime() != null ? result.getStartTime().getTime() : 0L;
                long endTime = result.getFinishedTime() != null ? result.getFinishedTime().getTime() : 0L;
                long costTime = endTime - startTime;
                for (Map.Entry bill : billnoMap.entrySet()) {
                    Long billId = Long.parseLong(bill.getKey().toString());
                    String billno = (String)bill.getValue();
                    if (result.isSuccess() || ((Object)successIds).toString().contains(billId.toString())) {
                        Map<String, Object> taskLog = TaskFlowHelper.createDetailTaskLog(startTime, costTime, entityNumber, operate, sumLogID, taskFlow);
                        taskLog.put("BizBillId", billId);
                        taskLog.put("BizBillno", billno);
                        taskLog.put("Result", TaskExecuteStatusEnum.SUCCESS.getValue());
                        taskLogList.add(taskLog);
                        continue;
                    }
                    errorBillnoMap.put(billId, billno);
                    costTimeMap.put(billId + "_" + index, Pair.of((Object)startTime, (Object)costTime));
                }
            }
            catch (Exception e) {
                errs.append(e.getMessage());
                errs.append("\n");
                resultMap.put("exception" + index, errs.toString());
                resultMap.put("result" + index, TaskExecuteStatusEnum.FAIL.getValue());
                logger.error("TaskExecutor\u6267\u884c" + entityNumber + (String)operate.getLeft() + "\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            }
        }
        resultMap.put("errorBillnoMap", errorBillnoMap);
        resultMap.put("successIds", successIds);
        resultMap.put("errorInfo", errorInfo);
        resultMap.put("costTimeMap", costTimeMap);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fcs", (String)"taskFlowLogService", (String)"createAndSaveDetailLogs", (Object[])new Object[]{taskLogList});
        return resultMap;
    }

    private void cacheExecResult(Map<String, Object> resultMap, OperationResult result, int index) {
        if (result != null) {
            if (result.isSuccess()) {
                resultMap.put("result" + index, TaskExecuteStatusEnum.SUCCESS.getValue());
            } else {
                resultMap.put("result" + index, TaskExecuteStatusEnum.FAIL.getValue());
                if (resultMap.containsKey("sucesscount" + index)) {
                    String exception = (String)resultMap.get("exception" + index);
                    String errs = TaskFlowHelper.decodeErrorMsg(result);
                    exception = StringUtils.isNotBlank((CharSequence)exception) ? errs : exception + "\n" + errs;
                    resultMap.put("exception" + index, exception);
                } else {
                    resultMap.put("exception" + index, TaskFlowHelper.decodeErrorMsg(result));
                }
            }
            if (resultMap.containsKey("sucesscount" + index)) {
                int count = (Integer)resultMap.get("sucesscount" + index);
                resultMap.put("sucesscount" + index, count + result.getSuccessPkIds().size());
            } else {
                resultMap.put("sucesscount" + index, result.getSuccessPkIds().size());
            }
        }
    }
}

