/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class RiskTradeWarnHelper {
    public static String getWarnMessageInfo(Set<Long> billIds) {
        DynamicObjectCollection bills = RiskTradeWarnHelper.getErrorBill(billIds, "warn");
        if (EmptyUtil.isNoEmpty(bills)) {
            StringBuilder sb = new StringBuilder();
            Map group = bills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
            for (Map.Entry bill : group.entrySet()) {
                RiskTradeWarnHelper.dealStringBuilderInfo(sb, bill.getValue());
                sb.append(ResManager.loadKDString((String)"\uff0c\u8bf7\u67e5\u770b\u5927\u6570\u636e\u5206\u6790\u8be6\u60c5\u3002", (String)"RiskTradeWarnHelper_3", (String)"bos-ext-tmc", (Object[])new Object[0]));
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public static DynamicObject getErrorBill(Long billId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)billId);
        return QueryServiceHelper.queryOne((String)"fcs_errordata", (String)"id", (QFilter[])qFilter.toArray());
    }

    private static DynamicObjectCollection getErrorBill(Set<Long> billIds, String ctrlType) {
        QFilter qFilter = new QFilter("billid", "in", billIds);
        qFilter.and("entry.subentry.controlmodel", "=", (Object)ctrlType);
        return QueryServiceHelper.query((String)"fcs_errordata", (String)"billid,billno,entry.typename as typename,entry.subentry.controlmodel", (QFilter[])qFilter.toArray());
    }

    private static void dealStringBuilderInfo(StringBuilder sb, List<DynamicObject> bills) {
        String billno = bills.get(0).getString("billno");
        sb.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u3010%s\u3011\u7591\u4f3c\u5b58\u5728", (String)"RiskTradeWarnHelper_0", (String)"bos-ext-tmc", (Object[])new Object[]{billno}));
        List typeNameList = bills.stream().map(s -> s.getString("typename")).distinct().collect(Collectors.toList());
        for (int i = 0; i < typeNameList.size(); ++i) {
            String typeName = (String)typeNameList.get(i);
            sb.append(typeName);
            if (i == typeNameList.size() - 1) continue;
            sb.append("\u3001");
        }
    }

    public static Map<Long, String> getErrorMessageInfo(Set<Long> idSet) {
        HashMap<Long, String> returnMap = new HashMap<Long, String>();
        DynamicObjectCollection bills = RiskTradeWarnHelper.getErrorBill(idSet, "errorcontrol");
        if (EmptyUtil.isNoEmpty(bills)) {
            Map group = bills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.mapping(o -> o, Collectors.toList())));
            for (Map.Entry bill : group.entrySet()) {
                StringBuilder sb = new StringBuilder();
                RiskTradeWarnHelper.dealStringBuilderInfo(sb, bill.getValue());
                sb.append(ResManager.loadKDString((String)"\uff0c\u7981\u6b62\u4e1a\u52a1\u6d41\u8f6c\uff0c\u8bf7\u67e5\u770b\u5927\u6570\u636e\u5206\u6790\u8be6\u60c5\u3002", (String)"RiskTradeWarnHelper_1", (String)"bos-ext-tmc", (Object[])new Object[0]));
                returnMap.put(bill.getKey(), sb.toString());
            }
        }
        return returnMap;
    }

    public static DynamicObject getRiskTradeWarnByEntityName(String entityName) {
        QFilter qFilter = new QFilter("billentity.number", "=", (Object)entityName);
        qFilter.and("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingleFromCache((String)"fcs_risktrade_warn", (String)"warnop,riskscreening", (QFilter[])qFilter.toArray());
    }
}

