/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SuspectRepeatHelper {
    public static String getMessageInfo(Set<Long> billid, List<String> ctrltypeList) {
        DynamicObjectCollection bills = SuspectRepeatHelper.getSuspectBill(billid, ctrltypeList, true);
        if (EmptyUtil.isNoEmpty(bills)) {
            StringBuilder sb = new StringBuilder();
            Map group = bills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
            for (Map.Entry bill : group.entrySet()) {
                SuspectRepeatHelper.dealStringBuilderInfo(sb, bill.getValue());
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public static Map<Object, Object> getControlMessageInfo(Set<Long> idSet) {
        HashMap<Object, Object> returnMap = new HashMap<Object, Object>(16);
        DynamicObjectCollection suspectBills = SuspectRepeatHelper.getSuspectBill(idSet, Collections.singletonList("control"), false);
        Map group = suspectBills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
        if (EmptyUtil.isNoEmpty(suspectBills)) {
            for (Map.Entry suspectBill : group.entrySet()) {
                StringBuilder sb = new StringBuilder();
                SuspectRepeatHelper.dealStringBuilderInfo(sb, suspectBill.getValue());
                sb.append("\n");
                returnMap.put(suspectBill.getKey(), sb.toString());
                List collect = Arrays.stream(((DynamicObject)suspectBill.getValue().get(0)).getString("suspectset.landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList());
                returnMap.put("operateKey", collect);
            }
        }
        return returnMap;
    }

    public static Map<Object, Object> getLandingMessageInfo(Set<Long> idSet) {
        HashMap<Object, Object> returnMap = new HashMap<Object, Object>();
        DynamicObjectCollection suspectBills = SuspectRepeatHelper.getSuspectBill(idSet, Collections.singletonList("landing"), true);
        Map group = suspectBills.stream().collect(Collectors.groupingBy(s -> s.getLong("billid"), Collectors.toList()));
        if (EmptyUtil.isNoEmpty(suspectBills)) {
            for (Map.Entry suspectBill : group.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u6ca1\u7ed1\u5b9a\u63d2\u4ef6\u65f6\u63d0\u793a\uff1a", (String)"SuspectRepeatHelper_4", (String)"bos-ext-tmc", (Object[])new Object[0]));
                SuspectRepeatHelper.dealStringBuilderInfo(sb, suspectBill.getValue());
                sb.append(ResManager.loadKDString((String)"\uff0c\u8bf7\u4eba\u5de5\u5230\u3010\u7591\u4f3c\u91cd\u590d\u786e\u8ba4\u3011\u5217\u8868\u8fdb\u884c\u6279\u91cf\u786e\u8ba4\uff08\u6216\u7ed1\u5b9a\u8868\u5355\u63d2\u4ef6\u8fdb\u884c\u786e\u8ba4\uff09", (String)"SuspectRepeatHelper_5", (String)"bos-ext-tmc", (Object[])new Object[0]));
                returnMap.put(suspectBill.getKey(), sb.toString());
                List collect = Arrays.stream(((DynamicObject)suspectBill.getValue().get(0)).getString("suspectset.landingop").replaceFirst(",", "").split(",")).collect(Collectors.toList());
                returnMap.put("operateKey", collect);
            }
        }
        return returnMap;
    }

    private static DynamicObjectCollection getSuspectBill(Set<Long> billid, List<String> ctrltypeList, Boolean addConfirm) {
        QFilter qFilter = new QFilter("billid", "in", billid);
        if (addConfirm.booleanValue()) {
            qFilter.and("confirm", "=", (Object)false);
        }
        qFilter.and("ctrltype", "in", ctrltypeList);
        return QueryServiceHelper.query((String)"fcs_suspectbill", (String)"id,billid,billno,suspectentry,suspectentry.suspectbillentity.name,suspectentry.suspectbillno,suspectset,suspectset.landingop", (QFilter[])qFilter.toArray());
    }

    private static void dealStringBuilderInfo(StringBuilder sb, List<DynamicObject> bill) {
        String billno = bill.get(0).getString("billno");
        sb.append(ResManager.loadKDString((String)"\u5b58\u5728\u7591\u4f3c\u91cd\u590d\uff1a", (String)"SuspectRepeatHelper_3", (String)"bos-ext-tmc", (Object[])new Object[0]));
        sb.append("\u3010");
        sb.append(billno);
        sb.append("\u3011 ");
        sb.append(ResManager.loadKDString((String)"\u4e0e", (String)"SuspectRepeatHelper_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
        Map<String, List<DynamicObject>> suspectentrys = bill.stream().collect(Collectors.groupingBy(b -> b.getString("suspectentry.suspectbillentity.name")));
        int size = suspectentrys.size();
        for (Map.Entry<String, List<DynamicObject>> entry : suspectentrys.entrySet()) {
            String suspectBillEntityName = entry.getKey();
            sb.append(suspectBillEntityName);
            sb.append("\uff08");
            List suspectBillnos = entry.getValue().stream().map(s -> s.getString("suspectentry.suspectbillno")).distinct().collect(Collectors.toList());
            for (int i = 0; i < suspectBillnos.size(); ++i) {
                sb.append((String)suspectBillnos.get(i));
                if (i == suspectBillnos.size() - 1) continue;
                sb.append(",");
            }
            sb.append("\uff09");
            if (size <= 1) continue;
            sb.append("\uff0c");
            sb.append(ResManager.loadKDString((String)"\u4e0e", (String)"SuspectRepeatHelper_2", (String)"bos-ext-tmc", (Object[])new Object[0]));
            --size;
        }
    }
}

