/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TaskFlowHelper {
    public static Map<String, Object> createDetailTaskLog(long startTime, long costTime, String entityNumber, Pair<String, String> operate, long sumLogId, DynamicObject taskFlow) {
        HashMap<String, Object> taskLog = new HashMap<String, Object>(16);
        taskLog.put("LogType", "taskexecute");
        taskLog.put("Time", startTime);
        taskLog.put("TaskNumber", taskFlow.getString("number"));
        taskLog.put("CostTime", costTime);
        taskLog.put("TraceId", String.valueOf(RequestContext.get().getTraceId()));
        taskLog.put("Operatekey", operate.getLeft());
        taskLog.put("OperateName", operate.getRight());
        taskLog.put("MainEntity", entityNumber);
        taskLog.put("SumLogId", sumLogId);
        taskLog.put("SumLog", false);
        DynamicObject receiver = taskFlow.getDynamicObject("exceptionreceiver");
        taskLog.put("ExceptionReceiver", receiver != null ? receiver.getLong("id") : 0L);
        return taskLog;
    }

    public static String decodeErrorMsg(OperationResult operationResult) {
        String errMsg;
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            errMsg = TaskFlowHelper.decodeMultiErrorMsg(operationResult);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            errMsg = errorInfo.getMessage();
        } else {
            errMsg = operationResult.getMessage();
        }
        return errMsg;
    }

    public static String decodeMultiErrorMsg(OperationResult operationResult) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        Map billNos = operationResult.getBillNos();
        StringBuilder buf = new StringBuilder();
        int len = errorInfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            String billno = (String)billNos.get(((IOperateInfo)errorInfos.get(i)).getPkValue().toString());
            String message = ((IOperateInfo)errorInfos.get(i)).getMessage();
            if (message.contains(billno)) {
                buf.append(message).append('\n');
                continue;
            }
            buf.append(billno).append(":").append(message).append('\n');
        }
        return buf.toString();
    }

    public static String getErrorMsgByBill(OperationResult operationResult, Long billId) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        List Infos = errorInfos.stream().filter(i -> i.getPkValue().equals(billId)).collect(Collectors.toList());
        StringBuilder buf = new StringBuilder();
        for (IOperateInfo info : Infos) {
            buf.append(info.getMessage()).append('\n');
        }
        return buf.toString();
    }

    public static Long[] getTargetBillIds(String currEntity, Object currEntityId, String targetEntity) {
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        HashSet destIds = (HashSet)botpMap.get(targetEntity);
        if (destIds == null) {
            return null;
        }
        return destIds.toArray(new Long[0]);
    }

    public static Long[] getSrcBillIds(String currEntity, Object currEntityId, String srcEntity) {
        Map botpMap = BFTrackerServiceHelper.findSourceBills((String)currEntity, (Long[])new Long[]{(Long)currEntityId});
        HashSet srcIds = (HashSet)botpMap.get(srcEntity);
        if (srcIds == null) {
            return null;
        }
        return srcIds.toArray(new Long[0]);
    }

    public static Set<Long> getFitBillIds(DynamicObject taskFlow, String entity, List<Long> billIds) {
        Set<Long> fitTargetIds;
        String filterRecord = taskFlow.getString("bizfilterconfig_tag");
        if (StringUtils.isNotBlank((CharSequence)filterRecord)) {
            CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterRecord, CRCondition.class);
            ConditionFactory factory = new ConditionFactory();
            factory.init(targetCondition, entity);
            fitTargetIds = factory.runCondition(new HashSet<Long>(billIds));
        } else {
            fitTargetIds = new HashSet<Long>(billIds);
        }
        DynamicObjectCollection orgEntry = taskFlow.getDynamicObjectCollection("orgentry");
        if (EmptyUtil.isNoEmpty(orgEntry)) {
            String mainOrg = EntityMetadataCache.getDataEntityType((String)entity).getMainOrg();
            List orgList = orgEntry.stream().map(r -> r.getDynamicObject("org").getPkValue()).collect(Collectors.toList());
            QFilter qFilter = new QFilter(mainOrg, "in", orgList).and("id", "in", fitTargetIds);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])qFilter.toArray());
            return bills.stream().map(b -> b.getLong("id")).collect(Collectors.toSet());
        }
        return fitTargetIds;
    }
}

