/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.portal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.AICommandParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.CollectAppAndMenuUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;

public class OpenOnTabPageUtils {
    public static final String OPEN_PAGE_UTILS_2 = "OpenPageUtils_2";
    public static final String TABAP = "tabap";
    public static final String FILTER_SCHEME_ID = "filterSchemeId";
    public static final String HOMEPAGE_TABAP_COUNT = "homepage_tabap_count";
    public static final String APPNAME = "appname";
    public static final String APPMAINNUMBER = "appmainnumber";
    public static final String BOS_PORTAL_PLUGIN = "bos-portal-plugin";
    public static final String FORMNUMBER = "formnumber";
    public static final String PARAMETER = "parameter";
    public static final String WFTASK = "wftask";
    public static final String PARAMETERTYPE = "parametertype";
    private static final String FORM_MSG = "\u6ca1\u6709\u5bf9\u5e94\u7684\u8868\u5355\u9875\u9762";
    public static final String OPEN_PAGE_UTILS_5 = "OpenPageUtils_5";
    public static final String APPID = "appid";
    public static final String YYY_MM_DD_HH_MM_SS = "yyy-MM-dd hh:mm:ss";
    public static final String TIME = "---time:";
    public static final String MESSAGE_ID = "messageId";
    public static final String TAB_TYPE = "tabType";
    public static final String OPEN_PAGE = "openPage";
    public static final String BILL_FORM_ID = "billFormId";
    private static Log logger = LogFactory.getLog(OpenOnTabPageUtils.class);
    private static final String CUSTOMPARAMETERS = "customparameters";
    private static final String QING_ANALYSIS_MAP = "qinganalysis_parammap";
    private static final String ENTITY_ADMINSCHEME = "perm_adminscheme";
    private static final String PROP_ISALLOWBIZOPERATE = "isallowbizoperate";

    public static boolean isAllowAdminBizOperate() {
        boolean result = false;
        DynamicObject enableScheme = BusinessDataServiceHelper.loadSingle((String)ENTITY_ADMINSCHEME, (String)PROP_ISALLOWBIZOPERATE, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        if (enableScheme != null) {
            result = enableScheme.getBoolean(PROP_ISALLOWBIZOPERATE);
        }
        return result;
    }

    public static void openApp(String appId, String menuId, Map<String, Object> map, IFormView myappView) {
        OpenOnTabPageUtils.openApp(appId, menuId, map, myappView, "");
    }

    public static void openApp(String appId, String menuId, Map<String, Object> map, IFormView myappView, String selfAppName) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null || myappView == null) {
            logger.error("OpenPageUtils----openApp----appId or view in map is null");
            return;
        }
        String appMainNumber = app.getHomeNum();
        IFormView mainPageView = myappView.getMainView();
        if (mainPageView == null) {
            logger.error("OpenPageUtils----openApp----mainPageID or mainPageView is null");
            return;
        }
        String mainPageId = mainPageView.getPageId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        String appName = "";
        appName = StringUtils.isNotBlank((CharSequence)selfAppName) ? selfAppName : app.getName().getLocaleValue();
        if (StringUtils.isBlank((CharSequence)appName)) {
            appName = app.getNumber();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
            map.put("view", myappView);
            map.put(APPNAME, appName);
            map.put(APPMAINNUMBER, appMainNumber);
        }
        if (!OpenOnTabPageUtils.checkAppMenuPermission(appId, menuId, map, isSuperAdmin)) {
            if (StringUtils.isEmpty((CharSequence)menuId)) {
                myappView.showMessage(ResManager.loadKDString((String)"\u65e0", (String)"OpenPageUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) + appName + ResManager.loadKDString((String)"\u7684\u5e94\u7528\u6743\u9650", (String)"OpenPageUtils_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                myappView.showMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650", (String)OPEN_PAGE_UTILS_2, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        boolean isAppHome = false;
        String formNumber = (String)map.get(FORMNUMBER);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            formNumber = appMainNumber;
            isAppHome = true;
        } else if (formNumber.equals(appMainNumber)) {
            isAppHome = true;
        }
        if ("1".equals(app.getOpenType())) {
            if ("devportal".equals(appId)) {
                myappView.openUrl("#/dform?formId=" + formNumber);
            } else {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(formNumber);
                fsp.getOpenStyle().setShowType(ShowType.NewWindow);
                myappView.showForm(fsp);
            }
        } else if ("2".equals(app.getOpenType())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(formNumber);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            myappView.showForm(fsp);
        } else {
            Tab tab = (Tab)mainPageView.getControl(TABAP);
            for (Control ctrl : tab.getItems()) {
                if (!ctrl.getKey().equals(appId)) continue;
                tab.activeTab(appId);
                myappView.sendFormAction(mainPageView);
                return;
            }
            OpenOnTabPageUtils.openAppPage(appId, map);
            String appPageId = appId + mainPageId;
            IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
            if (appPageView != null) {
                OpenOnTabPageUtils.activatePage(appPageId, myappView, map);
                if (menuId != null && appPageView != null && !isAppHome) {
                    String menuPageId;
                    if (appPageView.getPageId().equalsIgnoreCase(myappView.getPageId())) {
                        appPageView = myappView;
                    }
                    String markId = menuId;
                    Map parameter = new HashMap();
                    Object parameterStr = map.get(PARAMETER);
                    if (StringUtils.isNotBlank((Object)parameterStr)) {
                        parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
                        String filterSchemeId = null;
                        if (parameter != null) {
                            filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
                        }
                        if (StringUtils.isNotEmpty(filterSchemeId)) {
                            markId = menuId + "#" + filterSchemeId;
                        }
                    }
                    if (mainPageView.getViewNoPlugin(menuPageId = markId + mainPageId) != null) {
                        OpenOnTabPageUtils.activatePage(menuPageId, myappView, map);
                    } else {
                        OpenOnTabPageUtils.openMenuPage(appId, menuId, map);
                    }
                }
            } else if (menuId != null && !isAppHome) {
                OpenOnTabPageUtils.openMenuPage(appId, menuId, map);
            }
        }
    }

    public static void openAppForCardCount(String appId, String menuId, Map<String, Object> map, IFormView myappView) {
        OpenOnTabPageUtils.openAppForCardCount(appId, menuId, map, myappView, "");
    }

    public static void openAppForCardCount(String appId, String menuId, Map<String, Object> map, IFormView myappView, String selfAppName) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null || myappView == null) {
            logger.error("OpenPageUtils----openApp----appId or view in map is null");
            return;
        }
        String appMainNumber = app.getHomeNum();
        IFormView mainPageView = myappView.getMainView();
        if (mainPageView == null) {
            logger.error("OpenPageUtils----openApp----mainPageID or mainPageView is null");
            return;
        }
        String mainPageId = mainPageView.getPageId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        String appName = "";
        appName = StringUtils.isNotBlank((CharSequence)selfAppName) ? selfAppName : app.getName().getLocaleValue();
        if (StringUtils.isBlank((CharSequence)appName)) {
            appName = app.getNumber();
        }
        if (map == null) {
            map = new HashMap<String, Object>();
            map.put("view", myappView);
            map.put(APPNAME, appName);
            map.put(APPMAINNUMBER, appMainNumber);
        }
        if (!OpenOnTabPageUtils.checkAppMenuPermission(appId, menuId, map, isSuperAdmin)) {
            if (StringUtils.isEmpty((CharSequence)menuId)) {
                myappView.showMessage(ResManager.loadKDString((String)"\u65e0", (String)"OpenPageUtils_0", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]) + appName + ResManager.loadKDString((String)"\u7684\u5e94\u7528\u6743\u9650", (String)"OpenPageUtils_1", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                myappView.showMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u6743\u9650", (String)OPEN_PAGE_UTILS_2, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            }
            return;
        }
        Object para = map.get(PARAMETER);
        if (StringUtils.isNotBlank((Object)para)) {
            Map parameter = (Map)SerializationUtils.fromJsonString((String)para.toString(), Map.class);
            String filterSchemeId = null;
            if (parameter != null) {
                filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
            }
            if (StringUtils.isNotEmpty(filterSchemeId)) {
                if (!CardUtils.isHaveSchemeRecord((String)filterSchemeId)) {
                    myappView.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u7ecf\u88ab\u5220\u9664", (String)OPEN_PAGE_UTILS_2, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
                if (!OpenOnTabPageUtils.isHaveSchemeAuth(filterSchemeId, userId)) {
                    myappView.showMessage(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u65b9\u6848\u6743\u9650", (String)OPEN_PAGE_UTILS_2, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                    return;
                }
            }
        }
        boolean isAppHome = false;
        String formNumber = (String)map.get(FORMNUMBER);
        if (StringUtils.isBlank((CharSequence)formNumber)) {
            formNumber = appMainNumber;
            isAppHome = true;
        } else if (formNumber.equals(appMainNumber)) {
            isAppHome = true;
        }
        if ("1".equals(app.getOpenType())) {
            if ("devportal".equals(appId)) {
                myappView.openUrl("#/dform?formId=" + formNumber);
            } else {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(formNumber);
                fsp.getOpenStyle().setShowType(ShowType.NewWindow);
                myappView.showForm(fsp);
            }
        } else if ("2".equals(app.getOpenType())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(formNumber);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            myappView.showForm(fsp);
        } else {
            Tab tab = (Tab)mainPageView.getControl(TABAP);
            for (Control ctrl : tab.getItems()) {
                if (!ctrl.getKey().equals(appId)) continue;
                tab.activeTab(appId);
                myappView.sendFormAction(mainPageView);
                return;
            }
            OpenOnTabPageUtils.openAppPage(appId, map);
            String appPageId = appId + mainPageId;
            IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
            if (appPageView != null) {
                OpenOnTabPageUtils.activatePage(appPageId, myappView, map);
                if (menuId != null && appPageView != null && !isAppHome) {
                    String menuPageId;
                    if (appPageView.getPageId().equalsIgnoreCase(myappView.getPageId())) {
                        appPageView = myappView;
                    }
                    String markId = menuId;
                    Map parameter = new HashMap();
                    Object parameterStr = map.get(PARAMETER);
                    if (StringUtils.isNotBlank((Object)parameterStr)) {
                        parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
                        String filterSchemeId = null;
                        if (parameter != null) {
                            filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
                        }
                        if (StringUtils.isNotEmpty(filterSchemeId)) {
                            markId = menuId + "#" + filterSchemeId;
                        }
                    }
                    if (mainPageView.getViewNoPlugin(menuPageId = markId + mainPageId) != null) {
                        OpenOnTabPageUtils.activatePage(menuPageId, myappView, map);
                    } else {
                        OpenOnTabPageUtils.openMenuPage(appId, menuId, map);
                    }
                }
            } else if (menuId != null && !isAppHome) {
                OpenOnTabPageUtils.openMenuPage(appId, menuId, map);
            }
        }
    }

    public static boolean isHaveSchemeAuth(String schemeId, Long userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId), new SqlParameter(":FUSERID", -5, (Object)userId), new SqlParameter(":FBASEDATAID", -5, (Object)userId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_SHAREFILTERSCHEME T3 ON T1.FSCHEMEID = T3.FSCHEMEID LEFT JOIN T_BAS_SCHEMESHAREUSERS T4 ON T3.FID = T4.FID WHERE T1.FSCHEMEID = ? AND (T1.FISFIXED = '1' OR T1.FUSERID = ? OR T4.FBASEDATAID = ?)";
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next() && rs.getInt(1) > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        Boolean isHaveSchemeAuth = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
        return isHaveSchemeAuth;
    }

    private static boolean checkAppMenuPermission(String appId, String menuId, Map<String, Object> map, boolean isSuperAdmin) {
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            return false;
        }
        boolean isAllUserApp = app.isAllUserApp();
        if (isAllUserApp) {
            if (appId.equals(WFTASK)) {
                return true;
            }
            return !isSuperAdmin || OpenOnTabPageUtils.isAllowAdminBizOperate();
        }
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        boolean isPermission = PermissionServiceHelper.checkUserBizApp((Long)userId, (String)app.getId());
        if (!isPermission) {
            return isPermission;
        }
        if (StringUtils.isNotBlank((CharSequence)menuId)) {
            boolean isNotSpecialMenu = true;
            AppMenuInfo menu = null;
            try {
                menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuId);
            }
            catch (Exception e) {
                logger.error("checkAppMenuPermission", (Throwable)e);
            }
            IFormView view = (IFormView)map.get("view");
            if (menu != null && view != null) {
                Short menuSeq = menu.getSeq();
                if (menuSeq == -1) {
                    isNotSpecialMenu = false;
                }
                if (isNotSpecialMenu) {
                    String formNumber = (String)map.get(FORMNUMBER);
                    if (formNumber != null) {
                        String parameterType = "";
                        if (map.get(PARAMETERTYPE) != null) {
                            parameterType = (String)map.get(PARAMETERTYPE);
                        }
                        String permItem = map.get("permItem") == null ? null : map.get("permItem").toString();
                        boolean isOnlyCheckView = false;
                        String formId = view.getFormShowParameter().getFormId();
                        if (formId.equals("bos_card_numstatisticcard") || formId.equals("bos_card_sumstatisticcard")) {
                            isOnlyCheckView = true;
                        }
                        isPermission = isOnlyCheckView ? PermissionServiceHelper.hasViewPermission((long)userId, (String)app.getId(), (String)formNumber) : (StringUtils.isBlank((CharSequence)permItem) ? ("ListShowParameter".equalsIgnoreCase(parameterType) || "ReportShowParameter".equalsIgnoreCase(parameterType) || "FormShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.hasViewPermission((long)userId, (String)app.getId(), (String)formNumber) : ("BillShowParameter".equalsIgnoreCase(parameterType) || "BaseShowParameter".equalsIgnoreCase(parameterType) ? PermissionServiceHelper.hasNewPermission((long)userId, (String)app.getId(), (String)formNumber) : PermissionServiceHelper.hasViewPermission((long)userId, (String)app.getId(), (String)formNumber))) : PermissionServiceHelper.hasSpecificPerm((long)userId, (String)app.getId(), (String)formNumber, (String)permItem));
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u672a\u7ed1\u5b9a\u8868\u5355\uff0c\u8bf7\u5728\u3010\u5f00\u53d1\u5e73\u53f0\u3011\u91cd\u65b0\u914d\u7f6e\uff01", (String)"OpenPageUtils_4", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
                        isPermission = false;
                    }
                }
            }
        }
        return isPermission;
    }

    @Deprecated
    public static void openAppTab(String appID, String markID, Map<String, Object> map, IFormView myappView) {
        String appNum = AppMetadataCache.getAppNumberById((String)appID);
        OpenOnTabPageUtils.openApp(appNum, markID, map, myappView);
    }

    public static void openMenu(IFormView view, AICommandParameter command) {
        String menuItemId = (String)command.getParameter("menuId");
        if (StringUtils.isBlank((CharSequence)menuItemId)) {
            view.showTipNotification(ResManager.loadKDString((String)FORM_MSG, (String)OPEN_PAGE_UTILS_5, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appId = view.getFormShowParameter().getAppId();
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355", (String)"OpenPageUtils_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        OpenOnTabPageUtils.openMenu(view, menuItemId, app.getId(), command.getPara());
    }

    public static void openMenu(IFormView view, String menuItemId, String bizAppId) {
        OpenOnTabPageUtils.openMenu(view, menuItemId, bizAppId, null);
    }

    public static void openMenu(IFormView view, String menuItemId, String bizAppId, Map<String, Object> customParameters) {
        if (StringUtils.isBlank((CharSequence)menuItemId)) {
            view.showTipNotification(ResManager.loadKDString((String)FORM_MSG, (String)OPEN_PAGE_UTILS_5, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appId = AppMetadataCache.getAppNumberById((String)bizAppId);
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u5e94\u7528", (String)"OpenPageUtils_7", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuItemId);
        if (menu == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u83dc\u5355", (String)"OpenPageUtils_6", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appHomeNum = app.getHomeNum();
        String menuFormId = menu.getFormId();
        if (StringUtils.isBlank((CharSequence)appHomeNum) || StringUtils.isBlank((CharSequence)menuFormId)) {
            view.showTipNotification(ResManager.loadKDString((String)FORM_MSG, (String)OPEN_PAGE_UTILS_5, (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String appName = app.getName().getLocaleValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put(APPNAME, appName);
        map.put(APPMAINNUMBER, appHomeNum);
        map.put(FORMNUMBER, menuFormId);
        map.put(PARAMETERTYPE, menu.getParamType());
        map.put(PARAMETER, menu.getParams());
        map.put("menuname", menu.getName().getLocaleValue());
        map.put(CUSTOMPARAMETERS, customParameters);
        OpenOnTabPageUtils.openApp(app.getNumber(), menuItemId, map, view);
    }

    public static void closeMenu(IFormView view, String menuItemId, String appId) {
        String menuPageID;
        IFormView menuView;
        String appPageID;
        IFormView appPageView;
        IFormView mainPageView = view.getMainView();
        if (mainPageView != null && (appPageView = mainPageView.getViewNoPlugin(appPageID = appId + mainPageView.getPageId())) != null && (menuView = view.getViewNoPlugin(menuPageID = menuItemId + mainPageView.getPageId())) != null) {
            menuView.close();
            view.sendFormAction(menuView);
        }
    }

    private static void openAppPage(String appID, Map<String, Object> map) {
        if (map.get(APPNAME) == null || map.get(APPMAINNUMBER) == null || map.get("view") == null) {
            logger.info("OpenPageUtils----openAppPage----appmainnumber or view in map is null [105]");
            return;
        }
        IFormView view = (IFormView)map.get("view");
        IFormView mainPageView = view.getMainView();
        if (mainPageView == null) {
            logger.info("OpenPageUtils----openAppPage----mainPageView or mainPageID is null [98]");
            return;
        }
        String mainPageID = mainPageView.getPageId();
        String appName = map.get(APPNAME).toString();
        String appMainNumber = map.get(APPMAINNUMBER).toString();
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put(APPID, appID);
        customMap.put(APPNAME, appName);
        Map params = (Map)map.get(CUSTOMPARAMETERS);
        if (params != null) {
            customMap.putAll(params);
        }
        String appPageID = appID + mainPageID;
        FormShowParameter para = new FormShowParameter();
        para.setAppId(appID);
        para.setCustomParams(customMap);
        para.getOpenStyle().setTargetKey(TABAP);
        para.getOpenStyle().setShowType(ShowType.NewTabPage);
        para.setFormId(appMainNumber);
        para.setCaption(appName);
        para.setPageId(appPageID);
        para.setHasRight(true);
        para.setFormId(map.get(FORMNUMBER).toString());
        if ("true".equals((String)map.get("noSwitchFocus"))) {
            para.getOpenStyle().setNoSwitchFocus(true);
        }
        FormConfigFactory.createConfig((FormShowParameter)para);
    }

    private static void openMenuPage(String appID, String menuid, Map<String, Object> map) {
        AppMenuInfo appMenuInfo;
        Boolean isAIVoiceRequest;
        HashMap<String, String> customMap;
        if (Objects.isNull(map)) {
            return;
        }
        IFormView view = (IFormView)map.get("view");
        IFormView mainPageView = view.getMainView();
        if (mainPageView == null) {
            logger.info("OpenPageUtils----openMenuPage----mainPageView or mainPageID is null [138]");
            return;
        }
        if (appID == null || map.get("view") == null || map.get(FORMNUMBER) == null) {
            logger.info("OpenPageUtils----openMenuPage----appID or parameter in map is error [143]");
            return;
        }
        String parameterType = "";
        Object objParamType = map.get(PARAMETERTYPE);
        parameterType = objParamType == null ? "FormShowParameter" : objParamType.toString();
        String formNumber = map.get(FORMNUMBER).toString();
        Map<String, Object> parameter = new HashMap();
        Object parameterStr = map.get(PARAMETER);
        if (StringUtils.isNotBlank((Object)parameterStr)) {
            parameter = (Map)SerializationUtils.fromJsonString((String)parameterStr.toString(), Map.class);
        }
        IFormView appPageView = view;
        String filterSchemeId = null;
        if (parameter != null) {
            filterSchemeId = (String)parameter.get(FILTER_SCHEME_ID);
        }
        String markId = null;
        markId = StringUtils.isNotEmpty(filterSchemeId) ? menuid + "#" + filterSchemeId : menuid;
        String menuPageID = markId + mainPageView.getPageId();
        FormShowParameter fsp = OpenOnTabPageUtils.showFormParameter(formNumber, parameterType, parameter, map);
        fsp.setHasRight(true);
        fsp.setAppId(appID);
        Map params = (Map)map.get(CUSTOMPARAMETERS);
        if (params != null) {
            fsp.setCustomParams(params);
        }
        if ((customMap = fsp.getCustomParams()) == null) {
            customMap = new HashMap<String, String>();
        }
        if ((isAIVoiceRequest = (Boolean)customMap.get("isAIVoiceRequest")) != null && isAIVoiceRequest.booleanValue()) {
            Map<String, String> openStyleCustParam = fsp.getOpenStyle().getCustParam() != null ? fsp.getOpenStyle().getCustParam() : new HashMap();
            openStyleCustParam.put("isFullScreen", "true");
            fsp.getOpenStyle().setCustParam(openStyleCustParam);
        }
        if ((appMenuInfo = AppMetadataCache.getAppMenuInfo((String)appID, (String)menuid)) != null && "Modal".equals(appMenuInfo.getOpenType())) {
            fsp.getOpenStyle().setShowType(ShowType.Modal);
        }
        customMap.put(APPID, appID);
        fsp.setCustomParams(customMap);
        fsp.setPageId(menuPageID);
        List pluginList = ((FormViewPluginProxy)appPageView.getService(FormViewPluginProxy.class)).getPlugIns();
        if (pluginList != null && pluginList.size() > 0) {
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)pluginList.get(0), "close_menupage"));
        }
        if (view.getPageId().equals(appPageView.getPageId())) {
            view.showForm(fsp);
        } else {
            appPageView.showForm(fsp);
            view.sendFormAction(appPageView);
        }
        String userId = RequestContext.get().getUserId();
        String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
        String debugInfo = "the ending of click MENU debug info is: ---userID:" + userId + TIME + time + "---menuID:" + menuid + "---menuPageID:" + menuPageID;
        logger.info(debugInfo);
        JSONObject menuInfo = new JSONObject();
        menuInfo.put("type", (Object)"menu");
        menuInfo.put("id", (Object)menuid);
        menuInfo.put("name", map.get("menuname"));
        menuInfo.put(APPID, (Object)appID);
        menuInfo.put(APPNAME, (Object)appPageView.getFormShowParameter().getCaption());
        CollectAppAndMenuUtil menuThread = new CollectAppAndMenuUtil(RequestContext.get(), menuInfo);
        ThreadPools.executeOnceIncludeRequestContext((String)"manageMenuInfo", (Runnable)menuThread);
    }

    private static void activatePage(String pageID, IFormView view, Map<String, Object> map) {
        String menuId = pageID.split("root")[0];
        IFormView childView = view.getViewNoPlugin(pageID);
        if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)map.get(CUSTOMPARAMETERS);
                childView.getFormShowParameter().getCustomParams().remove(MESSAGE_ID);
                childView.getFormShowParameter().getCustomParams().remove(TAB_TYPE);
                childView.getFormShowParameter().getCustomParams().remove(OPEN_PAGE);
                childView.getFormShowParameter().getCustomParams().remove(BILL_FORM_ID);
                if (customparameters != null) {
                    if (customparameters.get(MESSAGE_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(MESSAGE_ID, customparameters.get(MESSAGE_ID));
                    }
                    if (customparameters.get(TAB_TYPE) != null) {
                        childView.getFormShowParameter().setCustomParam(TAB_TYPE, customparameters.get(TAB_TYPE));
                    }
                    if (customparameters.get(OPEN_PAGE) != null) {
                        childView.getFormShowParameter().setCustomParam(OPEN_PAGE, customparameters.get(OPEN_PAGE));
                    }
                    if (customparameters.get(BILL_FORM_ID) != null) {
                        childView.getFormShowParameter().setCustomParam(BILL_FORM_ID, customparameters.get(BILL_FORM_ID));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if (WFTASK.equals(childView.getFormShowParameter().getAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
                String userId = RequestContext.get().getUserId();
                String time = new SimpleDateFormat(YYY_MM_DD_HH_MM_SS).format(new Date(System.currentTimeMillis()));
                String debugInfo = "the ending of click APP debug info is: ---userID:" + userId + TIME + time + "---menuId Or appId:" + menuId + "---PageID" + pageID;
                logger.info(debugInfo);
            }
        } else {
            logger.debug("the pageView of need activate is null, the pageID is: " + pageID);
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55!", (String)"OpenPageUtils_9", (String)BOS_PORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private static FormShowParameter showFormParameter(String formNumber, String parameterType, Map<String, Object> parameter, Map<String, Object> map) {
        FormShowParameter sp;
        if (parameterType.equalsIgnoreCase("ListShowParameter") && Objects.nonNull(parameter)) {
            MainEntityType dt;
            String entityId;
            parameter.put("type", "list");
            String billFormId = (String)parameter.get(BILL_FORM_ID);
            if (billFormId == null && !"empty".equalsIgnoreCase(entityId = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId()) && (dt = EntityMetadataCache.getDataEntityType((String)entityId)) instanceof BillEntityType) {
                parameter.put(BILL_FORM_ID, formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        } else {
            if (Objects.nonNull(parameter) && parameter.get("formId") == null) {
                parameter.put("formId", formNumber);
            }
            sp = FormShowParameter.createFormShowParameter(parameter);
        }
        OpenOnTabPageUtils.setParameterValue(sp, parameter);
        if (Objects.isNull(parameter)) {
            return sp;
        }
        String isModal = (String)parameter.get("isModal");
        if ("1".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.Modal);
            sp.setShowTitle(false);
        } else if ("0".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey("_submaintab_");
        } else {
            Object openType = null;
            if (map != null) {
                openType = map.get("openType");
            }
            String openTypeStr = null;
            if (openType != null) {
                openTypeStr = openType.toString();
            }
            if ("Modal".equals(openTypeStr)) {
                sp.getOpenStyle().setShowType(ShowType.Modal);
            } else {
                sp.getOpenStyle().setShowType(ShowType.NewTabPage);
                sp.getOpenStyle().setTargetKey(TABAP);
            }
        }
        sp.setCustomParams(parameter);
        return sp;
    }

    private static void setParameterValue(FormShowParameter showParameter, Map<String, Object> params) {
        if (params != null) {
            Class<?> clazz = showParameter.getClass();
            try {
                OpenOnTabPageUtils.exeClass(showParameter, params, clazz);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static void exeClass(FormShowParameter showParameter, Map<String, Object> params, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException, IOException {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            String paramName = field.getName();
            String type = field.getGenericType().getTypeName();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String pName = entry.getKey();
                if (pName.equalsIgnoreCase("status") && paramName.equalsIgnoreCase(pName)) {
                    int paramValue = Integer.parseInt((String)entry.getValue());
                    field.set(showParameter, OperationStatus.forValue((int)paramValue));
                    continue block0;
                }
                if (pName.equalsIgnoreCase("listFilterParameter") && paramName.equalsIgnoreCase(pName)) {
                    String paramValue = (String)params.get(pName);
                    ListFilterParameter filterParameter = new ListFilterParameter();
                    filterParameter.setQFilter(paramValue);
                    field.set(showParameter, filterParameter);
                    continue block0;
                }
                if (!paramName.equalsIgnoreCase(pName)) continue;
                String paramValue = "";
                if (params.get(paramName) instanceof LinkedHashMap) {
                    String captionLocalName;
                    LinkedHashMap paramLinkedHashMap = (LinkedHashMap)params.get(paramName);
                    LocaleString captionName = LocaleString.fromMap((Map)paramLinkedHashMap);
                    paramValue = captionLocalName = captionName.getLocaleValue();
                } else if (params.get(paramName) instanceof String) {
                    paramValue = (String)params.get(paramName);
                }
                if (type.endsWith("Object")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("String")) {
                    field.set(showParameter, paramValue);
                    continue block0;
                }
                if (type.endsWith("int") || type.endsWith("Integer")) {
                    field.set(showParameter, Integer.parseInt(paramValue));
                    continue block0;
                }
                if (type.endsWith("double") || type.endsWith("Double")) {
                    field.set(showParameter, Double.parseDouble(paramValue));
                    continue block0;
                }
                if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                    field.set(showParameter, Boolean.parseBoolean(paramValue));
                    continue block0;
                }
                if (type.endsWith("float") || type.endsWith("Float")) {
                    field.set(showParameter, Float.valueOf(Float.parseFloat(paramValue)));
                    continue block0;
                }
                if (type.endsWith("short") || type.endsWith("Short")) {
                    field.set(showParameter, Short.parseShort(paramValue));
                    continue block0;
                }
                if (type.endsWith("long") || type.endsWith("Long")) {
                    field.set(showParameter, Long.parseLong(paramValue));
                    continue block0;
                }
                if (type.endsWith("byte") || type.endsWith("Byte")) {
                    field.set(showParameter, Byte.parseByte(paramValue));
                    continue block0;
                }
                if (!type.endsWith("Map<java.lang.String, java.lang.Object>")) continue block0;
                field.set(showParameter, SerializationUtils.fromJsonString((String)paramValue, Map.class));
                continue block0;
            }
        }
        Class<?> clazzs = clazz.getSuperclass();
        OpenOnTabPageUtils.exeClass(showParameter, params, clazzs);
    }
}

