/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSBatchFunction;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public final class PurAvailableStockDataFunction
implements BOSUDFunction,
BOSBatchFunction {
    private CRExpressionContext context;
    private static final Log log = LogFactory.getLog(PurAvailableStockDataFunction.class);

    public BOSUDFunction getInstance(ExpressionContext expressionContext) {
        return new PurAvailableStockDataFunction(expressionContext);
    }

    public PurAvailableStockDataFunction() {
    }

    public PurAvailableStockDataFunction(ExpressionContext context) {
        this.context = (CRExpressionContext)context;
    }

    public String getName() {
        return "getAvailableStockData";
    }

    public Object call(Object ... objects) {
        BigDecimal stockQty = BigDecimal.ZERO;
        BillEntityType tgtMainType = this.context.getTgtMainType();
        BillEntityType srcMainType = this.context.getSrcMainType();
        if (this.verifySourceType(srcMainType) && this.verifyTargetType(tgtMainType)) {
            DynamicObject activeRow = this.context.getActiveRow();
            Map fldProperties = this.context.getFldProperties();
            if (activeRow != null) {
                HashMap<String, String> customParamMap = new HashMap<String, String>(1);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"pur_availabledataparam");
                IDataEntityProperty valuePropertyType = (IDataEntityProperty)mainEntityType.getAllFields().get("qtypropertydim");
                String qtyPropertyDim = ((ComboProp)valuePropertyType).getDefValue().toString();
                if (objects != null && objects.length == 1) {
                    qtyPropertyDim = objects[0].toString();
                }
                customParamMap.put("tgtbilltype", tgtMainType.getName());
                customParamMap.put("valueproperty", qtyPropertyDim);
                DynamicProperty entryIdPro = (DynamicProperty)fldProperties.get("materialentry.id");
                Long entryId = Long.parseLong(entryIdPro.getValue((Object)activeRow).toString());
                stockQty = this.getSingleOrderAvailableQtyCache(qtyPropertyDim, entryId, customParamMap);
            }
        } else {
            throw new KDException(new ErrorCode("", ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u548c\u76ee\u6807\u5355\u636e\u4e0d\u6ee1\u8db3\u672c\u51fd\u6570\u4f7f\u7528\u8303\u56f4\uff0c\u8bf7\u52ff\u914d\u7f6e\u4f7f\u7528\u3002", (String)"PurAvailableStockDataFunction_0", (String)"bos-ext-scm", (Object[])new Object[0])), new Object[0]);
        }
        return stockQty;
    }

    public Map<BatchFuncRunParam, Object> batchCall(Set<BatchFuncRunParam> set) {
        HashMap<BatchFuncRunParam, Object> funcRunParamObjectMap = new HashMap<BatchFuncRunParam, Object>(1024);
        return funcRunParamObjectMap;
    }

    private BigDecimal getSingleOrderAvailableQtyCache(String qtyPropertyDim, final Long orderEntryId, final Map<String, String> customParamMap) {
        String cacheKey = String.format("getOrderAvailableQty(%s)", orderEntryId);
        CacheValue cacheValue = (CacheValue)ThreadCache.get((Object)cacheKey, (CacheLoader)new CacheLoader<CacheValue>(){

            public CacheValue load() {
                return new CacheValue(PurAvailableStockDataFunction.this.getSingleOrderAvailableQty(orderEntryId, customParamMap));
            }
        });
        return cacheValue.getOrderAvailableMap().get(qtyPropertyDim);
    }

    private Map<String, BigDecimal> getSingleOrderAvailableQty(Long orderEntryId, Map<String, String> customParamMap) {
        ArrayList<Long> orderEntryIdsParam = new ArrayList<Long>(1);
        orderEntryIdsParam.add(orderEntryId);
        Map orderAvailableDataMap = null;
        try {
            Map resultDataMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getOrderStockBasicQty", (Object[])new Object[]{orderEntryIdsParam, customParamMap});
            if (resultDataMap != null) {
                orderAvailableDataMap = (Map)resultDataMap.get(orderEntryId);
            }
        }
        catch (RuntimeException runtimeException) {
            if (log.isWarnEnabled()) {
                log.warn("PurAvailableStockDataFunction#exceptionmessage:{}", (Object)String.valueOf(runtimeException.getMessage()));
            }
            throw runtimeException;
        }
        return orderAvailableDataMap;
    }

    private boolean verifySourceType(BillEntityType billEntityType) {
        boolean flag = Boolean.FALSE;
        if ("pur_order".equals(billEntityType.getName()) || "scp_order".equals(billEntityType.getName())) {
            flag = Boolean.TRUE;
        }
        return flag;
    }

    private boolean verifyTargetType(BillEntityType billEntityType) {
        boolean flag = Boolean.FALSE;
        if ("pur_deliveryschedule".equals(billEntityType.getName()) || "scp_saloutstock".equals(billEntityType.getName())) {
            flag = Boolean.TRUE;
        }
        return flag;
    }

    static class CacheValue {
        private final Map<String, BigDecimal> orderAvailableMap;

        public CacheValue(Map<String, BigDecimal> orderAvailableMap) {
            this.orderAvailableMap = orderAvailableMap;
        }

        public Map<String, BigDecimal> getOrderAvailableMap() {
            return this.orderAvailableMap;
        }

        public BigDecimal getQty() {
            return this.getOrderAvailableMap().get("qty");
        }

        public BigDecimal getBasicQty() {
            return this.getOrderAvailableMap().get("basicqty");
        }
    }
}

