/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public final class BusinessTrackingParamPlugin
extends CustOpParameterPlugin {
    private static final Log logger = LogFactory.getLog(BusinessTrackingParamPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initExecuteConfig();
    }

    private void initExecuteConfig() {
        ComboEdit entryNumberCombo;
        Object id;
        ComboEdit executeconfig = (ComboEdit)this.getView().getControl("executeconfig");
        String entityNumber = null;
        try {
            List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
            List items = (List)formContext.get(0);
            EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)items);
            id = entityMetadata.getRootEntity().getId();
            String masterId = MetadataDao.getMasterId((String)id);
            entityNumber = !StringUtils.isBlank((CharSequence)masterId) && !StringUtils.equals((CharSequence)id, (CharSequence)masterId) ? MetadataDao.getEntityNumberById((String)masterId) : entityMetadata.getRootEntity().getKey();
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Throwable)runtimeException);
        }
        if (executeconfig != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
            QFilter qFilter = QFilter.isNotNull((String)"id");
            if (entityNumber != null) {
                qFilter.and(new QFilter("entryentity.sourceentity.id", "=", entityNumber)).and(new QFilter("enable", "=", (Object)"1"));
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.scm.plugin.ViewRelationParamPlugin", (String)"pbd_executetracking", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter}, (String)"id");
                id = null;
                try {
                    ComboItem executeConfig = null;
                    DataSet groupDataSet = dataSet.groupBy(new String[]{"id", "number", "name"}).finish();
                    while (groupDataSet.hasNext()) {
                        Row row = groupDataSet.next();
                        String id2 = row.getString("id");
                        String number = row.getString("number");
                        String name = row.getString("name");
                        executeConfig = new ComboItem(new LocaleString(name + "(" + number + ")"), id2);
                        comboItems.add(executeConfig);
                    }
                    groupDataSet.close();
                }
                catch (Throwable executeConfig) {
                    id = executeConfig;
                    throw executeConfig;
                }
                finally {
                    if (dataSet != null) {
                        if (id != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable executeConfig) {
                                ((Throwable)id).addSuppressed(executeConfig);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
            }
            executeconfig.setComboItems(comboItems);
        }
        if ((entryNumberCombo = (ComboEdit)this.getView().getControl("entrynumber")) != null && entityNumber != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType(entityNumber);
            Map entityTypeAllEntities = mainEntityType.getAllEntities();
            ComboItem comboItem = null;
            for (Map.Entry entry : entityTypeAllEntities.entrySet()) {
                String key = (String)entry.getKey();
                EntityType value = (EntityType)entry.getValue();
                if (!value.getClass().equals(EntryType.class)) continue;
                comboItem = new ComboItem(new LocaleString(value.getDisplayName().getLocaleValue() + "(" + value.getName() + ")"), key);
                comboItems.add(comboItem);
            }
            entryNumberCombo.setComboItems(comboItems);
        }
    }

    protected void showParameter(CustOperationParameter v) {
        super.showParameter(v);
        Map mapParam = new HashMap();
        String paramValue = v.getParameter();
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            mapParam = (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
        }
        this.getModel().setValue("executeconfig", mapParam.get("executetrackingid"));
        this.getModel().setValue("showformid", mapParam.get("showformid"));
        this.getModel().setValue("entrynumber", mapParam.get("entrynumber"));
    }

    public boolean check(StringBuilder msgBuilder) {
        String showFormId;
        super.check(msgBuilder);
        boolean verify = true;
        String executeConfig = this.getModel().getDataEntity().getString("executeconfig");
        if (executeConfig == null || executeConfig.isEmpty()) {
            verify = false;
            msgBuilder.append(ResManager.loadKDString((String)"\u6267\u884c\u5173\u7cfb\u914d\u7f6e\u4e3a\u5fc5\u5f55\uff0c\u5fc5\u987b\u8bbe\u7f6e\u503c\u3002", (String)"BusinessTrackingParamPlugin_0", (String)"bos-ext-scm", (Object[])new Object[0]));
        }
        if ((showFormId = this.getModel().getDataEntity().getString("showformid")) == null || showFormId.isEmpty()) {
            verify = false;
            msgBuilder.append(ResManager.loadKDString((String)"\u5173\u7cfb\u5c55\u793a\u8868\u5355\u4e3a\u5fc5\u5f55\uff0c\u5fc5\u987b\u8bbe\u7f6e\u503c\u3002", (String)"BusinessTrackingParamPlugin_1", (String)"bos-ext-scm", (Object[])new Object[0]));
        }
        return verify;
    }

    protected void returnParameter(CustOperationParameter v) {
        super.returnParameter(v);
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("executetrackingid", this.getModel().getDataEntity().getString("executeconfig"));
        mapParam.put("showformid", this.getModel().getDataEntity().getString("showformid"));
        mapParam.put("entrynumber", this.getModel().getDataEntity().getString("entrynumber"));
        String paramValue = SerializationUtils.toJsonString(mapParam);
        v.setParameter(paramValue);
    }
}

