/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.validation.CustValidation;
import kd.bos.metadata.entity.validation.CustValidationParamPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public final class VerifyAvailableParamPlugin
extends CustValidationParamPlugin {
    private static final Log logger = LogFactory.getLog(VerifyAvailableParamPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = this.getEntityNumber();
        Collection<String> coreEntityDims = this.getCoreEntityList(entityNumber);
        if (!coreEntityDims.isEmpty()) {
            String defaultEntityDimNumber = coreEntityDims.stream().findFirst().get();
            this.initCoreEntityCombo(coreEntityDims);
            if (this.getModel().getDataEntity().getString("coreentitydim") == null) {
                this.getModel().setValue("coreentitydim", (Object)defaultEntityDimNumber);
            }
            this.initLinkBillConfigCombo(defaultEntityDimNumber, entityNumber);
            this.initCoreQtyFieldCombo(defaultEntityDimNumber, entityNumber);
            this.initQtyFieldCombo(entityNumber);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String entityNumber = this.getEntityNumber();
        if ("coreentitydim".equals(name) && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.initLinkBillConfigCombo(newValue.toString(), entityNumber);
            this.initCoreQtyFieldCombo(newValue.toString(), entityNumber);
        }
    }

    private void initCoreEntityCombo(Collection<String> coreEntityDims) {
        ComboEdit coreEntityEdit = (ComboEdit)this.getControl("coreentitydim");
        if (coreEntityEdit != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
            ComboItem linkBillConfig = null;
            MainEntityType mainEntityType = null;
            for (String entityNumber : coreEntityDims) {
                mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                if (mainEntityType != null) {
                    linkBillConfig = new ComboItem(new LocaleString(mainEntityType.getDisplayName().getLocaleValue() + "(" + mainEntityType.getName() + ")"), mainEntityType.getName());
                }
                comboItems.add(linkBillConfig);
            }
            coreEntityEdit.setComboItems(comboItems);
        }
    }

    private void initLinkBillConfigCombo(String coreEntityNumber, String entityNumber) {
        ComboEdit linkBillConfigEdit = (ComboEdit)this.getView().getControl("linkbillconfig");
        if (linkBillConfigEdit != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
            QFilter qFilter = new QFilter("sourceentity.id", "=", (Object)coreEntityNumber).and(new QFilter("targetentity.id", "=", (Object)entityNumber)).or(new QFilter("targetentity.id", "=", (Object)coreEntityNumber).and(new QFilter("sourceentity.id", "=", (Object)entityNumber))).and(new QFilter("definelink.id", "=", (Object)"3DNB1TJBXL99"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.scm.plugin.VerifyAvailableParamPlugin", (String)"pbd_linkbillnode", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, (String)"id");){
                ComboItem linkBillConfig = null;
                DataSet groupDataSet = dataSet.groupBy(new String[]{"id", "number"}).finish();
                while (groupDataSet.hasNext()) {
                    Row row = groupDataSet.next();
                    String id = row.getString("id");
                    String number = row.getString("number");
                    linkBillConfig = new ComboItem(new LocaleString(number), id);
                    comboItems.add(linkBillConfig);
                }
                groupDataSet.close();
            }
            linkBillConfigEdit.setComboItems(comboItems);
        }
    }

    private void initCoreQtyFieldCombo(String coreEntityNumber, String entityNumber) {
        ComboEdit coreQtyFieldEdit = (ComboEdit)this.getView().getControl("coreqtyfield");
        if (coreQtyFieldEdit != null) {
            Collection linkCoreValueKeys = (Collection)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getTargetWriteProperty", (Object[])new Object[]{entityNumber});
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)coreEntityNumber);
            Map entityTypeAllFields = mainEntityType.getAllFields();
            if (!entityTypeAllFields.isEmpty()) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
                ComboItem linkBillConfig = null;
                for (Map.Entry entry : entityTypeAllFields.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
                    if (linkCoreValueKeys == null || !linkCoreValueKeys.contains(entryKey)) continue;
                    linkBillConfig = new ComboItem(new LocaleString(dataEntityProperty.getDisplayName().getLocaleValue() + "(" + entryKey + ")"), entryKey);
                    comboItems.add(linkBillConfig);
                }
                coreQtyFieldEdit.setComboItems(comboItems);
            }
        }
    }

    private void initQtyFieldCombo(String entityNumber) {
        ComboEdit coreQtyFieldEdit = (ComboEdit)this.getView().getControl("qtyfield");
        if (coreQtyFieldEdit != null) {
            Collection linkCoreValueKeys = (Collection)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getAvailableQtyField", (Object[])new Object[]{entityNumber});
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map entityTypeAllFields = mainEntityType.getAllFields();
            if (!entityTypeAllFields.isEmpty()) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
                ComboItem linkBillConfig = null;
                for (Map.Entry entry : entityTypeAllFields.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entry.getValue();
                    if (linkCoreValueKeys == null || !linkCoreValueKeys.contains(entryKey)) continue;
                    linkBillConfig = new ComboItem(new LocaleString(dataEntityProperty.getDisplayName().getLocaleValue() + "(" + entryKey + ")"), entryKey);
                    comboItems.add(linkBillConfig);
                }
                coreQtyFieldEdit.setComboItems(comboItems);
            }
        }
    }

    private Collection<String> getCoreEntityList(String entityNumber) {
        HashSet<String> coreEntityDims = new HashSet<String>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = mainEntityType.getAppId();
        if ("pur".equals(appId)) {
            coreEntityDims.add("pur_order");
        } else if ("scp".equals(appId)) {
            coreEntityDims.add("scp_order");
        }
        return coreEntityDims;
    }

    private String getEntityNumber() {
        String entityNumber = null;
        try {
            List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("MetaContext");
            List items = (List)formContext.get(0);
            EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)items);
            String id = entityMetadata.getRootEntity().getId();
            String masterId = MetadataDao.getMasterId((String)id);
            entityNumber = !StringUtils.isBlank((CharSequence)masterId) && !StringUtils.equals((CharSequence)id, (CharSequence)masterId) ? MetadataDao.getEntityNumberById((String)masterId) : entityMetadata.getRootEntity().getKey();
        }
        catch (RuntimeException runtimeException) {
            logger.warn((Throwable)runtimeException);
        }
        return entityNumber;
    }

    protected void showValidation(CustValidation v) {
        String paramValue = v.getParameter();
        Map param = new HashMap(2);
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            param = (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
        }
        this.getModel().setValue("linkbillconfig", param.get("linkbillconfig"));
        this.getModel().setValue("coreentitydim", param.get("coreentitydim"));
        this.getModel().setValue("coreqtyfield", param.get("coreqtyfield"));
        this.getModel().setValue("qtyfield", param.get("qtyfield"));
    }

    protected void returnValidation(CustValidation v) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        if (this.getModel().getProperty("linkbillconfig") != null) {
            String coreEntityDim = (String)this.getModel().getValue("coreentitydim");
            String linkBillConfig = (String)this.getModel().getValue("linkbillconfig");
            String coreQtyField = (String)this.getModel().getValue("coreqtyfield");
            String qtyField = (String)this.getModel().getValue("qtyfield");
            param.put("linkbillconfig", linkBillConfig);
            param.put("coreentitydim", coreEntityDim);
            param.put("coreqtyfield", coreQtyField);
            param.put("qtyfield", qtyField);
        }
        v.setParameter(SerializationUtils.toJsonString(param));
    }

    public boolean checkValidation(StringBuilder msgBuilder) {
        String coreQtyField;
        String linkBillConfig;
        boolean verify = true;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String coreEntityDim = dataEntity.getString("coreentitydim");
        if (StringUtils.isBlank((CharSequence)coreEntityDim)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u7ef4\u5ea6\u914d\u7f6e\u672a\u586b\u5199\u3002", (String)"VerifyAvailableParamPlugin_0", (String)"bos-ext-scm", (Object[])new Object[0])).append("\t\n");
            verify = false;
        }
        if (StringUtils.isBlank((CharSequence)(linkBillConfig = dataEntity.getString("linkbillconfig")))) {
            msgBuilder.append(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u914d\u7f6e\u672a\u586b\u5199\u3002", (String)"VerifyAvailableParamPlugin_1", (String)"bos-ext-scm", (Object[])new Object[0])).append("\t\n");
            verify = false;
        }
        if (StringUtils.isBlank((CharSequence)(coreQtyField = dataEntity.getString("coreqtyfield")))) {
            msgBuilder.append(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u57fa\u672c\u6570\u91cf\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"VerifyAvailableParamPlugin_2", (String)"bos-ext-scm", (Object[])new Object[0])).append("\t\n");
            verify = false;
        }
        if (!verify) {
            this.getView().showTipNotification(msgBuilder.toString());
        }
        return verify;
    }
}

