/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.validation;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BasedataControlValidator
extends AbstractValidator {
    private static Log log = LogFactory.getLog(BasedataControlValidator.class);

    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        String billname = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        HashSet<Object> billidSet = new HashSet<Object>(this.dataEntities.length);
        DynamicObjectCollection objcol = new DynamicObjectCollection();
        for (ExtendedDataEntity dt : this.dataEntities) {
            objcol.add((Object)dt.getDataEntity());
            billidSet.add(dt.getDataEntity().getPkValue());
        }
        Map results = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBasedataControlService", (String)"validator", (Object[])new Object[]{billname, this.getOperateKey(), billidSet, objcol});
        this.handleResults(results, this.dataEntities);
    }

    public void handleResults(Map<String, Map<String, Object>> results, ExtendedDataEntity[] dataEntities) {
        log.info("BasedataControlValidator\u5f00\u59cb\u5904\u7406\u7ed3\u679c");
        if (results == null) {
            return;
        }
        OperateOption opration = this.getOption();
        boolean ignore = false;
        String ignoreinteraction = opration.getVariableValue("ignoreinteraction", "false");
        if (StringUtils.isNotEmpty((CharSequence)ignoreinteraction) && "true".equals(ignoreinteraction)) {
            ignore = true;
        }
        for (ExtendedDataEntity dt : dataEntities) {
            boolean success;
            String billno = dt.getDataEntity().getString("billno");
            Map<String, Object> result = results.get(billno);
            if (null == result || null == result.get("success") || (success = Boolean.parseBoolean(result.get("success").toString()))) continue;
            log.info("BasedataControlValidator\u6709\u62a5\u9519\u4fe1\u606f");
            if ("warning".equals(result.get("messageType"))) {
                if (ignore) continue;
                this.addWarningMessage(dt, (String)result.get("message"));
                continue;
            }
            this.addErrorMessage(dt, (String)result.get("message"));
        }
    }
}

