/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.validation;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scm.Util.OperateTypeVerifyHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public final class VerifyAvailableStockBasicQtyValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(VerifyAvailableStockBasicQtyValidator.class);

    public void validate() {
        if (!this.checkOperateType()) {
            return;
        }
        String parameter = String.valueOf(this.getValidation().get("parameter"));
        String coreEntityDim = "pur_order";
        String linkBillConfig = "order";
        String coreQtyProperty = "relateoutstockbaseqty";
        String qtyProperty = "basicqty";
        if (parameter != null && !parameter.trim().isEmpty()) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
            coreEntityDim = (String)paramMap.get("coreentitydim");
            linkBillConfig = (String)paramMap.get("linkbillconfig");
            coreQtyProperty = (String)paramMap.get("coreqtyfield");
            qtyProperty = (String)paramMap.get("qtyfield");
            if (log.isInfoEnabled()) {
                log.info("VerifyAvailableStockBasicQtyValidator#paramMap:{}", (Object)SerializationUtils.toJsonString((Object)paramMap));
            }
        }
        String listSelectedRowCollectionString = this.getOption().getVariableValue("bos_listselectedrowcollection", "");
        Collection<Long> selectRowIds = this.assembleSelectRowIds(listSelectedRowCollectionString);
        Map linkEntityConfigMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IPbdBusinessTrackingService", (String)"getLinkEntityConfig", (Object[])new Object[]{linkBillConfig});
        String targetLinkFiledKey = linkEntityConfigMap.getOrDefault("targetLinkFiledKey", "poentryid");
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashMap<String, BigDecimal> coreEntryIdBasicQtyMap = new HashMap<String, BigDecimal>(1024);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String targetCoreKeyValue;
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            Long entryId = dynamicObject.getLong("id");
            if (!selectRowIds.contains(entryId) || (targetCoreKeyValue = dynamicObject.getString(targetLinkFiledKey)) == null || targetCoreKeyValue.isEmpty() || "0".equals(targetCoreKeyValue)) continue;
            BigDecimal stepBasicQty = (BigDecimal)coreEntryIdBasicQtyMap.get(targetCoreKeyValue);
            if (stepBasicQty == null) {
                stepBasicQty = BigDecimal.ZERO;
            }
            BigDecimal basicQty = dynamicObject.getBigDecimal(qtyProperty);
            stepBasicQty = stepBasicQty.add(basicQty);
            coreEntryIdBasicQtyMap.put(targetCoreKeyValue, stepBasicQty);
        }
        if (coreEntryIdBasicQtyMap.isEmpty()) {
            return;
        }
        HashMap<String, String> customParamMap = new HashMap<String, String>(64);
        customParamMap.put("tgtbilltype", this.entityKey);
        customParamMap.put("coreentity", coreEntityDim);
        customParamMap.put("entitykey", this.entityKey);
        customParamMap.put("qtyfield", qtyProperty);
        customParamMap.put("coreqtyfield", coreQtyProperty);
        customParamMap.put("valueproperty", coreQtyProperty);
        Map coreEntryBasicQtyMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)"getCoreEntityAvailableBasicQty", (Object[])new Object[]{coreEntryIdBasicQtyMap, customParamMap});
        StringBuilder checkMessage = null;
        int rowIndex = 1;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            checkMessage = new StringBuilder();
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            Long entryId = dynamicObject.getLong("id");
            if (selectRowIds.contains(entryId)) {
                String targetKeyValue = dynamicObject.getString(targetLinkFiledKey);
                String poBillNo = dynamicObject.getString("pobillno");
                BigDecimal currencyBasicQty = coreEntryIdBasicQtyMap.getOrDefault(targetKeyValue, BigDecimal.ZERO);
                BigDecimal coreAvailableBasicQty = coreEntryBasicQtyMap.getOrDefault(targetKeyValue, BigDecimal.ZERO);
                if (currencyBasicQty != null && currencyBasicQty.compareTo(coreAvailableBasicQty) > 0) {
                    checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u786e\u8ba4\u64cd\u4f5c\u540e\uff0c\u5c06\u8d85\u8fc7\u8ba2\u5355{1}\u7684\u6700\u5927\u53ef\u6267\u884c\u6570\u91cf\u3002", (String)"VerifyAvailableStockBasicQtyValidator_0", (String)"bos-ext-scm", (Object[])new Object[]{rowIndex, poBillNo}));
                }
            }
            if (checkMessage.length() > 0) {
                this.addMessage(extendedDataEntity, checkMessage.toString());
            }
            ++rowIndex;
        }
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("seq");
        propertys.add("material");
        propertys.add("unit");
        propertys.add("basicunit");
        propertys.add("basicqty");
        propertys.add("poentryid");
        propertys.add("pobillno");
        propertys.add("jointdatachannelid");
        return propertys;
    }

    public String getEntityKey() {
        return "materialentry";
    }

    private boolean checkOperateType() {
        return OperateTypeVerifyHelper.verifyOperateNumberCanExecute(this.entityKey, this.getOperateKey());
    }

    private Collection<Long> assembleSelectRowIds(String listselectedrowcollection) {
        HashSet<Long> selectRows = new HashSet<Long>(156);
        if (StringUtils.isNotBlank((CharSequence)listselectedrowcollection)) {
            Object[] entryPrimaryKeyValues;
            ListSelectedRowCollection rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)listselectedrowcollection, ListSelectedRowCollection.class);
            if (rows != null && !rows.isEmpty() && (entryPrimaryKeyValues = rows.getEntryPrimaryKeyValues()) != null) {
                Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
            }
        } else {
            for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                Long entryId = dynamicObject.getLong("id");
                selectRows.add(entryId);
            }
        }
        return selectRows;
    }
}

