/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BusinessItemModifyPlugin
implements IBaseDataCtrlPlugin {
    public QFilter getExtendOrgQFilter() {
        return null;
    }

    public Boolean chectDuplicate(String p0, Long p1, List<Long> p2) {
        return null;
    }

    public boolean handleModify(DynamicObject dataInfo) {
        this.copyBillRelation(dataInfo.getPkValue(), dataInfo.get("masterid"));
        this.copyParamRelation(dataInfo.getPkValue(), dataInfo.get("masterid"));
        return super.handleModify(dataInfo);
    }

    private void copyBillRelation(Object tarPk, Object srcPk) {
        QFilter[] filters = new QFilter[]{new QFilter("businessitem.id", "=", srcPk)};
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"bd_businessitembill", (String)"billtype.id,billtype.name", (QFilter[])filters);
        this.saveBillRelation(tarPk, relations);
    }

    private void copyParamRelation(Object tarPk, Object srcPk) {
        QFilter[] filters = new QFilter[]{new QFilter("businessitem.id", "=", srcPk)};
        Map relations = BusinessDataServiceHelper.loadFromCache((String)"bd_busitemrelparam", (String)"paramid.id,value", (QFilter[])filters);
        this.saveParamRelation(new Object[]{tarPk}, relations);
    }

    private void saveBillRelation(Object busItemId, Map<Object, DynamicObject> relations) {
        if (relations.size() > 0) {
            ArrayList relationColl = new ArrayList();
            relations.forEach((relId, relation) -> {
                DynamicObject relBill = BusinessDataServiceHelper.newDynamicObject((String)"bd_businessitembill");
                relBill.set("businessitem", busItemId);
                relBill.set("billtype", relation.get("billtype.id"));
                relBill.set("createorg", (Object)RequestContext.get().getOrgId());
                relBill.set("enable", (Object)"1");
                relBill.set("status", (Object)BillStatus.A.toString());
                relationColl.add(relBill);
            });
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
            this.updateRelBillType(busItemId, relations);
        }
    }

    private void saveParamRelation(Object busItemId, Map<Object, DynamicObject> relations) {
        if (relations.size() > 0) {
            ArrayList relationColl = new ArrayList();
            relations.forEach((relId, relation) -> {
                DynamicObject relBill = BusinessDataServiceHelper.newDynamicObject((String)"bd_busitemrelparam");
                relBill.set("businessitem", busItemId);
                relBill.set("paramid", relation.get("paramid.id"));
                relBill.set("value", (Object)relation.getString("value"));
                relationColl.add(relBill);
            });
            SaveServiceHelper.save((DynamicObject[])relationColl.toArray(new DynamicObject[0]));
        }
    }

    private void updateRelBillType(Object busItemId, Map<Object, DynamicObject> relations) {
        DynamicObject[] busItems = BusinessDataServiceHelper.load((String)"bd_businessitem", (String)"id,relbilltype", (QFilter[])new QFilter[]{new QFilter("id", "=", busItemId)});
        if (relations.size() > 0) {
            List billTypeNames = relations.values().stream().map(v -> v.getString("billtype.name")).collect(Collectors.toList());
            String relBillType = String.join((CharSequence)";", billTypeNames);
            for (DynamicObject busItem : busItems) {
                busItem.set("relbilltype", (Object)relBillType);
            }
            SaveServiceHelper.update((DynamicObject[])busItems);
        }
    }
}

