/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.dhc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.ext.fi.operation.dhc.DocTrackUp;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class DocTrackDown
extends DocTrackUp {
    private List<String> defTargetBill = null;

    @Override
    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        Map parameters = (Map)opMeta.get("parameter");
        if (parameters != null && parameters.containsKey("targetbill")) {
            this.defTargetBill = this.getTargetBillsList((String)parameters.get("targetbill"));
        }
    }

    private List<String> getTargetBillsList(String targetBillsString) {
        if (StringUtils.isBlank((CharSequence)targetBillsString)) {
            return new ArrayList<String>();
        }
        if (targetBillsString.startsWith(",")) {
            targetBillsString = targetBillsString.substring(1, targetBillsString.length() - 1);
        }
        String[] bills = targetBillsString.split(",");
        ArrayList<String> targetBills = new ArrayList<String>();
        for (String bill : bills) {
            if (!StringUtils.isNotBlank((CharSequence)bill)) continue;
            targetBills.add(bill);
        }
        return targetBills;
    }

    @Override
    protected String getLookUpType() {
        return "lookdown";
    }

    @Override
    protected String loadAndSeriLinkNodes(Set<Long> pkIds) {
        List<BFRowLinkDownNode> nodes = null;
        Map<String, HashSet<Long>> entityMap = this.getSelectedBillIdMap(pkIds);
        if (!entityMap.isEmpty()) {
            for (Map.Entry<String, HashSet<Long>> entry : entityMap.entrySet()) {
                nodes = this.filterTargetBill(BFTrackerServiceHelper.loadLinkDownNodes((String)entry.getKey(), (String)"", (Long[])entry.getValue().toArray(new Long[0])));
            }
        }
        if (nodes != null && !nodes.isEmpty()) {
            for (BFRowLinkDownNode node : nodes) {
                for (BFRowLinkDownNode tNode : node.getTNodes().values()) {
                    tNode.setTNodes(new HashMap());
                }
            }
            return SerializationUtils.serializeToBase64((Object)nodes);
        }
        return null;
    }

    private List<BFRowLinkDownNode> filterTargetBill(List<BFRowLinkDownNode> nodes) {
        if (this.defTargetBill == null || this.defTargetBill.isEmpty()) {
            return nodes;
        }
        Iterator<BFRowLinkDownNode> listIt = nodes.iterator();
        while (listIt.hasNext()) {
            BFRowLinkDownNode node = listIt.next();
            Map targetBillMap = node.getTNodes();
            Iterator it = targetBillMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Long mainTableId = ((BFRowId)entry.getKey()).getMainTableId();
                if (this.defTargetBill.contains(EntityMetadataCache.loadTableDefine((Long)mainTableId).getEntityNumber())) continue;
                it.remove();
            }
            if (node.getTNodes().size() != 0) continue;
            listIt.remove();
        }
        return nodes;
    }
}

