/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fircm.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.management.plugin.ApprovalPageTpl;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.AfterCreatNewDataForApprovalCustomEvent;
import kd.bos.workflow.taskcenter.plugin.udlayout.entity.BeforeSubmitCustomEvent;

public class WorkflowApprovalPageCreditDeductionPlugin
extends ApprovalPageTpl
implements BeforeF7SelectListener {
    private static final String KEY_APFORMFLEXPANEL = "customeparamflexpanel";
    private static final String KEY_CREDITCONTROL = "creditcontrol";
    private static final String CREDITBASEENTITYNUMBER = "fircm_subscorerule";
    private static final String FAIL = "0";
    private static final String DEFECT_PASS = "1";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String CACHEKEY_ALREADYLOAD_CREDITCONTROL = "alreadyLoadCreditControl";
    private static final Map<String, String> FORM_APPROVALDEC_MAP = new HashMap<String, String>(4);
    private static final Style STYLE = new Style();
    private static final Margin MARGIN = new Margin();
    private static final String EIGHT_PX = "15px";
    private static final LocaleString OLD_MOB_DEAL_PAGE_WIDTH = new LocaleString("100%");
    private static final LocaleString NEW_MOB_DEAL_PAGE_WIDTH = new LocaleString("calc(100% - 30px)");

    public void afterCreatNewDataForApprovalCustomEvent(AfterCreatNewDataForApprovalCustomEvent e) {
        boolean creditCheck = this.getCreditLoadCheck(e);
        this.getPageCache().put("check_credit_result", creditCheck ? "true" : "false");
        if (creditCheck) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{KEY_APFORMFLEXPANEL});
            String isAlreadyLoad = this.getPageCache().get(CACHEKEY_ALREADYLOAD_CREDITCONTROL);
            if (!"true".equals(isAlreadyLoad)) {
                this.dynamicAddControl(this.getView());
            }
        }
    }

    public void beforeSubmitCustomEvent(BeforeSubmitCustomEvent e) {
        String creditCheckStr = this.getPageCache().get("check_credit_result");
        if ("true".equals(creditCheckStr)) {
            DynamicObjectCollection creditObj = (DynamicObjectCollection)this.getModel().getValue(KEY_CREDITCONTROL);
            if (("reject".equalsIgnoreCase(e.getDecisionOption().getAuditType()) || "terminate".equalsIgnoreCase(e.getDecisionOption().getAuditType())) && creditObj.isEmpty()) {
                e.setVerifyInformation(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u6838\u4fe1\u7528\u6263\u5206\u9879\u3002", (String)"WorkflowApprovalPageCreditDeductionPlugin_0", (String)"bos-ext-ssc", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (!creditObj.isEmpty()) {
                Map variables = e.getVariables();
                List<String> creditValueIds = this.getCreditValues();
                variables.put("creditscorerule", String.join((CharSequence)",", creditValueIds));
                variables.put("audittype", e.getDecisionOption().getAuditType());
                e.setVariables(variables);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseData = (BasedataEdit)this.getControl(KEY_CREDITCONTROL);
        baseData.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        BasedataEdit baseData = (BasedataEdit)evt.getSource();
        if (KEY_CREDITCONTROL.equals(baseData.getKey())) {
            List<Long> billRelationSubScoreRule = this.getScoreRule(this.getPageCache().get(ENTITYNUMBER), this.getChooseAuditType());
            QFilter typeFil = new QFilter("id", "in", billRelationSubScoreRule);
            ListShowParameter listShowParam = (ListShowParameter)evt.getFormShowParameter();
            listShowParam.getListFilterParameter().setQFilters(Collections.singletonList(typeFil));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel dataModel = this.getModel();
        String propName = e.getProperty().getName();
        if (propName.equals("combo_decision")) {
            dataModel.setValue(KEY_CREDITCONTROL, null);
        } else if (propName.equals("designradiogroupfield")) {
            dataModel.setValue(KEY_CREDITCONTROL, null);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (KEY_CREDITCONTROL.equals(e.getKey())) {
            MulBasedataEdit basedataEdit = new MulBasedataEdit();
            basedataEdit.setKey(KEY_CREDITCONTROL);
            basedataEdit.setView(this.getView());
            e.setControl((Control)basedataEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        this.registBasedataEntityType(newMainType);
        e.setNewEntityType(newMainType);
    }

    public String getApprovalPageId() {
        return this.getView().getPageId();
    }

    public String getBillPageId() {
        return this.getPageCache().get("billPageId");
    }

    public boolean isPCShow() {
        return false;
    }

    private void registBasedataEntityType(MainEntityType newMainType) {
        DynamicObjectType type = new DynamicObjectType(KEY_CREDITCONTROL);
        type.setDbIgnore(false);
        this.registerProperties(type);
        MulBasedataProp prop = new MulBasedataProp(KEY_CREDITCONTROL, type);
        prop.setDbIgnore(true);
        prop.setBaseEntityId(CREDITBASEENTITYNUMBER);
        prop.setName(KEY_CREDITCONTROL);
        prop.setDbIgnore(true);
        prop.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u4fe1\u7528\u6263\u5206\u9879", (String)"WorkflowApprovalPageCustomParametersPluginDemo_1", (String)"bos-wf-unittest", (Object[])new Object[0])));
        prop.setGroupControl(false);
        newMainType.registerCollectionProperty((DynamicCollectionProperty)prop);
    }

    private void registerProperties(DynamicObjectType type) {
        String pkName = "pkid";
        LongProp pkProp = new LongProp();
        pkProp.setName(pkName);
        pkProp.setPrimaryKey(true);
        pkProp.setAlias("F" + pkName);
        type.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        BasedataProp baseProp = new BasedataProp();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)CREDITBASEENTITYNUMBER);
        baseProp.setBaseEntityId(dt.getName());
        baseProp.setAlias("FBasedataId");
        baseProp.setName("fbasedataid");
        baseProp.setDisplayProp("name");
        baseProp.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u4fe1\u7528\u6263\u5206\u9879", (String)"WorkflowApprovalPageCustomParametersPluginDemo_1", (String)"bos-wf-unittest", (Object[])new Object[0])));
        baseProp.setEditSearchProp("name");
        baseProp.setDbIgnore(true);
        baseProp.setComplexType((IDataEntityType)dt);
        String key_ref = "fbasedataid_id";
        DynamicSimpleProperty refIdProp = baseProp.createRefIDProp();
        refIdProp.setName(key_ref);
        refIdProp.setAlias("FBasedataId");
        refIdProp.setDbIgnore(false);
        baseProp.setRefIdProp((IDataEntityProperty)refIdProp);
        baseProp.setRefIdPropName(key_ref);
        type.registerComplexProperty((DynamicComplexProperty)baseProp);
        type.registerSimpleProperty(refIdProp);
    }

    public void dynamicAddControl(IFormView view) {
        this.getPageCache().put(CACHEKEY_ALREADYLOAD_CREDITCONTROL, "true");
        Container container = (Container)view.getControl(KEY_APFORMFLEXPANEL);
        if (container != null) {
            FieldAp fieldAp = this.createDynamicFieldAp();
            ArrayList<Map> items = new ArrayList<Map>();
            items.add(fieldAp.createControl());
            container.addControls(items);
        }
    }

    private FieldAp createDynamicFieldAp() {
        String formId;
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(KEY_CREDITCONTROL);
        fieldAp.setKey(KEY_CREDITCONTROL);
        fieldAp.setName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u4fe1\u7528\u6263\u5206\u9879", (String)"WorkflowApprovalPageCustomParametersPluginDemo_1", (String)"bos-wf-unittest", (Object[])new Object[0])));
        fieldAp.setFireUpdEvt(true);
        MulBasedataField ba = new MulBasedataField();
        ba.setId(KEY_CREDITCONTROL);
        ba.setKey(KEY_CREDITCONTROL);
        ba.setBaseEntityId(CREDITBASEENTITYNUMBER);
        fieldAp.setField((Field)ba);
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "wf_approvaldealpagemobile": {
                fieldAp.setWidth(OLD_MOB_DEAL_PAGE_WIDTH);
                break;
            }
            case "wf_approvalopiniondet_mob": {
                fieldAp.setWidth(NEW_MOB_DEAL_PAGE_WIDTH);
                fieldAp.setStyle(STYLE);
                break;
            }
        }
        return fieldAp;
    }

    private List<Long> getScoreRule(String entityNumber, String type) {
        return (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getSubScoreRuleIdsByBillNumAndType", (Object[])new Object[]{entityNumber, type});
    }

    private String getChooseAuditType() {
        String formId = this.getView().getFormShowParameter().getFormId();
        String controlKey = FORM_APPROVALDEC_MAP.get(formId);
        String chose = controlKey != null ? (String)this.getModel().getValue(controlKey) : this.getPageCache().get("auditType");
        if (chose == null) {
            return "";
        }
        if ((chose = chose.toLowerCase()).contains("reject")) {
            return FAIL;
        }
        if (chose.contains("approve") || chose.contains("consent")) {
            return DEFECT_PASS;
        }
        return "";
    }

    private List<String> getCreditValues() {
        DynamicObjectCollection creditValue = (DynamicObjectCollection)this.getModel().getValue(KEY_CREDITCONTROL);
        ArrayList<String> creditValueIds = new ArrayList<String>();
        for (DynamicObject dynObj : creditValue) {
            creditValueIds.add(dynObj.getString("fbasedataid_id"));
        }
        return creditValueIds;
    }

    private boolean getCreditLoadCheck(AfterCreatNewDataForApprovalCustomEvent e) {
        String category;
        Control control = this.getView().getControl(KEY_APFORMFLEXPANEL);
        if (control == null) {
            return false;
        }
        FlowElement flowElement = e.getFlowElement();
        if (flowElement == null || flowElement.isAddSign()) {
            return false;
        }
        AgentTaskHandleContext context = e.getContext();
        if (context == null) {
            return false;
        }
        TaskInfo task = context.getTask();
        if (task == null) {
            return false;
        }
        switch (category = task.getCategory()) {
            case "AuditTask": 
            case "YunzhijiaTask": {
                break;
            }
            default: {
                return false;
            }
        }
        String taskControl = task.getControl();
        if (StringUtils.isEmpty((String)taskControl)) {
            return false;
        }
        Map<String, Object> controlMap = this.getValueFromMapJson(taskControl);
        if (controlMap == null) {
            return false;
        }
        if (this.enableByExtraNode(controlMap, category) || this.enableByCustomParam(controlMap)) {
            return (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"isConfigCreditArg", (Object[])new Object[]{this.getPageCache().get(ENTITYNUMBER)});
        }
        return false;
    }

    private boolean enableByCustomParam(Map<String, Object> controlMap) {
        Object extras = controlMap.get("extras");
        if (extras == null) {
            return false;
        }
        if (!(extras instanceof Map)) {
            return false;
        }
        Map extrasMap = (Map)extras;
        Object credit = extrasMap.get(KEY_CREDITCONTROL);
        return credit != null && "true".equalsIgnoreCase(credit.toString());
    }

    private boolean enableByExtraNode(Map<String, Object> controlMap, String nodeType) {
        Object nodeExtAudits = controlMap.get("extNum");
        if (nodeExtAudits == null) {
            return false;
        }
        if (!(nodeExtAudits instanceof List)) {
            return false;
        }
        List nodeExtAuditsList = (List)nodeExtAudits;
        return "AuditTask".equals(nodeType) && nodeExtAuditsList.contains("fircm_creditApprove#addCreditField") || "YunzhijiaTask".equals(nodeType) && nodeExtAuditsList.contains("fircm_yzjCreditApprove#addCreditField");
    }

    private Map<String, Object> getValueFromMapJson(String mapJson) {
        if (StringUtils.isEmpty((String)mapJson)) {
            return null;
        }
        try {
            Map controlMap = (Map)SerializationUtils.fromJsonString((String)mapJson, Map.class);
            if (controlMap == null || controlMap.isEmpty()) {
                return null;
            }
            return controlMap;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        MARGIN.setTop(EIGHT_PX);
        MARGIN.setLeft(EIGHT_PX);
        MARGIN.setRight(EIGHT_PX);
        STYLE.setMargin(MARGIN);
        FORM_APPROVALDEC_MAP.put("wf_approvalpage_bac", "combo_decision");
        FORM_APPROVALDEC_MAP.put("wf_approvalpageud_tifull", "designradiogroupfield");
    }
}

