/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.helper;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.ssc.helper.TaskCreditHelper;
import kd.bos.ext.ssc.helper.WorkFlowCreditHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaskApproveSuccessHelper {
    private static final Log log = LogFactory.getLog(TaskApproveSuccessHelper.class);

    public static Map<String, Object> saveArtiCheckPointInfo(Long taskId, IDataModel model, String operation) {
        DynamicObjectCollection entryEntity;
        log.info("saveArtiCheckPointInfo, taskId = {}, operation = {}", (Object)taskId, (Object)operation);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("taskId", taskId);
        long currUserId = RequestContext.get().getCurrUserId();
        paramMap.put("currentPersonId", currUserId);
        if ("1".equals(operation)) {
            paramMap.put("allPass", Boolean.TRUE);
        }
        ArrayList recordList = new ArrayList();
        if (model != null && !CollectionUtils.isEmpty((Collection)(entryEntity = model.getEntryEntity("entryentity")))) {
            for (DynamicObject entry : entryEntity) {
                HashMap<String, Constable> recordMap = new HashMap<String, Constable>(8);
                recordMap.put("artiCheckPointId", Long.valueOf(entry.getLong("articheckpointid")));
                recordMap.put("isContented", Boolean.valueOf(entry.getBoolean("checkboxfield")));
                recordList.add(recordMap);
            }
        }
        paramMap.put("recordList", recordList);
        return (Map)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"saveArtiCheckPointInfo", (Object[])new Object[]{paramMap});
    }

    public static DynamicObject getTaskHistoryDo(Long taskId) {
        String entityName = "task_taskhistory";
        String selectFields = "id, sscid, sourcetaskid, billid, billnumber, pooltype, state, tasktypeid.id, billtype.id";
        QFilter idFilter = new QFilter("sourcetaskid", "=", (Object)taskId);
        DynamicObject taskHistoryDo = QueryServiceHelper.queryOne((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{idFilter});
        return taskHistoryDo;
    }

    public static void creditSubScore(String operation, DynamicObject taskHistoryDo, Map<String, String> map) {
        Boolean openCreditControl;
        if (taskHistoryDo == null) {
            return;
        }
        Long historyTaskId = taskHistoryDo.getLong("id");
        if ("1".equals(operation)) {
            TaskCreditHelper.saveBreakRuleRecord(historyTaskId, map);
        }
        if ((openCreditControl = WorkFlowCreditHelper.isOpenCreditControlByHisTask(historyTaskId)) == null) {
            if ("1".equals(operation)) {
                TaskCreditHelper.passedButFlawed(map, historyTaskId);
            } else if ("2".equals(operation)) {
                TaskCreditHelper.approvalFailed(map, historyTaskId);
            }
        }
    }

    public static void updateTaskIdMap(Map<Long, List<Long>> taskIdMap, Long sscId, Long taskId) {
        if (taskIdMap == null || sscId == null || taskId == null) {
            log.error("updateTaskIdMap error, taskIdMap = {}, sscId = {}, taskId = {}", new Object[]{taskIdMap, sscId, taskId});
            return;
        }
        if (taskIdMap.containsKey(sscId)) {
            List<Long> taskIdList = taskIdMap.get(sscId);
            taskIdList.add(taskId);
        } else {
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            taskIdList.add(taskId);
            taskIdMap.put(sscId, taskIdList);
        }
    }
}

