/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BillAttributeControlFormPlugin
extends AbstractBillPlugIn {
    public static final Log log = LogFactory.getLog(BillAttributeControlFormPlugin.class);
    private IClientViewProxy clientViewProxy = null;
    private OperationStatus billStatus = null;
    private String processing = "1";
    private String complete = "2";
    private StringBuilder sb = new StringBuilder("billattributecontrol: ");

    public void initialize() {
        super.initialize();
        if (this.billStatus == null) {
            BillView view = (BillView)this.getView();
            this.billStatus = view.getStatus();
        }
    }

    public void afterBindData(EventObject e) {
        String pooltypeTemp;
        super.afterBindData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String taskID = (String)showParam.getCustomParam("taskID");
        String pooltype = (String)showParam.getCustomParam("pooltype");
        String pooltype_mytask = (String)showParam.getCustomParam("pooltype-mytask");
        String string = pooltypeTemp = StringUtils.isNotEmpty((String)pooltype) ? pooltype : pooltype_mytask;
        if (StringUtils.isEmpty((String)taskID) || StringUtils.isEmpty((String)pooltypeTemp)) {
            log.error(String.format("\u5f02\u5e38\uff1ataskID=%s, billStatus=%s, pooltype=%s, pooltype_mytask=%s", taskID, this.billStatus.name(), pooltype, pooltype_mytask));
            return;
        }
        log.info(String.format("start invoke getBillAttriConfig(), taskID=%s, billStatus=%s, pooltype=%s, pooltype_mytask=%s", taskID, this.billStatus.name(), pooltype, pooltype_mytask));
        HashSet<String> needDisplayTbs = new HashSet<String>(8);
        HashSet<String> needHideTbItems = new HashSet<String>(8);
        List<String> ctrlApTypes = Arrays.asList("AdvConToolbarAp", "BarItemAp", "MBarItemAp", "AdvConBarItemAp");
        Map<String, Object> billAttriConfig = this.getBillAttriConfig(taskID, pooltypeTemp);
        for (Map.Entry<String, Object> attriInfoEntry : billAttriConfig.entrySet()) {
            Map AttriInfo = (Map)attriInfoEntry.getValue();
            String ctrlApNum = (String)AttriInfo.get("ctrlapnumber");
            boolean hasPoint = false;
            if (ctrlApNum.indexOf(46) >= 0) {
                int pointIndex = ctrlApNum.lastIndexOf(46);
                ctrlApNum = ctrlApNum.substring(pointIndex + 1);
                hasPoint = true;
            }
            boolean hide = (Boolean)AttriInfo.get("hide");
            boolean modify = (Boolean)AttriInfo.get("modify");
            String ctrlApType = (String)AttriInfo.get("ctrlaptype");
            if ("field".equals(ctrlApType)) {
                this.fieldApControl(pooltypeTemp, ctrlApNum, hide, modify);
                continue;
            }
            if (ctrlApTypes.contains(ctrlApType)) {
                this.btnOrToolBarApHandle(needDisplayTbs, needHideTbItems, ctrlApNum, hasPoint, hide);
                continue;
            }
            if (!"labelorimage".equals(ctrlApType)) continue;
            this.LabelOrImageApControl(ctrlApNum, hide);
        }
        List<Control> ctrlList = Collections.singletonList(this.getView().getRootControl());
        this.loopAndHideToolBar(ctrlList, needDisplayTbs);
        log.info(this.sb.toString());
        if (!OperationStatus.VIEW.equals((Object)this.billStatus)) {
            this.hideToolBarItem(needHideTbItems);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"titlepanelflex"});
    }

    private Map<String, Object> getBillAttriConfig(String taskID, String poolType) {
        HashMap<String, Object> billAttriConfMap = new HashMap<String, Object>();
        String algoKey = BillAttributeControlFormPlugin.class + ".getBillAttriConfig()";
        String entityName = poolType.equals(this.complete) ? "task_taskhistory" : "task_task";
        Long billType = 0L;
        Long taskTypeId = 0L;
        QFilter taskIdFil = new QFilter("id", "=", (Object)Long.valueOf(taskID));
        QFilter poolTypeFil = new QFilter("pooltype", "=", (Object)poolType);
        try (DataSet taskSet = QueryServiceHelper.queryDataSet((String)(algoKey + "1"), (String)entityName, (String)"id,billtype,tasktypeid", (QFilter[])new QFilter[]{taskIdFil, poolTypeFil}, null, (int)1);){
            for (Row row : taskSet) {
                billType = row.getLong("billtype");
                taskTypeId = row.getLong("tasktypeid");
            }
        }
        if (billType == 0L || taskTypeId == 0L) {
            log.error(String.format("\u5f02\u5e38\uff1ataskID=%s, poolType=%s, billType=%s, taskTypeId=%s", taskID, poolType, billType, taskTypeId));
            return billAttriConfMap;
        }
        Long childpkid = 0L;
        QFilter billIdFil = new QFilter("id", "=", (Object)billType);
        QFilter taskTypeIdFil = new QFilter("entryentity.tasktype", "=", (Object)taskTypeId);
        try (DataSet taskBillSet = QueryServiceHelper.queryDataSet((String)(algoKey + "2"), (String)"task_taskbill", (String)"id,entryentity.childpkid childpkid", (QFilter[])new QFilter[]{billIdFil, taskTypeIdFil}, null, (int)1);){
            for (Row row : taskBillSet) {
                childpkid = row.getLong("childpkid");
            }
        }
        if (childpkid == 0L) {
            log.error(String.format("\u5f02\u5e38\uff1ataskID=%s, poolType=%s, billType=%s, taskTypeId=%s, childpkid=%s", taskID, poolType, billType, taskTypeId, childpkid));
            return billAttriConfMap;
        }
        String billAttriConf = "";
        String billAttriConfJson = "";
        QFilter childIdFil = new QFilter("id", "=", (Object)childpkid);
        DataSet childBillSet = QueryServiceHelper.queryDataSet((String)(algoKey + "3"), (String)"task_taskbill_child", (String)"billattriconfig,billattriconfigjson_tag", (QFilter[])new QFilter[]{childIdFil}, null, (int)1);
        Object object = null;
        try {
            for (Row row : childBillSet) {
                billAttriConf = row.getString("billattriconfig");
                billAttriConfJson = row.getString("billattriconfigjson_tag");
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (childBillSet != null) {
                if (object != null) {
                    try {
                        childBillSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    childBillSet.close();
                }
            }
        }
        if (StringUtils.isEmpty((String)billAttriConfJson)) {
            log.info(String.format("\u672a\u914d\u7f6e\u5355\u636e\u4fee\u6539\u6743\u9650billAttriConf=%s,billAttriconfJson=%s", taskID, poolType));
            return billAttriConfMap;
        }
        List selectedValue = SerializationUtils.fromJsonStringToList((String)billAttriConfJson, Map.class);
        for (Map ctrlApInfo : selectedValue) {
            billAttriConfMap.put(ctrlApInfo.get("ctrlapnumber").toString(), ctrlApInfo);
        }
        return billAttriConfMap;
    }

    private void fieldApControl(String pooltype, String fieldNumber, boolean hide, boolean modify) {
        Control ctrlAp = this.getControl(fieldNumber);
        String entryKey = null;
        if (ctrlAp instanceof FieldEdit) {
            FieldEdit field = (FieldEdit)ctrlAp;
            entryKey = field.getEntryKey();
        }
        if (modify && OperationStatus.EDIT.equals((Object)this.billStatus) && this.processing.equals(pooltype)) {
            if (StringUtils.isEmpty((String)entryKey)) {
                this.unlockField(fieldNumber, null);
            } else {
                Control entryCtrlAp = this.getControl(entryKey);
                if (entryCtrlAp instanceof CardEntry) {
                    this.unlockField(fieldNumber, null);
                } else {
                    this.unlockField(fieldNumber, entryKey);
                }
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{fieldNumber});
        }
        if (hide) {
            this.getView().setVisible(Boolean.FALSE, new String[]{fieldNumber});
        }
    }

    private void btnOrToolBarApControl(String billStatus, String ctrlApNumber, boolean hide) {
        if (hide) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ctrlApNumber});
        }
    }

    private void btnOrToolBarApHandle(Set<String> needDisplayTbs, Set<String> needHideTbItems, String ctrlApNum, boolean hasPoint, boolean hide) {
        if (!hasPoint && !hide) {
            needDisplayTbs.add(ctrlApNum);
        } else if (hasPoint && hide) {
            needHideTbItems.add(ctrlApNum);
        }
    }

    private void LabelOrImageApControl(String ctrlApNumber, boolean hide) {
        if (hide) {
            return;
        }
        Control ctrlAp = this.getControl(ctrlApNumber);
        if (ctrlAp instanceof Label || ctrlAp instanceof Image) {
            this.setCtrlMetadataVisible(ctrlApNumber);
            this.getView().setVisible(Boolean.TRUE, new String[]{ctrlApNumber});
        }
    }

    private void unlockField(String fieldNumber, String entryKey) {
        if (StringUtils.isEmpty((String)entryKey)) {
            HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
            prop.put("l", 0);
            this.getView().updateControlMetadata(fieldNumber, prop);
        } else {
            if (this.clientViewProxy == null) {
                this.clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            }
            this.clientViewProxy.invokeControlMethod(entryKey, "setColProp", new Object[]{fieldNumber, "l", 0});
        }
    }

    private void setCtrlMetadataVisible(String ctrlApNumber) {
        if (StringUtils.isNotEmpty((String)ctrlApNumber)) {
            HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
            prop.put("vi", 63);
            this.getView().updateControlMetadata(ctrlApNumber, prop);
        }
    }

    private void loopAndHideToolBar(List<Control> ctrlList, Set<String> needDisplayTbs) {
        if (ctrlList == null || ctrlList.size() == 0) {
            return;
        }
        for (Control control : ctrlList) {
            String key = control.getKey();
            if ("pagepanel".equals(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
                continue;
            }
            if (control instanceof Toolbar) {
                if (!this.isNeedHide(needDisplayTbs, key)) continue;
                this.sb.append(key + ";");
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
                continue;
            }
            if (!(control instanceof Container)) continue;
            this.loopAndHideToolBar(((Container)control).getItems(), needDisplayTbs);
        }
    }

    private boolean isNeedHide(Set<String> needDisplayTbs, String key) {
        return OperationStatus.VIEW.equals((Object)this.billStatus) || !needDisplayTbs.contains(key);
    }

    private void hideToolBarItem(Set<String> needHideTbItems) {
        if (needHideTbItems.size() > 0) {
            this.getView().setVisible(Boolean.FALSE, needHideTbItems.toArray(new String[needHideTbItems.size()]));
        }
    }
}

