/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workflow;

import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.ssc.task.workflow.dto.CreditPointDTO;

public class AuditBonusStrategyPlugin
implements IWorkflowPlugin {
    private static final Log log = LogFactory.getLog(AuditBonusStrategyPlugin.class);

    public void notify(AgentExecution execution) {
        String billId = execution.getBusinessKey();
        String billNumber = execution.getEntityNumber();
        log.info(String.format("AuditBonusStrategyPlugin start execution ,billId:%s ,billNumber:%s", billId, billNumber));
        String billNo = ((ExecutionEntityImpl)execution).getBillNo();
        Long creatorId = ((ExecutionEntityImpl)execution).getCreatorId();
        CreditPointDTO dto = new CreditPointDTO(billId, billNumber, creatorId);
        try {
            dto.setBillNo(billNo);
        }
        catch (Exception e) {
            log.warn(String.format("AuditBonusStrategyPlugin occur an error, param: %s, msg: %s", dto, e));
        }
        Long userIdByAppObj = (Long)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"getCreditArgAppObj", (Object[])new Object[]{dto.getBillNumber(), dto.getBillId()});
        Optional.ofNullable(userIdByAppObj).ifPresent(id -> dto.setUserId((long)id));
        if (dto.getUserId() == -1L) {
            log.error(String.format("notify error, billType:{%s}, billNo:{%s}", dto.getBillNumber(), dto.getBillNo()));
            return;
        }
        String creditPointDTOStr = SerializationUtils.toJsonString((Object)dto);
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"fircm", (String)"ICreditService", (String)"directCreditPoints", (Object[])new Object[]{creditPointDTOStr});
    }
}

