/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.imic.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListFilterParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;

public class OpenPageUtil {
    private static final Log logger = LogFactory.getLog(OpenPageUtil.class);
    private static final String LIST_SHOW_PARAMETER = "ListShowParameter";
    private static final String FORM_SHOW_PARAMETER = "FormShowParameter";
    private static final String BASE_FORM_MODEL = "BaseFormModel";
    private static final String BILL_FORM_MODEL = "BillFormModel";
    private static final String MODAL = "Modal";
    private static final String REPORT_SHOW_PARAMETER = "ReportShowParameter";
    private static final String REPORT_FORM_MODEL = "ReportFormModel";
    private static final String BASE_SHOW_PARAMETER = "BaseShowParameter";
    private static final String BILL_SHOW_PARAMETER = "BillShowParameter";
    private static final String BILL_FORM_ID = "billFormId";
    private static final String FORM_NUMBER = "formnumber";

    private OpenPageUtil() {
    }

    public static void openConfigPage(String appId, Map<String, Object> params) {
        IFormView view = (IFormView)params.get("view");
        if (appId != null && view != null) {
            String formNumber = (String)params.get(FORM_NUMBER);
            if (StringUtils.isBlank((CharSequence)formNumber)) {
                logger.info("OpenPageUtil--------formnumber is null");
                return;
            }
            String parameterType = OpenPageUtil.getParameterType(params);
            Map parameter = (Map)params.get("parameter");
            IFormView mainPageView = OpenPageUtil.getMainPageView(view);
            IFormView appPageView = mainPageView.getViewNoPlugin(appId + mainPageView.getPageId());
            if (appPageView != null) {
                if (appPageView.getPageId().equalsIgnoreCase(view.getPageId())) {
                    appPageView = view;
                }
                String openType = (String)params.get("opentype");
                FormShowParameter fsp = OpenPageUtil.createFormShowParameter(formNumber, parameterType, parameter, openType);
                fsp.setAppId(appId);
                Map customParams = (Map)params.get("customparameters");
                if (customParams != null) {
                    fsp.setCustomParams(customParams);
                }
                fsp.setCustomParam("appid", (Object)appId);
                fsp.setPageId(formNumber + "_" + kd.bos.login.utils.StringUtils.randomNumber((int)16) + mainPageView.getPageId());
                if (view.getPageId().equals(appPageView.getPageId())) {
                    view.showForm(fsp);
                } else {
                    appPageView.showForm(fsp);
                    view.sendFormAction(appPageView);
                }
            }
        } else {
            logger.info("OpenPageUtil----appID or parameter in map is error");
        }
    }

    private static String getParameterType(Map<String, Object> params) {
        String formNumber;
        String formId;
        FormMetadata formMetadata;
        String modelType;
        String parameterType = "";
        Object objParamType = params.get("parametertype");
        parameterType = StringUtils.isBlank((Object)objParamType) ? (StringUtils.equals((CharSequence)(modelType = (formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)(formId = MetadataDao.getIdByNumber((String)(formNumber = (String)params.get(FORM_NUMBER)), (MetaCategory)MetaCategory.Form)), (MetaCategory)MetaCategory.Form)).getModelType()), (CharSequence)BASE_FORM_MODEL) || StringUtils.equals((CharSequence)modelType, (CharSequence)BILL_FORM_MODEL) ? LIST_SHOW_PARAMETER : (REPORT_FORM_MODEL.equals(modelType) ? REPORT_SHOW_PARAMETER : FORM_SHOW_PARAMETER)) : objParamType.toString();
        return parameterType;
    }

    private static IFormView getMainPageView(IFormView myAppView) {
        String rootPageId;
        IFormView mainPageView = myAppView.getMainView();
        if (mainPageView == null && (mainPageView = myAppView.getView(rootPageId = myAppView.getFormShowParameter().getRootPageId())) == null) {
            throw new KDException(new ErrorCode("mainView is null", "mainView is null"), new Object[0]);
        }
        return mainPageView;
    }

    private static FormShowParameter createFormShowParameter(String formId, String parameterType, Map<String, Object> parameter, String openType) {
        if (parameter != null) {
            if (parameterType.equalsIgnoreCase(LIST_SHOW_PARAMETER)) {
                OpenPageUtil.setListParam(formId, parameter);
            } else {
                parameter.putIfAbsent("formId", formId);
            }
        } else {
            parameter = new HashMap<String, Object>(8);
        }
        Object status = parameter.remove("status");
        if (status != null) {
            parameter.put("Status", status);
        }
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        OpenPageUtil.setParameterValue(sp, parameter);
        OpenPageUtil.setOpenType(sp, parameter, openType);
        sp.setCustomParams(parameter);
        return sp;
    }

    private static void setListParam(String formId, Map<String, Object> parameter) {
        parameter.put("type", "list");
        String entityId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        if (!"empty".equalsIgnoreCase(entityId)) {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityId);
            String billFormId = (String)parameter.get(BILL_FORM_ID);
            if (dt instanceof BillEntityType && StringUtils.isBlank((CharSequence)billFormId)) {
                parameter.put(BILL_FORM_ID, formId);
            }
            String filterConditionStr = (String)parameter.get("filtercondition");
            FilterCondition filterCondition = null;
            if (StringUtils.isNotBlank((CharSequence)filterConditionStr)) {
                filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class);
            }
            if (filterCondition != null) {
                FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition);
                filterBuilder.buildFilter();
                ListFilterParameter listFilterParameter = new ListFilterParameter();
                listFilterParameter.setFilter(filterBuilder.getQFilter());
                parameter.put("listFilterParameter", listFilterParameter);
            }
        }
    }

    private static void setOpenType(FormShowParameter sp, Map<String, Object> parameter, String openType) {
        String isModal = (String)parameter.get("isModal");
        if ("1".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.Modal);
            sp.setShowTitle(false);
        } else if ("0".equals(isModal)) {
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey("_submaintab_");
        } else if (MODAL.equals(openType)) {
            sp.getOpenStyle().setShowType(ShowType.Modal);
        } else {
            sp.getOpenStyle().setShowType(ShowType.NewTabPage);
            sp.getOpenStyle().setTargetKey("_submaintab_");
        }
    }

    private static void setParameterValue(FormShowParameter showParameter, Map<String, Object> params) {
        if (params != null) {
            Class<?> clazz = showParameter.getClass();
            try {
                OpenPageUtil.exeClass(showParameter, params, clazz);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private static void exeClass(FormShowParameter showParameter, Map<String, Object> params, Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (clazz == Object.class) {
            return;
        }
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            String paramName = field.getName();
            String type = field.getGenericType().getTypeName();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String paramValue;
                String pName = entry.getKey();
                if (!paramName.equalsIgnoreCase(pName)) continue;
                if (pName.equalsIgnoreCase("status")) {
                    OpenPageUtil.setStatusField(showParameter, field, entry);
                    continue block0;
                }
                if (pName.equalsIgnoreCase("listFilterParameter")) {
                    paramValue = (String)params.get(pName);
                    OpenPageUtil.setListFilterParameterField(showParameter, field, paramValue);
                    continue block0;
                }
                paramValue = "";
                if (params.get(pName) instanceof LinkedHashMap) {
                    LinkedHashMap paramLinkedHashMap = (LinkedHashMap)params.get(pName);
                    LocaleString captionName = LocaleString.fromMap((Map)paramLinkedHashMap);
                    paramValue = captionName.getLocaleValue();
                } else if (params.get(pName) instanceof String) {
                    paramValue = (String)params.get(pName);
                }
                OpenPageUtil.setOtherField(showParameter, field, type, paramValue);
                continue block0;
            }
        }
        Class<?> clazzs = clazz.getSuperclass();
        OpenPageUtil.exeClass(showParameter, params, clazzs);
    }

    private static void setOtherField(FormShowParameter showParameter, Field field, String type, String paramValue) throws IllegalAccessException {
        if (type.endsWith("Object")) {
            field.set(showParameter, paramValue);
        } else if (type.endsWith("String")) {
            field.set(showParameter, paramValue);
        } else if (type.endsWith("int") || type.endsWith("Integer")) {
            field.set(showParameter, Integer.parseInt(paramValue));
        } else if (type.endsWith("double") || type.endsWith("Double")) {
            field.set(showParameter, Double.parseDouble(paramValue));
        } else if (type.endsWith("boolean") || type.endsWith("Boolean")) {
            field.set(showParameter, Boolean.parseBoolean(paramValue));
        } else if (type.endsWith("float") || type.endsWith("Float")) {
            field.set(showParameter, Float.valueOf(Float.parseFloat(paramValue)));
        } else if (type.endsWith("short") || type.endsWith("Short")) {
            field.set(showParameter, Short.parseShort(paramValue));
        } else if (type.endsWith("long") || type.endsWith("Long")) {
            field.set(showParameter, Long.parseLong(paramValue));
        } else if (type.endsWith("byte") || type.endsWith("Byte")) {
            field.set(showParameter, Byte.parseByte(paramValue));
        } else if (type.endsWith("Map<java.lang.String, java.lang.Object>")) {
            field.set(showParameter, SerializationUtils.fromJsonString((String)paramValue, Map.class));
        }
    }

    private static void setListFilterParameterField(FormShowParameter showParameter, Field field, String paramValue) throws IllegalAccessException {
        ListFilterParameter filterParameter = new ListFilterParameter();
        filterParameter.setFilter(QFilter.fromSerializedString((String)paramValue));
        field.set(showParameter, filterParameter);
    }

    private static void setStatusField(FormShowParameter showParameter, Field field, Map.Entry<String, Object> entry) throws IllegalAccessException {
        int paramValue = Integer.parseInt((String)entry.getValue());
        field.set(showParameter, OperationStatus.forValue((int)paramValue));
    }
}

