/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.VoucherOperateionSubsequentProcess;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahDeleteVoucherRequestTask;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;

public class NewVoucherUtils {
    public static final String SOURCE_OF_BILL = "source_of_bill";
    private static Log logger = LogFactory.getLog(NewVoucherUtils.class);

    public static void voucherDeleteDataCollect(FahDeleteVoucherRequestTask requestTask) {
        if (requestTask.getBillIds().isEmpty() || StringUtils.isBlank(requestTask.getBillType())) {
            return;
        }
        if ("ai_event".equals(requestTask.getBillType())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(requestTask.getBillIds());
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                List<Long> subIdList = billTypeGroup.getValue();
                String aiEventBillType = billTypeGroup.getKey();
                NewVoucherUtils.queryVoucherData(subIdList, aiEventBillType, requestTask.getVoucherAndBillIdMap_dap(), requestTask.getVoucherAndBillIdMap_event());
            }
        } else {
            NewVoucherUtils.queryVoucherData(requestTask.getBillIds(), requestTask.getBillType(), requestTask.getVoucherAndBillIdMap_dap(), requestTask.getVoucherAndBillIdMap_event());
        }
    }

    private static void queryVoucherData(List<Long> billIds, String billType, Map<Long, List<Long>> voucherAndBillIdMap_dap, Map<Long, List<Long>> voucherAndBillIdMap_event) {
        if (billIds.isEmpty() || StringUtils.isBlank(billType)) {
            return;
        }
        SqlBuilder sql_dap = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sql_dap.append("select fsourcebillid,fvoucherid from t_ai_daptracker where fbilltype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsourcebillid", billIds.toArray());
        try (DataSet queryDataSet_dap = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql_dap);){
            for (Row row : queryDataSet_dap) {
                Long fsourcebillid = row.getLong("fsourcebillid");
                Long fvoucherid = row.getLong("fvoucherid");
                voucherAndBillIdMap_dap.computeIfAbsent(fvoucherid, v -> new ArrayList()).add(fsourcebillid);
            }
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgl_header_id,fsrc_billid from t_fah_evt_tracker where fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and fstatus = ? ", new Object[]{"4"}).appendIn("and fsrc_billid", billIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                Long fglHeaderId = row.getLong("fgl_header_id");
                Long fsrcBillid = row.getLong("fsrc_billid");
                voucherAndBillIdMap_event.computeIfAbsent(fglHeaderId, v -> new ArrayList()).add(fsrcBillid);
            }
        }
    }

    public static List<OperateErrorInfo> deleteVoucherOperation(Map<Long, List<Long>> voucherAndBillIdMap_dap, Map<Long, List<Long>> voucherAndBillIdMap_event) {
        ArrayList<OperateErrorInfo> result = new ArrayList<OperateErrorInfo>();
        if (voucherAndBillIdMap_dap.isEmpty() && voucherAndBillIdMap_event.isEmpty()) {
            return result;
        }
        ArrayList<Long> directDelete = new ArrayList<Long>();
        ArrayList<List<Long>> groupDelete = new ArrayList<List<Long>>();
        if (!voucherAndBillIdMap_dap.isEmpty()) {
            directDelete.addAll(voucherAndBillIdMap_dap.keySet());
        }
        if (!voucherAndBillIdMap_event.isEmpty()) {
            directDelete.addAll(NewVoucherUtils.repeatArrangeAlgorithm(voucherAndBillIdMap_event, groupDelete));
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("mechanism", "true");
        op.setVariableValue("ishasright", String.valueOf(true));
        op.setVariableValue(SOURCE_OF_BILL, String.valueOf(true));
        Long voucherId = 0L;
        voucherId = !directDelete.isEmpty() ? (Long)directDelete.get(0) : (Long)((List)groupDelete.get(0)).get(0);
        String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{voucherId});
        if (!directDelete.isEmpty()) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])directDelete.toArray(), (OperateOption)op);
            VoucherOperateionSubsequentProcess.deleteVoucherSSP(operationResult.getSuccessPkIds().stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toList()));
            if (operationResult != null) {
                for (IOperateInfo error : operationResult.getAllErrorOrValidateInfo()) {
                    OperateInfo operror = (OperateInfo)error;
                    Long pkValue = (Long)operror.getPkValue();
                    List<Long> billids = voucherAndBillIdMap_dap.containsKey(pkValue) ? voucherAndBillIdMap_dap.get(pkValue) : voucherAndBillIdMap_event.get(pkValue);
                    for (Long id : billids) {
                        OperateErrorInfo errorInfo = new OperateErrorInfo();
                        errorInfo.setLevel(ErrorLevel.Error);
                        errorInfo.setMessage(operror.getMessage());
                        errorInfo.setPkValue((Object)id);
                        errorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"DeleteVoucherService_4", (String)"bos-ext-fi", (Object[])new Object[0]));
                        result.add(errorInfo);
                    }
                }
            }
        }
        if (!groupDelete.isEmpty()) {
            for (List list : groupDelete) {
                TXHandle h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])list.toArray(), (OperateOption)op);
                        VoucherOperateionSubsequentProcess.deleteVoucherSSP(operationResult.getSuccessPkIds().stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toList()));
                        if (operationResult.isSuccess()) continue;
                        h.markRollback();
                        ArrayList relatVoucher = new ArrayList(list);
                        for (IOperateInfo error : operationResult.getAllErrorOrValidateInfo()) {
                            OperateInfo operror = (OperateInfo)error;
                            Long pkValue = (Long)operror.getPkValue();
                            relatVoucher.remove(pkValue);
                            List<Long> billids = voucherAndBillIdMap_event.get(pkValue);
                            for (Long id : billids) {
                                OperateErrorInfo errorInfo = new OperateErrorInfo();
                                errorInfo.setLevel(ErrorLevel.Error);
                                errorInfo.setMessage(operror.getMessage());
                                errorInfo.setPkValue((Object)id);
                                errorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"DeleteVoucherService_4", (String)"bos-ext-fi", (Object[])new Object[0]));
                                result.add(errorInfo);
                            }
                        }
                        if (relatVoucher.isEmpty()) continue;
                        for (Long vid : relatVoucher) {
                            List<Long> billids = voucherAndBillIdMap_event.get(vid);
                            for (Long id : billids) {
                                OperateErrorInfo errorInfo = new OperateErrorInfo();
                                errorInfo.setLevel(ErrorLevel.Error);
                                errorInfo.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u5220\u9664\u5931\u8d25\u7684\u51ed\u8bc1\uff0c\u5f53\u524d\u51ed\u8bc1\u65e0\u6cd5\u5220\u9664\u3002", (String)"NewVoucherUtils_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                                errorInfo.setPkValue((Object)id);
                                errorInfo.setTitle(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"DeleteVoucherService_4", (String)"bos-ext-fi", (Object[])new Object[0]));
                                result.add(errorInfo);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.info("--NewVoucherUtils--executeOperate--Exception:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
        }
        return result;
    }

    private static List<Long> repeatArrangeAlgorithm(Map<Long, List<Long>> voucherAndBillIdMap_event, List<List<Long>> groupDelete) {
        ArrayList<Long> result = new ArrayList<Long>();
        HashMap billAndVoucherMap = new HashMap();
        voucherAndBillIdMap_event.entrySet().forEach(data -> ((List)data.getValue()).forEach(f -> billAndVoucherMap.computeIfAbsent(f, v -> new ArrayList()).add(data.getKey())));
        ArrayList repeatVoucher = new ArrayList();
        billAndVoucherMap.entrySet().forEach(data -> {
            if (((List)data.getValue()).size() > 1) {
                repeatVoucher.addAll((Collection)data.getValue());
            }
        });
        if (repeatVoucher.isEmpty()) {
            result.addAll(voucherAndBillIdMap_event.keySet());
            return result;
        }
        for (Long voucherId : repeatVoucher) {
            if (groupDelete.stream().anyMatch(mat -> mat.contains(voucherId))) continue;
            HashSet<Long> currVoucherGroup = new HashSet<Long>();
            currVoucherGroup.add(voucherId);
            ArrayList<Long> hasCalculateBill = new ArrayList<Long>();
            ArrayList<Long> newBill = new ArrayList<Long>();
            List<Long> bills = voucherAndBillIdMap_event.get(voucherId);
            newBill.addAll(bills);
            while (!newBill.isEmpty()) {
                for (Long bill : newBill) {
                    hasCalculateBill.add(bill);
                    currVoucherGroup.addAll((Collection)billAndVoucherMap.get(bill));
                }
                newBill.clear();
                for (Long currVoucherId : currVoucherGroup) {
                    ArrayList newBills = new ArrayList(voucherAndBillIdMap_event.get(currVoucherId));
                    newBills.removeAll(hasCalculateBill);
                    newBill.addAll(newBills);
                }
            }
            groupDelete.add(currVoucherGroup.stream().collect(Collectors.toList()));
        }
        for (Long data2 : voucherAndBillIdMap_event.keySet()) {
            if (groupDelete.stream().anyMatch(mat -> mat.contains(data2))) continue;
            result.add(data2);
        }
        return result;
    }
}

