/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class TraceVoucher
extends FormOperate {
    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u5e76\u751f\u6210\u51ed\u8bc1\u3002", (String)"TraceVoucher_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected OperationResult invokeOperation() {
        Set<Object> billIds = this.getSelectedBillIds();
        if (billIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"TraceVoucher_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        Set<Object> vchIdsSet = new HashSet(billIds.size());
        if ("ai_event".equals(this.getEntityId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds.stream().map(e -> (Long)e).collect(Collectors.toList()));
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String billType = billTypeGroup.getKey();
                List<Long> subIds = billTypeGroup.getValue();
                Set<Long> vchIds = DapVoucherUtil.getBuildData(subIds.stream().map(e -> e).collect(Collectors.toList()), billType);
                vchIdsSet.addAll(vchIds);
            }
        } else {
            vchIdsSet = DapVoucherUtil.getBuildData(billIds, this.getEntityId());
        }
        if (vchIdsSet.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u5173\u8054\u7684\u51ed\u8bc1\u3002", (String)"TraceVoucher_4", (String)"bos-ext-fi", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return null;
        }
        String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{vchIdsSet.iterator().next()});
        this.showGlVoucher(entity, vchIdsSet);
        return null;
    }

    private void showGlVoucher(String entity, Set<Long> voucherids) {
        if (voucherids.size() == 1) {
            long billId = voucherids.iterator().next();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)billId);
            showParameter.setFormId(entity);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long orgId = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)entity, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
                for (Row row : ds) {
                    orgId = row.getLong("org");
                }
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)entity, (String)"4715a0df000000ac");
            Boolean isbizvoucher = DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam(orgId);
            if (!(i != 1 || isbizvoucher.booleanValue() && "gl_voucher".equals(entity))) {
                showParameter.setStatus(OperationStatus.EDIT);
            } else {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            showParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Long pkid : voucherids) {
                showParameter.addLinkQueryPkId((Object)pkid);
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void showSubledger(String entity, Set<Long> voucherIds) {
        if (voucherIds.size() == 1) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(entity);
            showParameter.setPkId((Object)voucherIds.iterator().next());
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            voucherIds.forEach(arg_0 -> ((ListShowParameter)showParameter).addLinkQueryPkId(arg_0));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected Set<Object> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Object> billIds = new HashSet<Object>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }
}

