/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.BookdateReconds;
import kd.bos.ext.fi.ai.BookdateRecondsParam;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.ext.fi.entity.property.BookdateProp;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.kdtx.sdk.session.DtxFactory;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransBookdateService
extends EntityOperateService {
    private static Log logger = LogFactory.getLog(TransBookdateService.class);
    private String billType;
    private DBRoute route;
    private String tableName;
    private String bookdate;
    private static String BILLSTATUS = "billstatus";

    protected void preparePropertys(List<String> fieldKeys) {
        this.billType = this.billEntityType.getName();
        this.route = DBRoute.of((String)this.billEntityType.getDBRouteKey());
        this.tableName = this.billEntityType.getAlias();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.billType);
        DataEntityPropertyCollection propertys = mainEntityType.getProperties();
        for (IDataEntityProperty property : propertys) {
            if (!(property instanceof BookdateProp)) continue;
            this.bookdate = property.getName();
            fieldKeys.add(this.bookdate);
        }
        fieldKeys.add(BILLSTATUS);
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        validators.add(new AbstractValidator(){

            public void validate() {
                HashSet listinTx;
                ExtendedDataEntity[] entities = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(entities);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                ArrayList<String> ids = new ArrayList<String>(pkIds.size());
                HashSet<Long> inDap = new HashSet<Long>(DapVoucherUtil.getBuildedBill(pkIds, TransBookdateService.this.billType));
                HashSet<Long> inDapn = new HashSet<Long>(DapVoucherUtil.getNogenVch(TransBookdateService.this.route, pkIds, TransBookdateService.this.tableName));
                for (ExtendedDataEntity entity : entities) {
                    if (StringUtils.isBlank((CharSequence)TransBookdateService.this.bookdate)) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u8bb0\u8d26\u65e5\u671f\u7c7b\u578b\u5b57\u6bb5\uff0c\u4e0d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_1", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    } else if (StringUtils.isBlank((CharSequence)entity.getDataEntity().getString(TransBookdateService.this.bookdate))) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u8bb0\u8d26\u65e5\u671f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_6", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    String status = entity.getDataEntity().getString(BILLSTATUS);
                    Long tempId = (Long)entity.getBillPkId();
                    if (status.compareTo("C") < 0) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u72b6\u6001\u4e4b\u540e\u7684\u5355\u636e\u624d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_2", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    } else if (inDap.contains(tempId)) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_3", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    } else if (inDapn.contains(tempId)) {
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u8bbe\u7f6e\u4e0d\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_4", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                    ids.add(tempId.toString());
                }
                if (!pkIds.isEmpty() && (listinTx = new HashSet(TxCheckUtil.loadUnfinishedTx((String)"transbookdate", ids))) != null && listinTx.size() > 0) {
                    for (ExtendedDataEntity entity : this.dataEntities) {
                        DynamicObject v = entity.getDataEntity();
                        if (!listinTx.contains(v.getString("id"))) continue;
                        this.addMessage(entity, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u8fd8\u5728\u5206\u5e03\u5f0f\u4e2d\uff0c\u4e0d\u80fd\u6267\u884c\u8f6c\u5165\u4e0b\u6708\u64cd\u4f5c\u3002", (String)"TransBookdateService_5", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                }
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
        HashMap<Long, BookdateReconds> mapReconds = new HashMap<Long, BookdateReconds>(dataEntities.length);
        ArrayList<Long> sourcebillids = new ArrayList<Long>(dataEntities.length);
        ArrayList<String> sourebillidStrings = new ArrayList<String>(dataEntities.length);
        for (DynamicObject dataEntitie : dataEntities) {
            sourcebillids.add(dataEntitie.getLong("id"));
            sourebillidStrings.add(dataEntitie.getString("id"));
        }
        List<HashMap<String, Object>> indexLists = DapVoucherUtil.getBookdateReconds(sourcebillids, this.billType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            for (int i = 0; i < dataEntities.length; ++i) {
                Long id = dataEntities[i].getLong("id");
                BookdateReconds reconds = new BookdateReconds();
                reconds.setBillno(id);
                reconds.setSourcebillid(id);
                reconds.setBilltype(this.billType);
                reconds.setOldbookdate(sdf.parse(dataEntities[i].getString(this.bookdate)));
                Date newDate = DateUtils.getFirstDayOfNextMonth(dataEntities[i].getString(this.bookdate), "yyyy-MM-dd");
                reconds.setBookdate(newDate);
                dataEntities[i].set(this.bookdate, (Object)newDate);
                boolean flag = true;
                for (HashMap<String, Object> map : indexLists) {
                    if (id.equals(map.get("sourcebillid"))) {
                        reconds.setIndex((Integer)map.get("index") + 1);
                        flag = false;
                    }
                    if (flag) continue;
                    break;
                }
                if (flag) {
                    reconds.setIndex(1);
                }
                mapReconds.put(id, reconds);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ECSession ecSession = DtxFactory.createEC((String)"trans_bookdate");
        ecSession.setDbRoute(DBRoute.of((String)"fi"));
        try (TXHandle h = TX.requiresNew();){
            try {
                ecSession.setBusinessType("transbookdate");
                ecSession.setBusinessInfo(sourebillidStrings);
                ecSession.begin();
                String cloudId = "fi";
                String appId = "ai";
                BookdateRecondsParam param = new BookdateRecondsParam();
                param.setOperation(VoucherOperation.TransBookdate);
                param.setMap(mapReconds);
                param.setList(sourcebillids);
                ecSession.register(cloudId, appId, "TransbookdateUtilService", (Param)param, null, sourebillidStrings);
                SaveServiceHelper.save((DynamicObject[])dataEntities);
            }
            catch (Throwable e) {
                h.markRollback();
                try {
                    ecSession.rollback();
                }
                catch (Exception exception) {
                    logger.error("tcc rollback error.", (Throwable)exception);
                }
                throw e;
            }
        }
        try {
            ecSession.commit();
        }
        catch (Exception e) {
            logger.error("tcc commit error.", (Throwable)e);
        }
    }
}

