/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.ext.fi.ai.relation.IGetBillRelationShip;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class BOTPRelationShip
implements IGetBillRelationShip {
    @Override
    public Collection<Long> getBillRelation(String sourceEntityName, Long sourceId, String targetEntityName) {
        return this.getBTOPRelation(sourceEntityName, sourceId, targetEntityName, false);
    }

    public Map<String, Set<Long>> getBTOPRelation(String sourceEntityName, Set<Long> sourceIds, String targetEntityName) {
        HashMap<String, Set<Long>> sourceBills = new HashMap<String, Set<Long>>();
        sourceBills.putAll(BFTrackerServiceHelper.findSourceBills((String)sourceEntityName, (Long[])sourceIds.toArray(new Long[0])));
        sourceBills.putAll(BFTrackerServiceHelper.findTargetBills((String)sourceEntityName, (Long[])sourceIds.toArray(new Long[0])));
        Set billids = (Set)sourceBills.get(sourceEntityName);
        if (billids == null) {
            sourceBills.put(sourceEntityName, sourceIds);
        } else {
            billids.removeAll(sourceIds);
        }
        return sourceBills;
    }

    public List<Long> getBTOPRelation(String sourceEntityName, Long sourceId, String targetEntityName, Boolean desc) {
        ArrayList<Long> result = new ArrayList<Long>();
        this.getDirtSourcebills(result, sourceEntityName, sourceId, targetEntityName, desc);
        if (!desc.booleanValue() && !result.isEmpty()) {
            return result;
        }
        this.getDirtTargerbills(result, sourceEntityName, sourceId, targetEntityName, desc);
        if (desc.booleanValue()) {
            Collections.reverse(result);
        }
        return result;
    }

    private void getDirtSourcebills(List<Long> result, String sourceEntityName, Long sourceId, String targetEntityName, Boolean desc) {
        Map findDirtSourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)sourceEntityName, (Long[])new Long[]{sourceId});
        List dirtBills = (List)findDirtSourceBills.get(sourceId);
        if (dirtBills == null || dirtBills.isEmpty()) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityName, (String)targetEntityName);
        Long mainTableId = tableDefine.getTableId();
        for (BFRow db : dirtBills) {
            BFRowId sbf = db.getSId();
            Long sbfmainTableId = sbf.getMainTableId();
            if (mainTableId.equals(sbfmainTableId)) {
                result.add(sbf.getBillId());
                if (!desc.booleanValue()) {
                    return;
                }
            }
            sourceId = sbf.getBillId();
            TableDefine loadTableDefine = EntityMetadataCache.loadTableDefine((Long)sbf.getTableId());
            String entityNumber = loadTableDefine.getEntityNumber();
            this.getDirtSourcebills(result, entityNumber, sourceId, targetEntityName, desc);
        }
    }

    private void getDirtTargerbills(List<Long> result, String sourceEntityName, Long sourceId, String targetEntityName, Boolean desc) {
        Map findDirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)sourceEntityName, (Long[])new Long[]{sourceId});
        List dirtBills = (List)findDirtTargetBills.get(sourceId);
        if (dirtBills == null || dirtBills.isEmpty()) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityName, (String)targetEntityName);
        Long mainTableId = tableDefine.getTableId();
        for (BFRow db : dirtBills) {
            BFRowId bf = db.getId();
            Long bfmainTableId = bf.getMainTableId();
            if (mainTableId.equals(bfmainTableId)) {
                result.add(bf.getBillId());
                if (!desc.booleanValue()) {
                    return;
                }
            }
            sourceId = bf.getBillId();
            TableDefine loadTableDefine = EntityMetadataCache.loadTableDefine((Long)bf.getTableId());
            String entityNumber = loadTableDefine.getEntityNumber();
            this.getDirtTargerbills(result, entityNumber, sourceId, targetEntityName, desc);
        }
    }

    @Override
    public Map<Object, Collection<Long>> getBillRelation(String sourceEntityName, Collection<Object> sourceIds, String targetEntityName) {
        HashMap<Long, String> typeCache = new HashMap<Long, String>();
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityName, (String)targetEntityName);
        Long mainTableId = tableDefine.getTableId();
        typeCache.put(mainTableId, targetEntityName);
        ArrayList<Long> bills = new ArrayList<Long>(100);
        for (Object sourceId : sourceIds) {
            bills.add(Long.parseLong(sourceId + ""));
        }
        Map billLinkUpNodes = BFTrackerServiceHelper.loadBillLinkUpNodes((String)sourceEntityName, (Long[])bills.toArray(new Long[0]), (boolean)false);
        HashMap<Object, Collection<Long>> map = new HashMap<Object, Collection<Long>>(100);
        for (Map.Entry entry : billLinkUpNodes.entrySet()) {
            Object key = entry.getKey();
            ArrayList<Long> list = new ArrayList<Long>();
            BFRowLinkUpNode bfRowLinkUpNode = (BFRowLinkUpNode)entry.getValue();
            this.getListValue(list, typeCache, bfRowLinkUpNode, targetEntityName, mainTableId);
            if (map.containsKey(key)) {
                ((Collection)map.get(key)).addAll(list);
                continue;
            }
            map.put(key, list);
        }
        Map BillLinkDownNodes = BFTrackerServiceHelper.loadBillLinkDownNodes((String)sourceEntityName, (Long[])bills.toArray(new Long[0]), (boolean)false);
        for (Map.Entry entry : BillLinkDownNodes.entrySet()) {
            Object key = entry.getKey();
            ArrayList<Long> list = new ArrayList<Long>();
            BFRowLinkDownNode bfRowLinkUpNode = (BFRowLinkDownNode)entry.getValue();
            this.getListValue(list, typeCache, bfRowLinkUpNode, targetEntityName, mainTableId);
            if (map.containsKey(key)) {
                ((Collection)map.get(key)).addAll(list);
                continue;
            }
            map.put(key, list);
        }
        return map;
    }

    private void getListValue(List<Long> list, Map<Long, String> typeCache, BFRowLinkUpNode bfRowLinkUpNode, String targetEntityName, Long mainTableId) {
        Map sNodes = bfRowLinkUpNode.getSNodes();
        for (BFRowLinkUpNode bFRowLinkUpNode : sNodes.values()) {
            if (bFRowLinkUpNode.getRowId().getMainTableId().equals(mainTableId)) {
                list.add(bFRowLinkUpNode.getRowId().getBillId());
                return;
            }
            this.getListValue(list, typeCache, bFRowLinkUpNode, targetEntityName, mainTableId);
        }
    }

    private void getListValue(List<Long> list, Map<Long, String> typeCache, BFRowLinkDownNode bfRowLinkUpNode, String targetEntityName, Long mainTableId) {
        Map sNodes = bfRowLinkUpNode.getTNodes();
        for (BFRowLinkDownNode bFRowLinkUpNode : sNodes.values()) {
            if (bFRowLinkUpNode.getRowId().getMainTableId().equals(mainTableId)) {
                list.add(bFRowLinkUpNode.getRowId().getBillId());
                return;
            }
            this.getListValue(list, typeCache, bFRowLinkUpNode, targetEntityName, mainTableId);
        }
    }
}

