/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operate;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class TraceAcctJournalEntry
extends FormOperate {
    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u5e76\u751f\u6210\u5b50\u5206\u7c7b\u8d26\uff01", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected OperationResult invokeOperation() {
        Set<Object> billIds = this.getSelectedBillIds();
        if (billIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8054\u67e5\u7684\u6570\u636e", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        Set<Object> voucherids = new HashSet(billIds.size());
        if ("ai_event".equals(this.getEntityId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds.stream().map(e -> (Long)e).collect(Collectors.toList()));
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String string = billTypeGroup.getKey();
                List<Long> subIds = billTypeGroup.getValue();
                Set<Long> subVoucherIds = DapVoucherUtil.getBuildVch(subIds.stream().map(e -> e).collect(Collectors.toList()), string);
                voucherids.addAll(subVoucherIds);
            }
        } else {
            voucherids = DapVoucherUtil.getBuildVch(billIds, this.getEntityId());
        }
        if (voucherids == null || voucherids.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u6ca1\u6709\u5173\u8054\u7684\u5b50\u5206\u7c7b\u8d26\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        String entity = "fah_subledger";
        if (voucherids.size() == 1) {
            long billId = (Long)voucherids.iterator().next();
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId((Object)billId);
            billShowParameter.setFormId(entity);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            long orgId = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceAcctJournalEntry_AcctJournalEntry", (String)entity, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
                for (Row row : ds) {
                    orgId = row.getLong("org");
                }
            }
            long userId = Long.parseLong(RequestContext.get().getUserId());
            int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)entity, (String)"4715a0df000000ac");
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            for (Long l : voucherids) {
                showParameter.addLinkQueryPkId((Object)l);
            }
            showParameter.getCustomParams().put("org", "");
            showParameter.getCustomParams().put("booktype", "");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        return null;
    }

    protected void afterInvokeOperation(OperationResult opResult) {
    }

    protected Set<Object> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Object> billIds = new HashSet<Object>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }
}

