/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.bill;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RelatedBillHelper {
    private static final Log log = LogFactory.getLog(RelatedBillHelper.class);
    private static final String GET_RELATION_SQL = "SELECT FSOURCEBILLMETA,FSOURCEBILLTABLE,FSOURCEBILLCOL,FTARGETBILLMETA,FTARGETBILLTABLE,FTARGETBILLCOL,FISVEHICLE,FTARGETBILLROUTE,FSOURCEMETACOL FROM T_BD_RELATION WHERE FTARGETBILLMETA = '";

    public static Map<String, HashSet<Long>> relatedBill(String entityNumber, HashSet<Long> billIds) {
        HashMap<String, HashSet<Long>> retMap = new HashMap<String, HashSet<Long>>(16);
        DB.query((DBRoute)DBRoute.of((String)"fibd"), (String)(GET_RELATION_SQL + entityNumber + "'"), (Object[])new Object[0], resultSet -> {
            if (!resultSet.next()) return retMap;
            RelatedBillHelper.checkParam(resultSet);
            if ("1".equals(resultSet.getString("fisvehicle"))) {
                StringBuilder sql = new StringBuilder("select ");
                sql.append(resultSet.getString("fsourcemetacol"));
                sql.append(",");
                sql.append(resultSet.getString("fsourcebillcol"));
                sql.append(" from ");
                sql.append(resultSet.getString("fsourcebilltable"));
                sql.append(" where ");
                sql.append(resultSet.getString("ftargetbillcol"));
                sql.append(" in (");
                sql.append(StringUtils.join((Object[])billIds.toArray(), (String)","));
                sql.append(")");
                log.info("search-relaton-sql-1" + sql);
                return (Map)DB.query((DBRoute)DBRoute.of((String)resultSet.getString("ftargetbillroute")), (String)sql.toString(), rs -> {
                    while (rs.next()) {
                        String sourceNumber = rs.getString(resultSet.getString("fsourcemetacol"));
                        Long id = rs.getLong(resultSet.getString("fsourcebillcol"));
                        HashSet upstreams = retMap.computeIfAbsent(sourceNumber, l -> new LinkedHashSet());
                        upstreams.add(id);
                        log.info("search-relaton-sql-get:" + sourceNumber + "," + id);
                    }
                    return retMap;
                });
            }
            if (RelatedBillHelper.isNull(resultSet.getString("ftargetbillmeta")).booleanValue()) throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"ftargetbillmeta"}));
            QFilter qFilter = new QFilter(resultSet.getString("ftargetbillcol"), "in", (Object)billIds.toArray());
            log.info("search-relaton-sql-2" + resultSet.getString("ftargetbillmeta") + "#" + resultSet.getString("fsourcebillcol") + "#" + StringUtils.join((Object[])billIds.toArray(), (String)","));
            String fields = resultSet.getString("fsourcebillcol");
            if (!RelatedBillHelper.isNull(resultSet.getString("fsourcemetacol")).booleanValue()) {
                fields = fields + ",";
                fields = fields + resultSet.getString("fsourcemetacol");
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"query-relation-table", (String)resultSet.getString("ftargetbillmeta"), (String)fields, (QFilter[])new QFilter[]{qFilter}, null);){
                if (ds == null) return retMap;
                while (ds.hasNext()) {
                    Row next = ds.next();
                    String upsreamMeta = RelatedBillHelper.isNull(resultSet.getString("fsourcemetacol")) == false ? next.getString(resultSet.getString("fsourcemetacol")) : resultSet.getString("fsourcebillmeta");
                    HashSet upstreams = retMap.computeIfAbsent(upsreamMeta, l -> new LinkedHashSet());
                    upstreams.add(next.getLong(resultSet.getString("fsourcebillcol")));
                    log.info("search-relaton-sql-get:" + upsreamMeta + "," + next.getLong(resultSet.getString("fsourcebillcol")));
                }
                return retMap;
            }
        });
        return retMap;
    }

    public static Map<String, HashSet<Long>> relatedBill(Map<String, HashSet<Long>> billMap) {
        HashMap<String, HashSet<Long>> retMap = new HashMap<String, HashSet<Long>>(16);
        for (Map.Entry<String, HashSet<Long>> next : billMap.entrySet()) {
            String key = next.getKey();
            HashSet<Long> billSet = next.getValue();
            retMap.putAll(RelatedBillHelper.relatedBill(key, billSet));
        }
        return retMap;
    }

    private static void checkParam(ResultSet resultSet) throws SQLException {
        if (RelatedBillHelper.isNull(resultSet.getString("fisvehicle")).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"fisvehicle"}));
        }
        if (RelatedBillHelper.isNull(resultSet.getString("ftargetbillmeta")).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"ftargetbillmeta"}));
        }
        if (RelatedBillHelper.isNull(resultSet.getString("ftargetbillcol")).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"ftargetbillcol"}));
        }
        if (RelatedBillHelper.isNull(resultSet.getString("fsourcebillcol")).booleanValue()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"fsourcebillcol"}));
        }
        if ("1".equals(resultSet.getString("fisvehicle"))) {
            if (RelatedBillHelper.isNull(resultSet.getString("ftargetbillroute")).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"fsourcemetacol"}));
            }
            if (RelatedBillHelper.isNull(resultSet.getString("fsourcemetacol")).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"fsourcemetacol"}));
            }
            if (RelatedBillHelper.isNull(resultSet.getString("fsourcebilltable")).booleanValue()) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u636e\u5173\u7cfb\u914d\u7f6e%s\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"RelatedBillHelper_1", (String)"bos-ext-fi", (Object[])new Object[]{"fsourcebilltable"}));
            }
        }
    }

    private static Boolean isNull(String value) {
        return value == null || "".equals(value.trim());
    }
}

