/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.bei.util.EmptyUtil;
import kd.bos.ext.fi.botp.enums.AsstActTypeEnum;
import kd.bos.ext.fi.botp.enums.PaymentChannelEnum;
import kd.bos.ext.fi.botp.enums.SettleMentTypeEnum;
import kd.bos.ext.fi.botp.helper.BaseDataHelper;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.botp.helper.CasPayeeOrPayerHelper;
import kd.bos.ext.fi.botp.helper.OrgHelper;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class PaymentBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(PaymentBillConvertPlugin.class);
    private BigDecimal actPayAmtSum = BigDecimal.ZERO;
    private BigDecimal localAmtSum = BigDecimal.ZERO;
    private AtomicBoolean isEmpty = new AtomicBoolean(false);

    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        String sourceEntityNumber = this.getSrcMainType().getName();
        if ("ap_finapbill".equals(sourceEntityNumber) || "ap_payapply".equals(sourceEntityNumber) || "ar_finarbill".equals(sourceEntityNumber) || "sctm_scpo".equals(sourceEntityNumber) || "pm_purorderbill".equals(sourceEntityNumber)) {
            BOTPHelper.checkGroupByModeStrategy(this.getRule());
        }
    }

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        String srcEntityNumber = this.getSrcMainType().getName();
        String tgtEntityNumber = this.getTgtMainType().getName();
        ConvertRuleElement rule = this.getRule();
        if ("cas_payapplybill".equals(srcEntityNumber) && "cas_paybill".equals(tgtEntityNumber) && (rule.getGroupByPolicy().getGroupByMode().getValue() == 0 || BOTPHelper.ruleEntryMergePush(rule))) {
            Set CreditSettletNumberSet;
            List sourceRows = e.getSourceRows();
            Map fldProperties = e.getFldProperties();
            Set settleTypeSet = sourceRows.stream().map(src -> (String)((DynamicProperty)fldProperties.get("entry_settlementtype.settlementtype")).getValue(src)).collect(Collectors.toSet());
            String creditErrorMsg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u660e\u7ec6\u7684\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u6d89\u53ca\u201c\u4fe1\u7528\u8bc1\u5f00\u7acb\u201d\u65f6\uff0c\u4e0d\u540c\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u6216\u4e0d\u540c\u7ed3\u7b97\u53f7\u7684\u6570\u636e\u4e0d\u652f\u6301\u5408\u5e76\u4e0b\u63a8\uff0c\u8bf7\u5206\u6279\u4e0b\u63a8\u3002", (String)"PaymentBillConvertPlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]);
            if (settleTypeSet.size() > 1 && settleTypeSet.contains("16")) {
                throw new KDBizException(creditErrorMsg);
            }
            if (settleTypeSet.contains("16") && (CreditSettletNumberSet = sourceRows.stream().map(s -> (String)((DynamicProperty)fldProperties.get("entry_settletnumber")).getValue(s)).collect(Collectors.toSet())).size() > 1) {
                throw new KDBizException(creditErrorMsg);
            }
        }
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        String srcEntityName = this.getSrcMainType().getName();
        if (!"ap_finapbill".equals(srcEntityName) && !"ap_payapply".equals(srcEntityName)) {
            return;
        }
        List filters = e.getQFilters();
        HashSet<Long> entryIds = new HashSet<Long>(2);
        for (QFilter filter : filters) {
            Set billIds = (Set)filter.getValue();
            String entityKey = "ap_finapbill".equals(srcEntityName) ? "ap_finapbill" : "ap_payapply";
            String entryId = "ap_finapbill".equals(srcEntityName) ? "detailentry.id" : "entry.id";
            String asstactTypeKey = "ap_finapbill".equals(srcEntityName) ? "asstacttype" : "entry.e_asstacttype";
            String asstactKey = "ap_finapbill".equals(srcEntityName) ? "asstact" : "entry.e_asstact";
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityKey, (String)("id," + entryId + "," + asstactTypeKey + "," + asstactKey), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)});
            if (ObjectUtils.isEmpty((Object)bills)) {
                return;
            }
            Set supplierIds = bills.stream().filter(supplier -> "bd_supplier".equals(supplier.get(asstactTypeKey))).map(supplier -> supplier.get(asstactKey)).collect(Collectors.toSet());
            List payHoldSupplierPks = QueryServiceHelper.queryPrimaryKeys((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("payhold", "=", (Object)Boolean.TRUE), new QFilter("id", "in", supplierIds)}, (String)"", (int)-1);
            if (!"id".equals(filter.getProperty())) continue;
            if ("ap_finapbill".equals(srcEntityName)) {
                for (DynamicObject bill : bills) {
                    if (!"bd_supplier".equals(bill.getString(asstactTypeKey)) || !payHoldSupplierPks.contains(bill.getLong(asstactKey))) continue;
                    billIds.remove(bill.getLong("id"));
                }
                filter.__setValue((Object)billIds);
                break;
            }
            for (DynamicObject bill : bills) {
                if ("bd_supplier".equals(bill.getString(asstactTypeKey)) && payHoldSupplierPks.contains(bill.getLong(asstactKey))) continue;
                entryIds.add(bill.getLong(entryId));
            }
        }
        if (!ObjectUtils.isEmpty(entryIds)) {
            filters.add(new QFilter("entry.id", "in", entryIds));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        DynamicObject targetBill;
        logger.info("\u6267\u884c\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406BOTP");
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        String selectProperties = "id,number,type,entry_bank.isdefault_bank,entry_bank.commissionbearer,entry_bank.currency,entry_bank.bankaccount,entry_bank.bank,entry_bank.accountname,entry_address.supplieraddress";
        Map<Long, DynamicObject> supplierIdMap = this.queryDynamicObjectMap(billDataEntitys, AsstActTypeEnum.SUPPLIER.getValue(), selectProperties);
        selectProperties = "id,number,type,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.accountname,entry_address.customeraddress";
        Map<Long, DynamicObject> customerIdMap = this.queryDynamicObjectMap(billDataEntitys, AsstActTypeEnum.CUSTOMER.getValue(), selectProperties);
        Map<Object, Object> payeeDynamicObjects = new HashMap(4);
        if (customerIdMap != null && supplierIdMap != null) {
            customerIdMap.putAll(supplierIdMap);
            payeeDynamicObjects = customerIdMap;
        } else {
            payeeDynamicObjects = customerIdMap == null ? supplierIdMap : customerIdMap;
        }
        HashSet<Object> addressIdSet = new HashSet<Object>(4);
        addressIdSet.addAll(this.getAddressIdSet(supplierIdMap, "supplieraddress"));
        addressIdSet.addAll(this.getAddressIdSet(customerIdMap, "customeraddress"));
        Map<Long, DynamicObject> addressDynamicObject = this.getAddressMap(addressIdSet);
        Map<Long, DynamicObject> currencyIdMap = this.queryCurrencyMap(billDataEntitys);
        Map<Long, DynamicObject> settleTypeIdMap = this.getIdMapDynamicObject(billDataEntitys, "bd_settlementtype", "settletype");
        Map<Long, DynamicObject> paymentTypeMap = this.getIdMapDynamicObject(billDataEntitys, "cas_paymentbilltype", "paymenttype");
        Map<Object, DynamicObject> finApBillMap = this.getFinApBill(billDataEntitys);
        Map<Long, DynamicObject> orgMap = this.getIdMapDynamicObject(billDataEntitys, "bos_org", "org");
        Map<Long, DynamicObject> finOrgInfoMap = this.getIdMapDynamicObject(billDataEntitys, "bd_finorginfo", "payerbank");
        HashMap<Long, Integer> settleParamMap = new HashMap<Long, Integer>(billDataEntitys.length);
        List<DynamicObject> targetBills = Arrays.stream(billDataEntitys).map(o -> o.getDataEntity()).collect(Collectors.toList());
        Map<DynamicObject, DynamicObject> billToCurrency = OrgHelper.batchGetBaseCurrency(targetBills);
        Map<DynamicObject, DynamicObject> billToExrateTable = this.batchGetDefaultExrateTable(targetBills);
        HashSet<Long> payeeIds = new HashSet<Long>(billDataEntitys.length);
        HashMap<Object, DynamicObject> payeeIdMap = new HashMap(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            targetBill = billDataEntity.getDataEntity();
            this.dealSupplePayeeInfo(targetBill, payeeDynamicObjects, addressDynamicObject, payeeIds);
        }
        if (payeeIds.size() > 0) {
            payeeIdMap = BusinessDataServiceHelper.loadFromCache((String)"bd_bebank", (String)"id,name,number,country.name,country.id,country.number,provincetxt,citytxt,union_number,swift_code,routingnum,other_code,address_eng", (QFilter[])new QFilter[]{new QFilter("id", "in", payeeIds)});
        }
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject settleOrg;
            DynamicObjectCollection entry;
            targetBill = billDataEntity.getDataEntity();
            this.supplePayeeInfo(targetBill, payeeDynamicObjects, addressDynamicObject, payeeIdMap);
            DynamicObject org = targetBill.getDynamicObject("org");
            if (org != null) {
                DynamicObject payerAcctBank;
                DynamicObject settletype;
                DynamicObject baseCurrency;
                long orgId = org.getLong("id");
                DynamicObject targetOrg = orgMap.get(orgId);
                if (null != targetOrg) {
                    targetBill.set("uniformsocialcreditcode", (Object)targetOrg.getString("uniformsocialcreditcode"));
                    targetBill.set("payernumber", (Object)targetOrg.getString("number"));
                }
                if ((baseCurrency = billToCurrency.get(targetBill)) == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), CasHelper.getLocalValue(org, "name"));
                    logger.error(msg);
                    throw new KDBizException(msg);
                }
                targetBill.set("basecurrency", (Object)baseCurrency);
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (currency != null && CasHelper.isNotEmpty(currency = currencyIdMap.get(currency.getPkValue()))) {
                    targetBill.set("currency", (Object)currency);
                }
                this.setFeePayerDefaultValue(targetBill, currency, supplierIdMap);
                DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
                if (dpCurrency != null && CasHelper.isNotEmpty(dpCurrency = currencyIdMap.get(dpCurrency.getPkValue()))) {
                    targetBill.set("dpcurrency", (Object)dpCurrency);
                }
                if ((settletype = targetBill.getDynamicObject("settletype")) != null && CasHelper.isNotEmpty(settletype = settleTypeIdMap.get(settletype.getPkValue()))) {
                    targetBill.set("settletype", (Object)settletype);
                }
                if ((payerAcctBank = targetBill.getDynamicObject("payeracctbank")) != null) {
                    payerAcctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)payerAcctBank.getPkValue(), (String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay,openorg,isopenbank,issetbankinterface,isvirtual");
                    boolean isvirtual = payerAcctBank.getBoolean("isvirtual");
                    if (BaseDataHelper.isSettleTypeVirtual(settletype) && !isvirtual) {
                        payerAcctBank = null;
                        targetBill.set("payeracctbank", (Object)payerAcctBank);
                        targetBill.set("payerbank", (Object)payerAcctBank);
                    }
                } else if (settletype == null || !SettleMentTypeEnum.MONEY.getValue().equals(settletype.getString("settlementtype"))) {
                    DynamicObject[] accountBanks;
                    QFilter filter = new QFilter("company", "=", org.getPkValue());
                    QFilter recFilter = new QFilter("isdefaultpay", "=", (Object)true);
                    QFilter statusFilter = new QFilter("acctstatus", "=", (Object)"normal");
                    QFilter currFilter = null;
                    if (CasHelper.isNotEmpty(currency)) {
                        currFilter = new QFilter("currency.fbasedataid.id", "=", currency.getPkValue());
                    }
                    if ((accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id,bankaccountnumber,bank,isdefaultpay,openorg,isopenbank,issetbankinterface,isvirtual", (QFilter[])new QFilter[]{filter, recFilter, statusFilter, currFilter})) != null && accountBanks.length > 0) {
                        boolean isvirtual = accountBanks[0].getBoolean("isvirtual");
                        if (BaseDataHelper.isSettleTypeVirtual(settletype) && isvirtual || !BaseDataHelper.isSettleTypeVirtual(settletype) && !isvirtual) {
                            payerAcctBank = accountBanks[0];
                        }
                    }
                }
                if (CasHelper.isNotEmpty(payerAcctBank)) {
                    targetBill.set("payeracctbank", (Object)payerAcctBank);
                    this.setValueIfAbsent(targetBill, "payerbank", payerAcctBank.getDynamicObject("bank"));
                    this.setValueIfAbsent(targetBill, "openorg", payerAcctBank.getDynamicObject("openorg"));
                    this.setSettleorg(targetBill);
                }
                this.setPayCountryValue(targetBill, finOrgInfoMap);
                if (CasHelper.isEmpty(targetBill.getDynamicObject("exratetable"))) {
                    DynamicObject exrateTable = billToExrateTable.get(targetBill);
                    if (exrateTable != null) {
                        targetBill.set("exratetable", (Object)exrateTable);
                    } else {
                        String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7:%s\uff0c\u8bf7\u5148\u5b8c\u6210\u51fa\u7eb3/\u8d44\u91d1\u7ed3\u7b97\u521d\u59cb\u5316\u8bbe\u7f6e\uff01", (String)"SystemStatusCtrolHelper_2", (String)"fi-cas-common", (Object[])new Object[0]), CasHelper.getLocalValue(org, "name"));
                        logger.error(msg);
                        throw new KDBizException(msg);
                    }
                }
                this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
                BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
                if (CasHelper.isEmpty(exchangeRate)) {
                    exchangeRate = BigDecimal.ONE;
                    String payquotation = "0";
                    if (currency != null && baseCurrency != null) {
                        long destCurrencyId;
                        boolean isCurrencyDifferent;
                        long srcCurrencyId = currency.getLong("id");
                        boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                        if (isCurrencyDifferent) {
                            Date exrateDate = targetBill.getDate("exratedate");
                            DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                            if (CasHelper.isNotEmpty(exrateTable)) {
                                Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                                exchangeRate = (BigDecimal)exchangeRateByTable.getRight();
                                payquotation = (String)exchangeRateByTable.getLeft();
                            }
                        }
                    }
                    targetBill.set("exchangerate", (Object)exchangeRate);
                    targetBill.set("payquotation", (Object)payquotation);
                } else {
                    this.setValueIfAbsent(targetBill, "payquotation", "0");
                }
                if (CasHelper.isEmpty(targetBill.getString("paymentchannel"))) {
                    this.setPaymentChannelValue(targetBill, payerAcctBank);
                }
                this.setDiffPayInfo(targetBill, orgId);
                if (billDataEntitys.length > 1) {
                    this.actPayAmtSum = BigDecimal.ZERO;
                    this.localAmtSum = BigDecimal.ZERO;
                }
                this.calculateAmt(targetBill);
                DynamicObject paymentType = targetBill.getDynamicObject("paymenttype");
                if (paymentType != null) {
                    paymentType = paymentTypeMap.get(paymentType.getPkValue());
                    this.fillFundflowItem(targetBill, paymentType.getDynamicObject("fundflowitem"));
                }
            }
            if ((entry = targetBill.getDynamicObjectCollection("entry")).size() <= 0 || (settleOrg = ((DynamicObject)entry.get(0)).getDynamicObject("settleorg")) == null) continue;
            Long orgPk = settleOrg.getLong("id");
            Integer param = (Integer)settleParamMap.get(orgPk);
            if (param == null) {
                param = PaymentBillConvertPlugin.getApParam(orgPk, "ap_003");
                settleParamMap.put(orgPk, param);
            }
            if (param != 2) continue;
            this.setValueProjectAndContract(targetBill, finApBillMap);
        }
    }

    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
        List extendedDataEntities;
        if (e.getTargetExtDataEntitySet() != null && e.getTargetExtDataEntitySet().getExtDataEntityMap() != null && e.getTargetExtDataEntitySet().getExtDataEntityMap().containsKey("cas_paybill") && (extendedDataEntities = (List)e.getTargetExtDataEntitySet().getExtDataEntityMap().get("cas_paybill")) != null) {
            extendedDataEntities.forEach(extendedDataEntity -> {
                DynamicObject targetBill = extendedDataEntity.getDataEntity();
                if (targetBill.containsProperty("exchangerate")) {
                    targetBill.set("exchangerate", null);
                }
            });
        }
        super.afterCreateTarget(e);
    }

    private Map<Long, DynamicObject> getAcctBankMap(ExtendedDataEntity[] billDataEntitys) {
        Set idSet = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            DynamicObject paymentType = targetBill.getDynamicObject("payeracctbank");
            return this.getPkValue(paymentType);
        }).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", idSet);
        String selectProperty = "id,bankaccountnumber,company,bank,isdefaultpay,openorg,isopenbank,issetbankinterface";
        DynamicObject[] payerAcctBank0 = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectProperty, (QFilter[])new QFilter[]{idFilter});
        Map<Long, DynamicObject> result0 = Arrays.stream(payerAcctBank0).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        Set orgIdSet = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            DynamicObject paymentType = targetBill.getDynamicObject("org");
            return this.getPkValue(paymentType);
        }).collect(Collectors.toSet());
        QFilter filter = new QFilter("company", "in", orgIdSet);
        QFilter recFilter = new QFilter("isdefaultpay", "=", (Object)true);
        QFilter statusFilter = new QFilter("acctstatus", "=", (Object)"normal");
        QFilter idFiler1 = new QFilter("id", "not in", idSet);
        DynamicObject[] accountBanks1 = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)selectProperty, (QFilter[])new QFilter[]{filter, recFilter, statusFilter, idFiler1});
        Map<Long, DynamicObject> result1 = Arrays.stream(accountBanks1).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        result1.putAll(result0);
        return result1;
    }

    private Map<Long, DynamicObject> getIdMapDynamicObject(ExtendedDataEntity[] billDataEntitys, String entityName, String propertyName) {
        Set<Object> idSet = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            DynamicObject paymentType = targetBill.getDynamicObject(propertyName);
            return this.getPkValue(paymentType);
        }).collect(Collectors.toSet());
        DynamicObject[] paymentTypeDO = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Long, DynamicObject> result = Arrays.stream(paymentTypeDO).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        return result;
    }

    private Object getPkValue(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getPkValue();
    }

    private Map<Long, DynamicObject> queryCurrencyMap(ExtendedDataEntity[] billDataEntitys) {
        Set idSet0 = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            DynamicObject currency = targetBill.getDynamicObject("currency");
            return this.getPkValue(currency);
        }).collect(Collectors.toSet());
        Set idSet1 = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            DynamicObject currency = targetBill.getDynamicObject("dpcurrency");
            return this.getPkValue(currency);
        }).collect(Collectors.toSet());
        HashSet idSet = new HashSet(4);
        idSet.addAll(idSet0);
        idSet.addAll(idSet1);
        DynamicObject[] supplierDO = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
        Map<Long, DynamicObject> result = Arrays.stream(supplierDO).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        return result;
    }

    private Map<Long, DynamicObject> getAddressMap(Set<Object> addressIdSet) {
        Map<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(4);
        if (addressIdSet.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", addressIdSet);
            qFilter.and("default", "=", (Object)Boolean.TRUE);
            DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"id,default,detailaddress,addemail", (QFilter[])new QFilter[]{qFilter});
            result = Arrays.stream(addresses).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        }
        return result;
    }

    private Map<Object, DynamicObject> getFinApBill(ExtendedDataEntity[] billDataEntitys) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(4);
        Set collect = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            String sourType = targetBill.getString("sourcebilltype");
            if ("ap_finapbill".equals(sourType)) {
                DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
                Set billIdSet = entry.stream().map(row -> row.getLong("e_sourcebillid")).collect(Collectors.toSet());
                return billIdSet;
            }
            return null;
        }).collect(Collectors.toSet());
        HashSet idSet = new HashSet(4);
        if (collect.size() > 0) {
            for (Set item : collect) {
                if (item == null) continue;
                idSet.addAll(item);
            }
        }
        if (idSet.size() > 0) {
            DynamicObject[] finBills;
            for (DynamicObject finBill : finBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.e_conbillentity,detailentry.e_conbillnumber,detailentry.e_conbillrownum,detailentry.e_conbillid,detailentry.e_conbillentryid,detailentry.e_contract,detailentry.project", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)})) {
                DynamicObjectCollection finEntry = finBill.getDynamicObjectCollection("detailentry");
                if (result.get(finBill.get("id")) != null || finEntry.size() <= 0) continue;
                result.put(finBill.get("id"), (DynamicObject)finEntry.get(0));
            }
        }
        return result;
    }

    private Set<Object> getAddressIdSet(Map<Long, DynamicObject> payeeDynamicObjects, String addressPropName) {
        HashSet<Object> addressIds = new HashSet<Object>();
        for (Map.Entry<Long, DynamicObject> entry : payeeDynamicObjects.entrySet()) {
            DynamicObject obj = entry.getValue();
            DynamicObjectCollection addressls = obj.getDynamicObjectCollection("entry_address");
            for (DynamicObject a : addressls) {
                addressIds.add(a.get(addressPropName + "_id"));
            }
        }
        return addressIds;
    }

    private Map<Long, DynamicObject> queryDynamicObjectMap(ExtendedDataEntity[] billDataEntitys, String entityName, String selectProperties) {
        Set idSet = Arrays.stream(billDataEntitys).map(o -> {
            DynamicObject targetBill = o.getDataEntity();
            Object payeeType = targetBill.get("payeetype");
            Object payee = targetBill.get("payee");
            if (entityName.equalsIgnoreCase(AsstActTypeEnum.SUPPLIER.getValue())) {
                if (CasPayeeOrPayerHelper.isSupplier(payeeType)) {
                    return payee;
                }
                return null;
            }
            if (CasPayeeOrPayerHelper.isCustomer(payeeType)) {
                return payee;
            }
            return null;
        }).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", idSet);
        DynamicObject[] supplierDO = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        Map<Long, DynamicObject> result = Arrays.stream(supplierDO).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        return result;
    }

    private void clearPayeeInfo(DynamicObject targetBill) {
        targetBill.set("payeebanknum", null);
        targetBill.set("payeeaccformid", null);
        targetBill.set("payeeacctbank", null);
        targetBill.set("payeebank", null);
        targetBill.set("payeebankname", null);
        targetBill.set("reccountry", null);
        targetBill.set("recprovince", null);
        targetBill.set("reccity", null);
        targetBill.set("recbanknumber", null);
        targetBill.set("recswiftcode", null);
        targetBill.set("recroutingnum", null);
        targetBill.set("recothercode", null);
        targetBill.set("recbankaddress", null);
    }

    private void setPaymentChannelValue(DynamicObject targetBill, DynamicObject payerAcctBank) {
        String defChannel = "";
        defChannel = payerAcctBank == null ? PaymentChannelEnum.COUNTER.getValue() : (payerAcctBank.getBoolean("issetbankinterface") ? PaymentChannelEnum.BEI.getValue() : (payerAcctBank.getBoolean("isopenbank") ? PaymentChannelEnum.ONLINEBANK.getValue() : PaymentChannelEnum.COUNTER.getValue()));
        targetBill.set("paymentchannel", (Object)defChannel);
    }

    private void setDefaultExratetable(DynamicObject targetBill, Long orgId) {
        DynamicObject exchangeRateTable = null;
        try {
            exchangeRateTable = SystemStatusCtrolHelper.getExrateTable(orgId);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        targetBill.set("exratetable", (Object)exchangeRateTable);
    }

    private Map<DynamicObject, DynamicObject> batchGetDefaultExrateTable(List<DynamicObject> bills) {
        HashMap<DynamicObject, DynamicObject> billToExrateTable = new HashMap<DynamicObject, DynamicObject>(4);
        ArrayList<DynamicObject> newBills = new ArrayList<DynamicObject>(4);
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org != null) {
                newBills.add(bill);
                continue;
            }
            billToExrateTable.put(bill, null);
        }
        Map objToOrgId = newBills.stream().collect(Collectors.toMap(Function.identity(), o -> o.getDynamicObject("org").getLong("id")));
        QFilter qFilterId = new QFilter("org", "in", objToOrgId.values());
        DynamicObject[] cashMgtInits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,exratetable", (QFilter[])qFilterId.toArray());
        Map orgTdToExrateTable = Arrays.stream(cashMgtInits).filter(o -> o.getDynamicObject("org") != null).collect(HashMap::new, (map, item) -> map.put(item.getDynamicObject("org").getLong("id"), item.getDynamicObject("exratetable")), HashMap::putAll);
        for (Map.Entry entry : objToOrgId.entrySet()) {
            Long id = entry.getValue();
            if (orgTdToExrateTable.get(id) == null) {
                billToExrateTable.put((DynamicObject)entry.getKey(), (DynamicObject)null);
                continue;
            }
            billToExrateTable.put((DynamicObject)entry.getKey(), (DynamicObject)orgTdToExrateTable.get(id));
        }
        return billToExrateTable;
    }

    private void setDiffPayInfo(DynamicObject targetBill, Long orgId) {
        targetBill.set("dpexratetable", targetBill.get("exratetable"));
        targetBill.set("dpexratedate", targetBill.get("exratedate"));
        DynamicObject dpCurrency = targetBill.getDynamicObject("dpcurrency");
        if (targetBill.getBoolean("isdiffcur") && CasHelper.isNotEmpty(dpCurrency)) {
            BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
            if (CasHelper.isEmpty(dpExchangeRate)) {
                dpExchangeRate = BigDecimal.ONE;
                String dppayquotation = "0";
                DynamicObject baseCurrency = targetBill.getDynamicObject("basecurrency");
                if (CasHelper.isNotEmpty(baseCurrency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = dpCurrency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("dpexratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("dpexratetable");
                        if (CasHelper.isNotEmpty(exrateTable)) {
                            Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                            dpExchangeRate = (BigDecimal)exchangeRateByTable.getRight();
                            dppayquotation = (String)exchangeRateByTable.getLeft();
                        }
                    }
                }
                targetBill.set("dpexchangerate", (Object)dpExchangeRate);
                targetBill.set("dppayquotation", (Object)dppayquotation);
            }
            this.setValueIfAbsent(targetBill, "dppayquotation", "0");
            BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
            if (CasHelper.isEmpty(agreedRate)) {
                agreedRate = BigDecimal.ONE;
                String agreedquotation = "0";
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (CasHelper.isNotEmpty(currency)) {
                    long destCurrencyId;
                    boolean isCurrencyDifferent;
                    long srcCurrencyId = currency.getLong("id");
                    boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = dpCurrency.getLong("id"));
                    if (isCurrencyDifferent) {
                        Date exrateDate = targetBill.getDate("exratedate");
                        DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                        if (CasHelper.isNotEmpty(exrateTable)) {
                            Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                            agreedRate = (BigDecimal)exchangeRateByTable.getRight();
                            agreedquotation = (String)exchangeRateByTable.getLeft();
                        }
                    }
                }
                targetBill.set("agreedrate", (Object)agreedRate);
                targetBill.set("agreedquotation", (Object)agreedquotation);
            }
            this.setValueIfAbsent(targetBill, "agreedquotation", "0");
        } else {
            targetBill.set("dpcurrency", targetBill.get("currency"));
            targetBill.set("dpexchangerate", targetBill.get("exchangerate"));
            targetBill.set("dppayquotation", targetBill.get("payquotation"));
            targetBill.set("agreedrate", (Object)BigDecimal.ONE);
            this.setValueIfAbsent(targetBill, "agreedquotation", "0");
        }
    }

    private void calculateAmt(DynamicObject targetBill) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        String payquotation = targetBill.getString("payquotation");
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject rowInfo : entry) {
            BigDecimal payAmount = rowInfo.getBigDecimal("e_payableamt");
            BigDecimal payablelocamt = rowInfo.getBigDecimal("e_payablelocamt");
            if (payAmount != null && CasHelper.isEmpty(payablelocamt)) {
                BigDecimal payLocAmt = QuotationHelper.callToCurrency(payAmount, exchangeRate, payquotation, round);
                rowInfo.set("e_payablelocamt", (Object)payLocAmt);
            }
            BigDecimal discountAmt = rowInfo.getBigDecimal("e_discountamt");
            BigDecimal discountlocamt = rowInfo.getBigDecimal("e_discountlocamt");
            if (discountAmt != null && CasHelper.isEmpty(discountlocamt)) {
                BigDecimal disLocAmt = QuotationHelper.callToCurrency(discountAmt, exchangeRate, payquotation, round);
                rowInfo.set("e_discountlocamt", (Object)disLocAmt);
            }
            BigDecimal actAmt = rowInfo.getBigDecimal("e_actamt");
            if (payAmount != null && discountAmt != null && CasHelper.isEmpty(actAmt)) {
                actAmt = payAmount.subtract(discountAmt);
                rowInfo.set("e_actamt", (Object)actAmt);
            }
            actAmt = rowInfo.getBigDecimal("e_actamt");
            sumAmt = sumAmt.add(actAmt);
            BigDecimal actLocalAmt = rowInfo.getBigDecimal("e_localamt");
            if (CasHelper.isEmpty(actLocalAmt)) {
                BigDecimal actLocAmt = QuotationHelper.callToCurrency(actAmt, exchangeRate, payquotation, round);
                rowInfo.set("e_localamt", (Object)actLocAmt);
            }
            actLocalAmt = rowInfo.getBigDecimal("e_localamt");
            sumLocalAmt = sumLocalAmt.add(actLocalAmt);
            rowInfo.set("e_unsettledamt", (Object)payAmount);
            rowInfo.set("e_unlockamt", (Object)payAmount);
        }
        this.actPayAmtSum = this.actPayAmtSum.add(sumAmt);
        this.localAmtSum = this.localAmtSum.add(sumLocalAmt);
        targetBill.set("actpayamt", (Object)this.actPayAmtSum);
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        if (CasHelper.isEmpty(localAmt)) {
            this.isEmpty.compareAndSet(false, true);
        }
        if (this.isEmpty.get()) {
            targetBill.set("localamt", (Object)this.localAmtSum);
        }
        this.calculateDpAmt(targetBill);
    }

    private void calculateDpAmt(DynamicObject targetBill) {
        BigDecimal oldLossAmt;
        DynamicObject dpcurrency = targetBill.getDynamicObject("dpcurrency");
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        BigDecimal actPayAmt = targetBill.getBigDecimal("actpayamt");
        String agreedquotation = targetBill.getString("agreedquotation");
        String dppayquotation = targetBill.getString("dppayquotation");
        if (currency != null) {
            actPayAmt = actPayAmt.setScale(currency.getInt("amtprecision"), 4);
        }
        BigDecimal localAmt = targetBill.getBigDecimal("localamt");
        BigDecimal agreedRate = targetBill.getBigDecimal("agreedrate");
        BigDecimal dpExchangeRate = targetBill.getBigDecimal("dpexchangerate");
        BigDecimal applyAmount = targetBill.getBigDecimal("applyamount");
        if (CasHelper.isEmpty(applyAmount)) {
            targetBill.set("applylocalamt", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal applyLocalAmount = targetBill.getBigDecimal("applylocalamt");
            if (CasHelper.isEmpty(applyLocalAmount)) {
                applyLocalAmount = dpcurrency != null ? QuotationHelper.callToCurrency(applyAmount, dpExchangeRate, dppayquotation, dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(applyAmount, dpExchangeRate, dppayquotation, 10);
                targetBill.set("applylocalamt", (Object)applyLocalAmount);
            }
        }
        if (agreedRate.compareTo(new BigDecimal(0)) == 0) {
            return;
        }
        BigDecimal oldDpAmt = targetBill.getBigDecimal("dpamt");
        BigDecimal dpAmt = BigDecimal.ZERO;
        if (CasHelper.isEmpty(oldDpAmt)) {
            dpAmt = dpcurrency != null ? QuotationHelper.callToCurrency(actPayAmt, agreedRate, agreedquotation, dpcurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(actPayAmt, agreedRate, agreedquotation, 10);
            targetBill.set("dpamt", (Object)dpAmt);
        }
        BigDecimal oldDpLocalAmt = targetBill.getBigDecimal("dplocalamt");
        BigDecimal dpLocalAmt = BigDecimal.ZERO;
        if (CasHelper.isEmpty(oldDpLocalAmt)) {
            dpLocalAmt = basecurrency != null ? QuotationHelper.callToCurrency(dpAmt, dpExchangeRate, dppayquotation, basecurrency.getInt("amtprecision")) : QuotationHelper.callToCurrency(dpAmt, dpExchangeRate, dppayquotation, 10);
            targetBill.set("dplocalamt", (Object)dpLocalAmt);
        }
        if (CasHelper.isEmpty(oldLossAmt = targetBill.getBigDecimal("lossamt"))) {
            targetBill.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
        }
    }

    private void setPayCountryValue(DynamicObject targetBill, Map<Long, DynamicObject> finOrgInfoMap) {
        DynamicObject payerBank = targetBill.getDynamicObject("payerbank");
        if (payerBank != null && CasHelper.isEmpty(targetBill.getDynamicObject("paycountry")) && CasHelper.isNotEmpty(payerBank = finOrgInfoMap.get(payerBank.getPkValue()))) {
            targetBill.set("paycountry", (Object)payerBank.getDynamicObject("country"));
        }
    }

    private void dealSupplePayeeInfo(DynamicObject targetBill, Map<Long, DynamicObject> payeeDynamicObjects, Map<Long, DynamicObject> addressDynamicObject, Set<Long> payeeId) {
        DynamicObject payeebank;
        DynamicObject payeeDynamicObject;
        Object payee = targetBill.get("payee");
        Object payeeType = targetBill.get("payeetype");
        String billName = targetBill.getDataEntityType().getName();
        Object payeeBankNum = targetBill.get("payeebanknum");
        Map<String, Object> resultMap = CasPayeeOrPayerHelper.getPayeeOrPayerInfo(payeeBankNum, payee, payeeType, billName, payeeDynamicObject = payeeDynamicObjects.get(payee), addressDynamicObject);
        if (resultMap.size() > 0 && !CasHelper.isEmpty(payeebank = (DynamicObject)resultMap.get("payeebank"))) {
            payeeId.add(payeebank.getLong("id"));
        }
    }

    private void supplePayeeInfo(DynamicObject targetBill, Map<Long, DynamicObject> payeeDynamicObjects, Map<Long, DynamicObject> addressDynamicObject, Map<Object, DynamicObject> payeeIdMap) {
        DynamicObject payeeDynamicObject;
        Object payee = targetBill.get("payee");
        Object payeeType = targetBill.get("payeetype");
        String payeeName = targetBill.getString("payeename");
        String billName = targetBill.getDataEntityType().getName();
        Object payeeBankNum = targetBill.get("payeebanknum");
        Map<String, Object> resultMap = CasPayeeOrPayerHelper.getPayeeOrPayerInfo(payeeBankNum, payee, payeeType, billName, payeeDynamicObject = payeeDynamicObjects.get(payee), addressDynamicObject);
        if (resultMap.size() > 0) {
            Object bankaccount = resultMap.get("payeebanknum");
            Object accountname = resultMap.get("accountname");
            DynamicObject payeebank = (DynamicObject)resultMap.get("payeebank");
            this.setValueIfAbsent(targetBill, "payeebanknum", bankaccount);
            this.setValueIfAbsent(targetBill, "recaccbankname", accountname);
            this.setValueIfAbsent(targetBill, "recemail", resultMap.get("payeeemail"));
            this.setValueIfAbsent(targetBill, "recaddress", resultMap.get("payeeaddress"));
            this.setValueIfAbsent(targetBill, "payeenumber", resultMap.get("payeenumber"));
            this.setValueIfAbsent(targetBill, "payeename", resultMap.get("payeename"));
            if (!CasHelper.isEmpty(payeebank) && CasHelper.isNotEmpty(payeebank = payeeIdMap.get(payeebank.getPkValue()))) {
                this.setValueIfAbsent(targetBill, "payeebank", payeebank);
                this.setValueIfAbsent(targetBill, "payeebankname", payeebank.getString("name"));
                this.setValueIfAbsent(targetBill, "reccountry", payeebank.getLong("country.id"));
                this.setValueIfAbsent(targetBill, "recprovince", payeebank.getString("provincetxt"));
                this.setValueIfAbsent(targetBill, "reccity", payeebank.getString("citytxt"));
                this.setValueIfAbsent(targetBill, "recbanknumber", payeebank.getString("union_number"));
                this.setValueIfAbsent(targetBill, "recswiftcode", payeebank.getString("swift_code"));
                this.setValueIfAbsent(targetBill, "recroutingnum", payeebank.getString("routingnum"));
                this.setValueIfAbsent(targetBill, "recothercode", payeebank.getString("other_code"));
                this.setValueIfAbsent(targetBill, "recbankaddress", payeebank.getString("address_eng"));
            }
        } else {
            resultMap = CasPayeeOrPayerHelper.getUserOrOrgNumber(payee, payeeType);
            if (!resultMap.isEmpty()) {
                this.setValueIfAbsent(targetBill, "payeenumber", resultMap.get("payeenumber"));
            }
        }
        Long payeeLong = targetBill.getLong("payee");
        String payeeTypeString = targetBill.getString("payeetype");
        targetBill.set("ispersonpay", (Object)this.isPersonPay(payeeTypeString, payeeLong, payeeName, payeeDynamicObject));
    }

    private void setSettleorg(DynamicObject targetBill) {
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        DynamicObject openorg = targetBill.getDynamicObject("openorg");
        for (DynamicObject rowInfo : entry) {
            this.setValueIfAbsent(rowInfo, "settleorg", openorg);
        }
    }

    private void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty(targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private void setFeePayerDefaultValue(DynamicObject targetBill, DynamicObject baseCurrency, Map<Long, DynamicObject> supplierIdMap) {
        String value = "01";
        String payeeType = targetBill.get("payeetype").toString();
        String pushValue = targetBill.getString("feepayer");
        if (EmptyUtil.isNoEmpty(pushValue)) {
            return;
        }
        if (AsstActTypeEnum.SUPPLIER.getValue().equals(payeeType)) {
            DynamicObject supplier;
            Long payeeId = Long.valueOf(targetBill.get("payee").toString());
            String payeeBankNum = targetBill.get("payeebanknum").toString();
            if (null != baseCurrency && CasHelper.isNotEmpty(payeeId) && CasHelper.isNotEmpty(payeeBankNum) && Objects.nonNull(supplier = supplierIdMap.get(payeeId))) {
                value = Optional.ofNullable(supplier.getString("entry_bank.commissionbearer")).map(commissionbearer -> String.format("0%s", commissionbearer)).orElseGet(() -> "01");
            }
        }
        targetBill.set("feepayer", (Object)value);
    }

    private void fillFundflowItem(DynamicObject targetBill, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject row : entry) {
            this.setValueIfAbsent(row, "e_fundflowitem", defaultFundsItem);
        }
    }

    private boolean isPersonPay(String payeeType, Long payee, String payeeName, DynamicObject payeeObject) {
        logger.info("\u4ed8\u6b3e\u5355\u662f\u5426\u5bf9\u79c1\u4ed8\u6b3e\u5224\u65ad\uff1apayeeType={}\uff0cpayee={},payeeName={}", new Object[]{payeeType, payee, payeeName});
        if (StringUtils.isEmpty((CharSequence)payeeType)) {
            return true;
        }
        if ("bos_user".equals(payeeType)) {
            return true;
        }
        if ("bd_supplier".equals(payeeType) || "bd_customer".equals(payeeType)) {
            if (payee == 0L) {
                return false;
            }
            if (payeeObject != null) {
                return "4".equals(payeeObject.getString("type"));
            }
        } else {
            if ("bos_org".equals(payeeType)) {
                return false;
            }
            if ("other".equals(payeeType)) {
                return false;
            }
        }
        return true;
    }

    private void setValueProjectAndContract(DynamicObject targetBill, Map<Object, DynamicObject> projectAndContractInfoMap) {
        String sourType = targetBill.getString("sourcebilltype");
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if ("ap_finapbill".equals(sourType)) {
            for (DynamicObject row : entry) {
                Object srcBillId = row.get("e_sourcebillid");
                DynamicObject info = projectAndContractInfoMap.get(srcBillId);
                if (ObjectUtils.isEmpty((Object)info)) continue;
                if (CasHelper.isEmpty(row.get("project"))) {
                    row.set("project", info.get("project"));
                }
                if (CasHelper.isEmpty(row.get("contractnumber"))) {
                    row.set("contractnumber", info.get("e_contract"));
                }
                if (CasHelper.isEmpty(row.get("conbillentity"))) {
                    row.set("conbillentity", info.get("e_conbillentity"));
                }
                if (CasHelper.isEmpty(row.get("conbillnumber"))) {
                    row.set("conbillnumber", info.get("e_conbillnumber"));
                }
                if (!CasHelper.isEmpty(row.get("conbillid"))) continue;
                row.set("conbillid", info.get("e_conbillid"));
            }
        }
    }

    private static int getApParam(Object orgPk, String param) {
        int result = 1;
        AppParam appParam = new AppParam("+HKZHSKFXOX", Long.valueOf(Long.parseLong(orgPk.toString())));
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        Object settleParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)param);
        if (settleParam != null) {
            result = Integer.parseInt(settleParam.toString());
        }
        return result;
    }
}

