/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.ext.fi.cal.function.GetBizBillFieldValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;

public class BatchGetBizBillFieldValue
implements BOSUDFunction,
IBatchFunctionHandler {
    private static final Log logger = LogFactory.getLog(GetBizBillFieldValue.class);
    private ExpressionContext expContext;

    public BatchGetBizBillFieldValue() {
    }

    public BatchGetBizBillFieldValue(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expressionContext) {
        return new BatchGetBizBillFieldValue(expressionContext);
    }

    public Object call(Object ... arg) {
        String entityobject = (String)arg[0];
        Object bizbillentryid = arg[1];
        String billfield = (String)arg[2];
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityobject);
        if (bizEntityType == null) {
            return null;
        }
        String entryKey = this.getEntryKey(bizEntityType);
        String selectField = this.getSelectField(bizEntityType, billfield);
        if (StringUtils.isEmpty((String)selectField)) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)entryKey) && StringUtils.isNotEmpty((String)selectField)) {
            QFilter qFilter = new QFilter(entryKey + ".id", "=", bizbillentryid);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityobject, (String)selectField, (QFilter[])qFilter.toArray(), null);){
                if (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object object = row.get(selectField);
                    return object;
                }
            }
        }
        return null;
    }

    private String getSelectField(MainEntityType bizEntityType, String billfield) {
        if (StringUtils.isEmpty((String)billfield)) {
            return null;
        }
        IDataEntityProperty dataEntity = bizEntityType.findProperty(billfield.split("\\.")[0]);
        if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
            return dataEntity.getParent().getName() + "." + billfield;
        }
        if (dataEntity != null) {
            return billfield;
        }
        return null;
    }

    public String getName() {
        return "GetBizBillFieldValue";
    }

    private String getEntryKey(MainEntityType bizEntityType) {
        for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
            return entityType.getName();
        }
        return null;
    }

    @Override
    public Map<Function, Object> execute(Set<Function> args) {
        Long startTime = System.currentTimeMillis();
        logger.info("GetBizBillFieldValue_execute_" + startTime + ":begin");
        HashMap<Function, Object> resultMap = new HashMap<Function, Object>(100);
        HashMap entryTofunctionFieldMap = new HashMap(100);
        HashMap entityobjectToIds = new HashMap(100);
        HashMap entityobjectToFilterFields = new HashMap(100);
        HashMap entityobjectToSelectFields = new HashMap(100);
        HashSet entityobjects = new HashSet(100);
        args.forEach(fun -> {
            List<Object> param = fun.getParams();
            String entityobject = (String)param.get(0);
            Long bizbillentryid = (Long)param.get(1);
            String selectfiled = (String)param.get(2);
            MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityobject);
            String selectField = this.getSelectField(bizEntityType, selectfiled);
            if (!StringUtils.isEmpty((String)selectField) && !StringUtils.isEmpty((String)entityobject)) {
                Set currSelectFields;
                Map funToFieldsMap = (Map)entryTofunctionFieldMap.get(bizbillentryid);
                if (funToFieldsMap != null) {
                    funToFieldsMap.put(fun, selectField);
                } else {
                    HashMap<Function, String> currFunToFieldsMap = new HashMap<Function, String>(1);
                    currFunToFieldsMap.put((Function)fun, selectField);
                    entryTofunctionFieldMap.put(bizbillentryid, currFunToFieldsMap);
                }
                if (!entityobjectToIds.containsKey(entityobject)) {
                    HashSet<Long> ids = new HashSet<Long>(100);
                    ids.add(bizbillentryid);
                    entityobjectToIds.put(entityobject, ids);
                } else {
                    ((Set)entityobjectToIds.get(entityobject)).add(bizbillentryid);
                }
                if (!entityobjectToFilterFields.containsKey(entityobject) && bizEntityType != null) {
                    String entryKey = this.getEntryKey(bizEntityType);
                    entityobjectToFilterFields.put(entityobject, entryKey);
                }
                if ((currSelectFields = (Set)entityobjectToSelectFields.get(entityobject)) == null || currSelectFields.isEmpty()) {
                    if (!StringUtils.isEmpty((String)selectField)) {
                        HashSet<String> selectFields = new HashSet<String>(100);
                        selectFields.add(selectField);
                        entityobjectToSelectFields.put(entityobject, selectFields);
                    }
                } else {
                    currSelectFields.add(selectField);
                }
                entityobjects.add(entityobject);
            }
        });
        for (String entityobjectNum : entityobjects) {
            String entry = (String)entityobjectToFilterFields.get(entityobjectNum);
            Set selectFields = (Set)entityobjectToSelectFields.get(entityobjectNum);
            Set entryIds = (Set)entityobjectToIds.get(entityobjectNum);
            StringBuilder selectFieldStrBd = new StringBuilder();
            for (String field : selectFields) {
                selectFieldStrBd.append(field).append(",");
            }
            String selectFieldStr = selectFieldStrBd.substring(0, selectFieldStrBd.length() - 1);
            if (!StringUtils.isNotEmpty((String)entry) || !StringUtils.isNotEmpty((String)selectFieldStr)) continue;
            QFilter qFilter = new QFilter(entry + ".id", "in", (Object)entryIds);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityobjectNum, (String)(selectFieldStr + "," + entry + ".id as entryid"), (QFilter[])qFilter.toArray(), null);
            Throwable throwable = null;
            try {
                for (Row row : dataSet) {
                    Map funToFieldsMap = (Map)entryTofunctionFieldMap.get(row.getLong("entryid"));
                    if (funToFieldsMap == null || funToFieldsMap.isEmpty()) continue;
                    for (Map.Entry fun2 : funToFieldsMap.entrySet()) {
                        resultMap.put((Function)fun2.getKey(), row.get((String)fun2.getValue()));
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        logger.info("GetBizBillFieldValue_execute:end,resultMap.size:" + resultMap.size());
        Long endTime = System.currentTimeMillis();
        logger.info("GetBizBillFieldValue_execute_time_" + startTime + ":" + (endTime - startTime) + "ms");
        return resultMap;
    }
}

