/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.fatvs.notification;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.notification.AbstractNotificationClick;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.events.ButtonClickEventArgs;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class DetailClick
extends AbstractNotificationClick {
    private static final Log log = LogFactory.getLog(DetailClick.class);
    private static final String DETAIL_BUTTON_KEY = "detail";
    private static final IAppCache APP_CACHE = AppCache.get((String)"fi-fatvs");

    public void closeCallBack() {
        super.closeCallBack();
        String msgId = this.getNotificationId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        MessageCenterServiceHelper.setMessagePopup((Long)Long.valueOf(msgId), Collections.singletonList(userId), (boolean)false);
    }

    public void buttonClick(ButtonClickEventArgs e) {
        String buttonKey = e.getButtonKey();
        String notificationId = this.getNotificationId();
        if (notificationId == null) {
            return;
        }
        switch (buttonKey) {
            case "detail": {
                this.viewMsg(notificationId);
                this.setMsgReadState(notificationId);
                break;
            }
            default: {
                this.setMsgReadState(notificationId);
            }
        }
    }

    private void viewMsg(String notificationId) {
        Map messageMap = MessageCenterServiceHelper.getMessageById(Collections.singletonList(Long.parseLong(notificationId)));
        List messageList = (List)messageMap.get("messageInfos");
        if (messageList != null && !messageList.isEmpty() && messageList.get(0) != null) {
            MessageInfo messageInfo = (MessageInfo)messageList.get(0);
            Map systemNotice = messageInfo.getParams();
            int noticeType = (Integer)((Map)systemNotice.get("systemNotice")).get("bizType");
            long employeeId = (Long)((Map)systemNotice.get("systemNotice")).get("employeeId");
            log.info(String.format("DetailClick---viewMsg:\u6253\u5f00\u6570\u5b57\u4eba\u4ea4\u4e92\u7a97\u53e3, user:%s-%s, employee:%s, noticeType:%s", RequestContext.get().getCurrUserId(), RequestContext.get().getUserName(), employeeId, noticeType));
            this.showInteraction(this.getFormView(), employeeId, noticeType, true);
        } else {
            log.warn(String.format("DetailClick---viewMsg:notificationId:%s\u67e5\u4e0d\u5230\u6d88\u606f\u5b9e\u4f53", notificationId));
        }
    }

    private void showInteraction(IFormView view, long employeeId, int tabIdx, boolean backHomePage) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>(4);
        paramMap.put("employeeId", Long.valueOf(employeeId));
        paramMap.put("tabIdx", Integer.valueOf(tabIdx >= 0 && tabIdx <= 2 ? tabIdx : 0));
        paramMap.put("backHomePage", Boolean.valueOf(backHomePage));
        paramMap.put("supTabIdx", Integer.valueOf(1));
        APP_CACHE.put("FATVSRightParam_" + RequestContext.get().getCurrUserId(), (Object)SerializationUtils.toJsonString(paramMap));
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("direction", "right");
        map.put("formId", "fatvs_interaction");
        HashMap<String, String> offset = new HashMap<String, String>(1);
        offset.put("top", "50");
        map.put("offsetInAllDC", offset);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction("setSlideBillFormId", map);
        HashMap<String, String> showSlideBillMap = new HashMap<String, String>(1);
        showSlideBillMap.put("formId", "fatvs_interaction");
        proxy.addAction("showSlideBill", showSlideBillMap);
    }

    private void setMsgReadState(String msgId) {
        String userIdString = RequestContext.get().getUserId();
        Long userId = RequestContext.get().getCurrUserId();
        if (msgId != null) {
            MessageCenterServiceHelper.setMsgReadState((Long)Long.valueOf(msgId), Collections.singletonList(userId));
        }
        NotificationServiceHelper.sendIgnoreNotification((String)userIdString, (String)msgId);
        NotificationClientCache.removeNotification((String)userIdString, (String)msgId);
    }
}

