/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.fatvs.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.notification.AbstractNotificationClick;
import kd.bos.notification.NotificationClientCache;
import kd.bos.notification.events.ButtonClickEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class UrgeDoDetailClick
extends AbstractNotificationClick {
    private static final Log logger = LogFactory.getLog(UrgeDoDetailClick.class);
    private static final String DETAIL_BUTTON_KEY = "detail";

    public void buttonClick(ButtonClickEventArgs eventArgs) {
        String key;
        String notificationId = this.getNotificationId();
        switch (key = eventArgs.getButtonKey()) {
            case "detail": {
                this.showMsgCenterDetail(this.getFormView(), notificationId);
                this.setMsgReadState(notificationId);
                break;
            }
            default: {
                this.setMsgReadState(notificationId);
            }
        }
    }

    private void showDetail(String msgId) {
        String msgdetailtype;
        IFormView formView = this.getFormView();
        if (formView == null) {
            logger.info("UrgeDoDetailClick--showDetail--formView is null");
            return;
        }
        Map systemNotice = null;
        Map messageMap = MessageCenterServiceHelper.getMessageById(Collections.singletonList(Long.parseLong(msgId)));
        if (CollectionUtils.isEmpty((Map)messageMap)) {
            this.showMsgCenterDetail(formView, msgId);
            return;
        }
        List messageList = (List)messageMap.get("messageInfos");
        if (messageList != null && !messageList.isEmpty() && messageList.get(0) != null) {
            MessageInfo messageInfo = (MessageInfo)messageList.get(0);
            systemNotice = messageInfo.getParams();
        }
        Map param = null;
        if (CollectionUtils.isEmpty(systemNotice)) {
            this.showMsgCenterDetail(formView, msgId);
            return;
        }
        param = (Map)systemNotice.get("systemNotice");
        if (CollectionUtils.isEmpty((Map)param)) {
            this.showMsgCenterDetail(formView, msgId);
            return;
        }
        switch (msgdetailtype = param.get("msgdetailtype").toString()) {
            case "3": {
                break;
            }
            case "2": {
                this.showBillForm(formView, param);
                break;
            }
            default: {
                this.showMsgCenterDetail(formView, msgId);
            }
        }
    }

    private void showBillForm(IFormView formView, Map<String, Object> param) {
        String messagelink = param.get("messagelink").toString();
        Object pkId = param.get("pkId");
        if (Objects.isNull(pkId) || 0L == (Long)pkId) {
            return;
        }
        this.showForm(formView, messagelink, pkId);
    }

    public void showForm(IFormView view, String formId, Object pkId) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(pkId);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)billShowParameter);
    }

    private void showMsgCenterDetail(IFormView formView, String msgId) {
        if (null == formView) {
            return;
        }
        logger.info(String.format("UrgeDoDetailClick--showDetail--1 msgId:%s", msgId));
        if (formView.getMainView() == null) {
            formView.openUrl("?formId=wf_msg_center");
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("view", formView);
            map.put("appmainnumber", "wf_msg_center");
            map.put("appname", AppMetadataCache.getAppInfo((String)"wftask").getName());
            HashMap<String, Number> customparameters = new HashMap<String, Number>(2);
            customparameters.put("tabType", 2);
            customparameters.put("messageId", Long.valueOf(msgId));
            map.put("customparameters", customparameters);
            OpenPageUtils.openApp((String)"wftask", (String)null, map, (IFormView)formView);
        }
    }

    private void setMsgReadState(String msgId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (msgId != null) {
            MessageCenterServiceHelper.setMsgReadState((Long)Long.valueOf(msgId), Collections.singletonList(userId));
        }
        NotificationServiceHelper.sendIgnoreNotification((String)RequestContext.get().getUserId(), (String)msgId);
        NotificationClientCache.removeNotification((String)RequestContext.get().getUserId(), (String)msgId);
    }
}

