/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.flexplugin.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.gl.flexplugin.AbstractCustomFlexFilter;
import kd.bos.ext.fi.gl.flexplugin.FilterArgs;
import kd.bos.ext.fi.gl.flexplugin.FilterInfo;
import kd.bos.ext.fi.gl.flexplugin.SourceType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BdAccBankFilter
extends AbstractCustomFlexFilter {
    private static final Log logger = LogFactory.getLog(BdAccBankFilter.class);

    @Override
    public FilterInfo getCustomFilter(FilterArgs filterArgs) {
        SourceType sourceType;
        logger.info("filterArgs:{}", (Object)JSONObject.toJSONString((Object)filterArgs));
        Long orgId = filterArgs.getOrgId();
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        orgIdList.add(orgId);
        List<Long> curIdList = filterArgs.getCurIds();
        Set<Long> bankOrgIds = filterArgs.getBankOrgIds();
        QFilter bFilters = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", orgIdList, (boolean)true);
        if (!bankOrgIds.isEmpty()) {
            logger.info("\u59d4\u6258\u7684\u8d44\u91d1\u7ec4\u7ec7\uff1a{}", (Object)JSONArray.toJSONString(bankOrgIds));
            bFilters.or(new QFilter("company", "in", bankOrgIds));
        }
        if (null != curIdList && curIdList.size() > 0) {
            bFilters.and(new QFilter("currency.fbasedataid", "in", curIdList));
        }
        if (ObjectUtils.isEmpty((Object)((Object)(sourceType = filterArgs.getSourceType()))) || sourceType != SourceType.report) {
            bFilters.and(new QFilter("acctstatus", "!=", (Object)"closed"));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.setFilter(bFilters);
        filterInfo.setIgnoreSysFilter(false);
        this.resetFilter(filterArgs);
        return filterInfo;
    }

    private void resetFilter(FilterArgs filterArgs) {
        logger.info("\u8fdb\u5165BdAccBankFilter.resetFilter");
        boolean isClearCoreFilter = filterArgs.isClearcorefilter();
        logger.info("isClearCoreFilter:{}", (Object)isClearCoreFilter);
        if (isClearCoreFilter) {
            List<QFilter> qFilters = filterArgs.getqFilters();
            ArrayList<QFilter> waitDelQfilters = new ArrayList<QFilter>();
            ArrayList waitAddQfilters = new ArrayList();
            QFilter orgFilter = null;
            for (int i = 0; i < qFilters.size(); ++i) {
                QFilter qFilter = qFilters.get(i);
                if (null == qFilter) continue;
                if (qFilter.toString().contains("t_bd_accountbanks_U") && i == 0) {
                    waitDelQfilters.add(qFilter);
                    continue;
                }
                if (!qFilter.toString().contains("company")) continue;
                try {
                    waitDelQfilters.add(qFilter);
                    Pair<QFilter, List<QFilter>> splitQFilters = this.splitQFilter(qFilter);
                    if (null == splitQFilters) continue;
                    orgFilter = null == orgFilter ? (QFilter)splitQFilters.getLeft() : orgFilter.or((QFilter)splitQFilters.getLeft());
                    if (CollectionUtils.isEmpty((Collection)((Collection)splitQFilters.getRight()))) continue;
                    waitAddQfilters.addAll((Collection)splitQFilters.getRight());
                    continue;
                }
                catch (Exception e2) {
                    logger.error("qfilter resolve error", (Throwable)e2);
                }
            }
            if (!CollectionUtils.isEmpty(waitDelQfilters)) {
                logger.info("waitDelQfilters:{}", (Object)((Object)waitDelQfilters).toString());
                qFilters.removeAll(waitDelQfilters);
            }
            if (null != orgFilter) {
                logger.info("orgFilter:{}", (Object)orgFilter.toString());
                qFilters.add(orgFilter);
            }
            if (!CollectionUtils.isEmpty(waitAddQfilters)) {
                logger.info("waitAddQfilters:{}", (Object)((Object)waitAddQfilters).toString());
                qFilters.addAll(waitAddQfilters);
            }
        }
    }

    private Pair<QFilter, List<QFilter>> splitQFilter(QFilter qFilter) {
        QFilter filter = null;
        ArrayList<QFilter> addFilter = new ArrayList<QFilter>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        if (qFilter.getProperty().equals("company")) {
            Object qfilterValue = qFilter.getValue();
            if (qfilterValue instanceof List) {
                orgIds.addAll((List)qfilterValue);
            } else if (qfilterValue instanceof Long) {
                orgIds.add((Long)qfilterValue);
            } else if (qfilterValue instanceof Integer) {
                orgIds.add(Long.valueOf(((Integer)qfilterValue).intValue()));
            }
        } else {
            addFilter.add(qFilter);
        }
        List nestQfilters = qFilter.getNests(true);
        if (!CollectionUtils.isEmpty((Collection)nestQfilters)) {
            for (QFilter.QFilterNest qFilterNest : nestQfilters) {
                QFilter nestfilter = qFilterNest.getFilter();
                if (nestfilter.getProperty().equals("company")) {
                    Object nestfilterValue = nestfilter.getValue();
                    if (nestfilterValue instanceof List) {
                        orgIds.addAll((List)nestfilterValue);
                        continue;
                    }
                    if (nestfilterValue instanceof HashSet) {
                        orgIds.addAll((HashSet)nestfilterValue);
                        continue;
                    }
                    if (!(nestfilterValue instanceof Long)) continue;
                    orgIds.add((Long)nestfilterValue);
                    continue;
                }
                addFilter.add(new QFilter(nestfilter.getProperty(), nestfilter.getCP(), nestfilter.getValue()));
            }
        }
        for (Long orgId : orgIds) {
            if (null == filter) {
                filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgId);
                continue;
            }
            filter = filter.or(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)orgId));
        }
        return Pair.of(filter, addFilter);
    }
}

