/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ViewApInvoice
extends FormOperate {
    private static final Log logger = LogFactory.getLog(ViewApInvoice.class);

    protected OperationResult invokeOperation() {
        String entityId = this.getEntityId();
        List<Object> billIds = this.getSelectedBillIds();
        if (billIds.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ViewApInvoice_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        if (billIds.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"ViewApInvoice_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        long billId = Long.parseLong(String.valueOf(billIds.get(0)));
        ArrayList<Long> finApBillIds = new ArrayList<Long>(64);
        if ("ap_finapbill".equals(entityId)) {
            finApBillIds.add(billId);
        } else {
            Map sourceBills;
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityId, (Long[])new Long[]{billId});
            if (!ObjectUtils.isEmpty((Object)targetBills) && !ObjectUtils.isEmpty(targetBills.get("ap_finapbill"))) {
                finApBillIds.addAll((Collection)targetBills.get("ap_finapbill"));
            }
            if (finApBillIds.isEmpty() && !ObjectUtils.isEmpty((Object)(sourceBills = BFTrackerServiceHelper.findSourceBills((String)entityId, (Long[])new Long[]{billId}))) && !ObjectUtils.isEmpty(sourceBills.get("ap_finapbill"))) {
                finApBillIds.addAll((Collection)sourceBills.get("ap_finapbill"));
            }
        }
        if (finApBillIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u5173\u8054\u8d22\u52a1\u5e94\u4ed8\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ViewApInvoice_2", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        Map viewInvoiceMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApViewInvoiceService", (String)"buildViewInvoiceParams", (Object[])new Object[]{finApBillIds});
        if (ObjectUtils.isEmpty((Object)viewInvoiceMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u672a\u5173\u8054\u6765\u81ea\u53d1\u7968\u4e91\u7684\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ViewApInvoice_3", (String)"bos-ext-fi", (Object[])new Object[0]));
            return null;
        }
        logger.info("ViewApInvoice viewInvoiceMap : " + viewInvoiceMap);
        boolean isOldInvCloud = this.isOldInvCloud();
        logger.info("ViewApInvoice isOldInvCloud : " + isOldInvCloud);
        String viewInvoicePageEntity = isOldInvCloud ? "er_invoicecloudpage_pc" : "rim_view_invoice";
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(viewInvoicePageEntity);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParams(viewInvoiceMap);
        parameter.setShowTitle(false);
        this.getView().showForm(parameter);
        return null;
    }

    private List<Object> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        ArrayList<Object> billIds = new ArrayList<Object>(32);
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }

    private boolean isOldInvCloud() {
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"invoicecloud.invoicecloudxh")});
        return queryOne == null || !"true".equals(queryOne.getString("value"));
    }
}

