/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AsstactConvertHelper {
    public static void setAccountBankField(ExtendedDataEntity[] entities, String entryField, String asstacttypeField, String asstactField, String accountField, String bebankField) {
        HashMap<String, Set> asstactMap = new HashMap<String, Set>(2);
        String asstactIdField = asstactField + ".id";
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(bill.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(bill.getLong(asstactIdField));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(entry.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(entry.getLong(asstactIdField));
            }
        }
        if (ObjectUtils.isEmpty(asstactMap)) {
            return;
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry asstactEntry : asstactMap.entrySet()) {
            switch ((String)asstactEntry.getKey()) {
                case "bos_user": {
                    accbebankMapByAsstactId.putAll(AsstactConvertHelper.getErPayeerAccbebankMap((Set)asstactEntry.getValue()));
                    break;
                }
                case "bd_customer": 
                case "bd_supplier": {
                    accbebankMapByAsstactId.putAll(AsstactConvertHelper.getCusOrSupAccbebankMap((String)asstactEntry.getKey(), (Set)asstactEntry.getValue()));
                }
            }
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(bill.getLong(asstactIdField))))) continue;
                bill.set(accountField, accountBankInfo.get("accountStr"));
                bill.set(bebankField, accountBankInfo.get("bebank"));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(entry.getLong(asstactIdField))))) continue;
                entry.set(accountField, accountBankInfo.get("accountStr"));
                entry.set(bebankField, accountBankInfo.get("bebank"));
            }
        }
    }

    public static Map<Long, Map<String, Object>> getErPayeerAccbebankMap(Set<Long> userIds) {
        if (ObjectUtils.isEmpty(userIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByUserId = new HashMap<Long, Map<String, Object>>(userIds.size());
        QFilter uFilter = new QFilter("payer", "in", userIds);
        uFilter = uFilter.and("status", "=", (Object)"C");
        uFilter = uFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map payeerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount", (QFilter[])new QFilter[]{uFilter});
        for (DynamicObject payeer : payeerMap.values()) {
            Long userId = payeer.getLong("payer.id");
            HashMap<String, Object> map = (HashMap<String, Object>)accbebankMapByUserId.get(userId);
            if (!ObjectUtils.isEmpty((Object)map) && !payeer.getBoolean("isdefault")) continue;
            map = new HashMap<String, Object>(4);
            map.put("accountStr", payeer.getString("payeraccount"));
            map.put("bebank", payeer.getDynamicObject("payerbank"));
            map.put("bebankId", payeer.getLong("payerbank.id"));
            map.put("bebankName", payeer.getString("payerbank.name"));
            accbebankMapByUserId.put(userId, map);
        }
        return accbebankMapByUserId;
    }

    public static Map<Long, Map<String, Object>> getCusOrSupAccbebankMap(String asstactType, Set<Long> asstactIds) {
        if (ObjectUtils.isEmpty(asstactIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(asstactIds.size());
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)asstactType, (String)"id,settlementtypeid,tx_register_no,bizpartner_address,bizpartner_phone,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (DynamicObject asstact : asstactMap.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
            for (DynamicObject bankInfo : bankColls) {
                if (!ObjectUtils.isEmpty(map) && !bankInfo.getBoolean("isdefault_bank")) continue;
                map.put("accountStr", bankInfo.getString("bankaccount"));
                map.put("bebank", bankInfo.getDynamicObject("bank"));
                map.put("bebankId", bankInfo.getLong("bank.id"));
                map.put("bebankName", bankInfo.getString("bank.name"));
            }
            map.put("settlementtypeid", asstact.getDynamicObject("settlementtypeid"));
            map.put("tx_register_no", asstact.getString("tx_register_no"));
            map.put("bizpartner_address", asstact.getLocaleString("bizpartner_address").getLocaleValue_zh_CN());
            map.put("bizpartner_phone", asstact.getString("bizpartner_phone"));
            accbebankMapByAsstactId.put(asstact.getLong("id"), map);
        }
        return accbebankMapByAsstactId;
    }

    public static void setAccountBankField(DynamicObject asstact, DynamicObject entity, String accountField, String bebankField) {
        if (entity.get(accountField) != null && entity.get(bebankField) != null) {
            return;
        }
        if (asstact != null) {
            Map<String, Object> accountBankInfo = AsstactConvertHelper.getAccountBankInfo(asstact);
            entity.set(accountField, accountBankInfo.get("accountStr"));
            entity.set(bebankField, accountBankInfo.get("bebank"));
        }
    }

    private static Map<String, Object> getAccountBankInfo(DynamicObject asstact) {
        String accountStr = "";
        DynamicObject bebank = null;
        String asstactType = asstact.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject erPayeeInfo = AsstactConvertHelper.getErPayeeInfo(asstact.getLong("id"));
            if (erPayeeInfo != null) {
                bebank = erPayeeInfo.getDynamicObject("payerbank");
                accountStr = erPayeeInfo.getString("payeraccount");
            }
        } else if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            DynamicObjectCollection bankInfoCollection = asstact.getDynamicObjectCollection("entry_bank");
            DynamicObject bankInfo = null;
            if (bankInfoCollection.size() > 0) {
                bankInfo = (DynamicObject)bankInfoCollection.get(0);
            }
            for (int i = 0; i < bankInfoCollection.size(); ++i) {
                DynamicObject bank = (DynamicObject)bankInfoCollection.get(i);
                if (!bank.getBoolean("isdefault_bank")) continue;
                bankInfo = bank;
                break;
            }
            if (bankInfo != null) {
                accountStr = bankInfo.getString("bankaccount");
                bebank = bankInfo.getDynamicObject("bank");
                if (!ObjectUtils.isEmpty((Object)bebank)) {
                    // empty if block
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountStr", accountStr);
        map.put("bebank", bebank);
        return map;
    }

    private static DynamicObject getErPayeeInfo(long userId) {
        String orderBys;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,payerbank,payeraccount";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    public static void checkAsstactType(List<DynamicObject> entities) {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SZJK-PRE-0120")});
        if (ObjectUtils.isEmpty((Object)execcontrols)) {
            return;
        }
        List<String> asstactTypeList = Arrays.asList("bd_customer", "bd_supplier", "bos_user");
        for (DynamicObject ctrl : execcontrols) {
            if (!ctrl.getBoolean("enable")) continue;
            for (DynamicObject entity : entities) {
                String asstactType = entity.getString("asstacttype");
                if (asstactTypeList.contains(asstactType)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u76ee\u6807\u5355\u7684\u5f80\u6765\u7c7b\u578b\u987b\u4e3a\u5ba2\u6237\u3001\u4f9b\u5e94\u5546\u6216\u4eba\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstactConvertHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
        }
    }
}

