/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.fi.plugin.ArApConvert.util.ConfigCache;
import kd.bos.ext.fi.plugin.ArApConvert.util.EmptyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ArHiddenMenuExtService
implements IPortalAppMenuExtService {
    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(8);
        Set<String> arMenuIds = appIdAndMenuIdMap.get("/BBRH+122=39");
        if (arMenuIds != null && !arMenuIds.isEmpty()) {
            Map<String, String> configMap = ArHiddenMenuExtService.batchGetConfigValue("isHiddenOldBadDebt", "isHiddenManualSettle", "isHiddenArInvoice", "showDiffMenuByCus");
            boolean hiddenOldBadDebt = "true".equals(configMap.get("isHiddenOldBadDebt"));
            boolean hiddenManualSettle = "true".equals(configMap.get("isHiddenManualSettle"));
            boolean hiddenArInvoice = "true".equals(configMap.get("isHiddenArInvoice"));
            boolean showDiffMenuByCus = "true".equals(configMap.get("showDiffMenuByCus"));
            HashSet<String> hiddenMenuIds = new HashSet<String>(8);
            if (hiddenOldBadDebt) {
                hiddenMenuIds.addAll(this.getBadDebtHiddenMenuIds(arMenuIds));
            }
            if (hiddenManualSettle) {
                hiddenMenuIds.addAll(this.getManualSettleHiddenMenuIds(arMenuIds));
            }
            if (hiddenArInvoice) {
                hiddenMenuIds.addAll(this.getArInvoiceHiddenMenuIds(arMenuIds));
            }
            result.put("/BBRH+122=39", hiddenMenuIds);
            if (showDiffMenuByCus) {
                hiddenMenuIds.addAll(this.getShowMenuByCus(arMenuIds));
            }
        }
        return result;
    }

    private Set<String> getShowMenuByCus(Set<String> value) {
        HashSet<String> hiddenMenuIds = new HashSet<String>(8);
        hiddenMenuIds.add("/K1W7JWJY6N7");
        hiddenMenuIds.add("2015900493993233408");
        hiddenMenuIds.add("2036945066731244544");
        hiddenMenuIds.add("2015946201798559744");
        return hiddenMenuIds.stream().filter(e -> value.contains(e)).collect(Collectors.toSet());
    }

    private Set<String> getBadDebtHiddenMenuIds(Set<String> value) {
        HashSet<String> hiddenMenuIds = new HashSet<String>(8);
        hiddenMenuIds.add("/TW1GP3PW=7E");
        hiddenMenuIds.add("/T94UJR44/Q9");
        hiddenMenuIds.add("/SWWHWL5N7=E");
        return hiddenMenuIds.stream().filter(e -> value.contains(e)).collect(Collectors.toSet());
    }

    private Set<String> getManualSettleHiddenMenuIds(Set<String> value) {
        HashSet<String> hiddenMenuIds = new HashSet<String>(8);
        hiddenMenuIds.add("/PEW77G9B=C2");
        hiddenMenuIds.add("/FT0K3AIL4MV");
        return hiddenMenuIds.stream().filter(e -> value.contains(e)).collect(Collectors.toSet());
    }

    private Set<String> getArInvoiceHiddenMenuIds(Set<String> value) {
        HashSet<String> hiddenMenuIds = new HashSet<String>(8);
        hiddenMenuIds.add("/CLG+N5J618Q");
        hiddenMenuIds.add("/K1W7JWJY6N7");
        hiddenMenuIds.add("/H0QW70+2RHL");
        hiddenMenuIds.add("1+/44JK8BC=B");
        hiddenMenuIds.add("14OFA7P4STMT");
        return hiddenMenuIds.stream().filter(e -> value.contains(e)).collect(Collectors.toSet());
    }

    private static Map<String, String> batchGetConfigValue(String ... keys) {
        HashMap<String, String> configMap = new HashMap<String, String>(keys.length);
        HashSet<String> configKeySet = new HashSet<String>(keys.length);
        for (String key : keys) {
            String configValue = ConfigCache.get("ap_stdconfig", key, String.class);
            if (StringUtils.equalsIgnoreCase((CharSequence)configValue, (CharSequence)"NULL")) {
                configMap.put(key, null);
                ConfigCache.put("ap_stdconfig", key, "NULL");
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)configValue)) {
                ConfigCache.put("ap_stdconfig", key, configValue);
                configMap.put(key, configValue);
                continue;
            }
            configKeySet.add(key);
        }
        DynamicObjectCollection queryConfigColl = QueryServiceHelper.query((String)"ap_stdconfig", (String)"key,value", (QFilter[])new QFilter[]{new QFilter("key", "in", configKeySet)});
        if (ObjectUtils.isEmpty((Object)queryConfigColl)) {
            for (String key : configKeySet) {
                ConfigCache.put("ap_stdconfig", key, "NULL");
                configMap.put(key, null);
            }
        } else {
            for (DynamicObject config : queryConfigColl) {
                String key;
                key = config.getString("key");
                String value = config.getString("value");
                if (EmptyUtils.isNotEmpty(value)) {
                    ConfigCache.put("ap_stdconfig", key, value);
                    configMap.put(key, value);
                    continue;
                }
                ConfigCache.put("ap_stdconfig", key, "NULL");
                configMap.put(key, null);
            }
        }
        return configMap;
    }
}

